/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.mongodb.action;

import com.indy.addons.mongodb.action.MongoClientUtil;
import com.indy.addons.mongodb.action.ReverseDocAction;
import com.indy.ui.custom.out.services.IExternalValueResolver;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.stambia.md.MdNode;
import com.stambia.md.custom.exception.ReverseException;
import com.stambia.md.util.MdFactoryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.xpath.XPathExpressionException;
import org.bson.Document;
import org.eclipse.emf.ecore.EObject;

public class ReverseDocActionOnCollection
extends ReverseDocAction {
    private static final Logger LOGGER = Logger.getLogger(ReverseDocActionOnCollection.class.getName());

    public ReverseDocActionOnCollection() {
    }

    public ReverseDocActionOnCollection(IExternalValueResolver resolver) {
        super(resolver);
    }

    @Override
    protected List<MdNode> getNodes(MongoClient mongoClient, MdNode node) throws XPathExpressionException, ReverseException {
        MdNode databaseNode = (MdNode)node.eContainer();
        MdNode serverNode = (MdNode)databaseNode.eContainer();
        String databaseName = databaseNode.getName();
        String databasePhysicalName = databaseNode.evaluate("@physicalName");
        ArrayList<MdNode> nodes = new ArrayList<MdNode>();
        try {
            MongoDatabase mongoDatabase = mongoClient.getDatabase(databasePhysicalName);
            String collectionName = node.getName();
            String collectionPhysicalName = node.evaluate("@physicalName");
            MdNode databaseElement = MdFactoryHelper.createMdNode((String)"com.stambia.mongodb.database");
            databaseElement.setSubstituteContainer((EObject)serverNode);
            databaseElement.setName(databaseName);
            databaseElement.setAttribute("physicalName", databasePhysicalName, false);
            MdNode collection = MdFactoryHelper.createMdNode((String)"com.stambia.mongodb.collection");
            collection.setSubstituteContainer((EObject)databaseNode);
            collection.setName(collectionName);
            collection.setAttribute("physicalName", collectionPhysicalName, false);
            databaseElement.getNode().add((Object)collection);
            nodes.add(databaseElement);
            this.reverseType(collection, (MongoCollection<Document>)mongoDatabase.getCollection(collectionPhysicalName));
        }
        catch (Exception e) {
            MongoClientUtil.manageAuthorizationErrorOnReverse(e);
        }
        return nodes;
    }
}

