/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.mongodb.action;

import com.indy.addons.mongodb.action.MongoClientUtil;
import com.indy.addons.mongodb.action.ReverseDocAction;
import com.indy.ui.custom.out.services.IExternalValueResolver;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.stambia.md.MdNode;
import com.stambia.md.custom.exception.ReverseException;
import com.stambia.md.util.MdFactoryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.xpath.XPathExpressionException;
import org.bson.Document;
import org.eclipse.emf.ecore.EObject;

public class ReverseDocActionOnDatabase
extends ReverseDocAction {
    private static final Logger LOGGER = Logger.getLogger(ReverseDocActionOnDatabase.class.getName());

    public ReverseDocActionOnDatabase() {
    }

    public ReverseDocActionOnDatabase(IExternalValueResolver resolver) {
        super(resolver);
    }

    @Override
    protected List<MdNode> getNodes(MongoClient mongoClient, MdNode node) throws XPathExpressionException, ReverseException {
        ArrayList<MdNode> nodes = new ArrayList<MdNode>();
        try {
            MongoDatabase mongoDatabase = mongoClient.getDatabase(node.evaluate("@physicalName"));
            MdNode databaseElement = MdFactoryHelper.createMdNode((String)"com.stambia.mongodb.database");
            databaseElement.setSubstituteContainer(node.eContainer());
            databaseElement.setName(node.getName());
            databaseElement.setAttribute("physicalName", node.evaluate("@physicalName"), false);
            nodes.add(databaseElement);
            for (String collectionNameInsideMongodb : mongoDatabase.listCollectionNames()) {
                MdNode collection = MdFactoryHelper.createMdNode((String)"com.stambia.mongodb.collection");
                collection.setSubstituteContainer((EObject)databaseElement);
                collection.setName(collectionNameInsideMongodb);
                collection.setAttribute("physicalName", collectionNameInsideMongodb, false);
                databaseElement.getNode().add((Object)collection);
                this.reverseType(collection, (MongoCollection<Document>)mongoDatabase.getCollection(collectionNameInsideMongodb));
            }
        }
        catch (Exception e) {
            MongoClientUtil.manageAuthorizationErrorOnReverse(e);
        }
        return nodes;
    }
}

