/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.externalvalueresolver.azure;

import com.azure.core.credential.TokenCredential;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.indy.engine.core.externalvalueresolver.IExternalValueResolverPlugin;
import com.indy.engine.shared.plugin.IPluginFactory;
import java.text.MessageFormat;

public class AzureSecretManagerExternalValueResolverInternalPlugin
implements IExternalValueResolverPlugin {
    public static final String KEY_VAULT_NAME = "keyVaultName";
    private SecretClient client;

    public void init(IPluginFactory.IPluginConfiguration conf) throws Exception {
        String keyVaultName = conf.getProperty(KEY_VAULT_NAME);
        if (keyVaultName == null) {
            throw new Exception("azure key vault name is null.");
        }
        String vaultUrl = MessageFormat.format(System.getProperty("com.semarchy.xdi.azure.vault.urlpattern", "https://{0}.vault.azure.net"), keyVaultName);
        this.client = new SecretClientBuilder().credential((TokenCredential)new DefaultAzureCredentialBuilder().build()).vaultUrl(vaultUrl).httpLogOptions(new HttpLogOptions().setLogLevel(HttpLogDetailLevel.BODY_AND_HEADERS)).buildClient();
    }

    public IExternalValueResolverPlugin.Value getvalue(String secretName, IExternalValueResolverPlugin.SecurityLevel type) {
        IExternalValueResolverPlugin.Value value = new IExternalValueResolverPlugin.Value();
        if (type == IExternalValueResolverPlugin.SecurityLevel.level1) {
            value.errorMessage = String.format("The key %s is not allowed to be evaluated in \"level1\" security level, which is required in this context.", secretName);
            return value;
        }
        try {
            KeyVaultSecret secret = this.client.getSecret(secretName);
            if (secret == null) {
                value.errorMessage = String.format("secret %s not found", secretName);
            } else {
                value.data = secret.getValue().getBytes();
            }
        }
        catch (ResourceNotFoundException e) {
            value.errorMessage = String.format("secret %s not found", secretName);
        }
        return value;
    }

    protected AzureSecretManagerExternalValueResolverInternalPlugin() {
    }
}

