/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.sapS4hana.runtime;

import com.indy.engine.core.actionCodes.convert.AbstractDataTypeConverter;
import com.indy.engine.core.actionCodes.convert.AbstractParser;
import com.indy.engine.core.actionCodes.convert.JdbcConverter;
import com.indy.engine.core.actionCodes.convert.ParserProvider;
import com.indy.engine.core.actionCodes.convert.Unparser;
import com.indy.engine.core.api.impl.jdbc.JdbcWriterProperties;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class IDOCDataTypeProvider
extends AbstractDataTypeConverter {
    private static final int ACCP_TYPE = 1;
    private static final int CHAR_TYPE = 2;
    private static final int CLNT_TYPE = 3;
    private static final int CUKY_TYPE = 4;
    private static final int CURR_TYPE = 5;
    private static final int DATS_TYPE = 6;
    private static final int DEC_TYPE = 7;
    private static final int FLTP_TYPE = 8;
    private static final int INT1_TYPE = 9;
    private static final int INT2_TYPE = 10;
    private static final int INT4_TYPE = 11;
    private static final int LANG_TYPE = 12;
    private static final int LCHR_TYPE = 13;
    private static final int LRAW_TYPE = 14;
    private static final int NUMC_TYPE = 15;
    private static final int PREC_TYPE = 16;
    private static final int QUAN_TYPE = 17;
    private static final int RAW_TYPE = 18;
    private static final int RAWSTRING_TYPE = 19;
    private static final int SSTRING_TYPE = 20;
    private static final int STRING_TYPE = 21;
    private static final int TIMS_TYPE = 22;
    private static final int VARC_TYPE = 23;
    private static final int UNIT_TYPE = 24;
    static AbstractParser<Short> shortParser = new AbstractParser<Short>(){

        public Short parse(String value) throws EngineExceptionI {
            return Short.parseShort(value);
        }

        public void setJdbcStatement(PreparedStatement ps, int index, Short value, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
            JdbcConverter.convertShort((PreparedStatement)ps, (int)index, (short)(value != null ? value : (short)0), (value == null ? 1 : 0) != 0, (int)targetColType, (JdbcWriterProperties)converter);
        }
    };
    static AbstractParser<Integer> integerParser = new AbstractParser<Integer>(){

        public Integer parse(String value) throws EngineExceptionI {
            return Integer.parseInt(value);
        }

        public void setJdbcStatement(PreparedStatement ps, int index, Integer value, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
            JdbcConverter.convertInteger((PreparedStatement)ps, (int)index, (int)(value != null ? value : 0), (value == null ? 1 : 0) != 0, (int)targetColType, (JdbcWriterProperties)converter);
        }
    };
    static AbstractParser<Double> doubleParser = new AbstractParser<Double>(){

        public Double parse(String value) throws EngineExceptionI {
            return Double.parseDouble(value);
        }

        public void setJdbcStatement(PreparedStatement ps, int index, Double value, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
            JdbcConverter.convertDouble((PreparedStatement)ps, (int)index, (double)(value != null ? value : 0.0), (value == null ? 1 : 0) != 0, (int)targetColType, (JdbcWriterProperties)converter);
        }
    };
    static AbstractParser<BigDecimal> bigDecimalParser = new AbstractParser<BigDecimal>(){

        public BigDecimal parse(String value) throws EngineExceptionI {
            return new BigDecimal(value);
        }

        public void setJdbcStatement(PreparedStatement ps, int index, BigDecimal value, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
            JdbcConverter.convertNumber((PreparedStatement)ps, (int)index, (Number)value, (boolean)wasNull, (int)targetColType, (JdbcWriterProperties)converter);
        }
    };
    DateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    AbstractParser<Date> dateParser = new AbstractParser.DefaultDateParser(this.sdf){

        public String preTransformation(String str) {
            if (str.equals("00000000")) {
                return null;
            }
            return str;
        }
    };
    DateFormat stf = new SimpleDateFormat("HHmmss");
    DateFormat spf = new SimpleDateFormat("yyyyMM");
    DateFormat sdefaultf = SimpleDateFormat.getDateTimeInstance();
    AbstractParser<Time> timeParser = new AbstractParser.DefaultTimeParser(this.stf){

        public String preTransformation(String str) {
            if (str.equals("000000")) {
                return null;
            }
            return str;
        }
    };
    AbstractParser<byte[]> byteParser = new AbstractParser<byte[]>(){

        public byte[] parse(String value) throws EngineExceptionI {
            return value.getBytes();
        }

        public void setJdbcStatement(PreparedStatement ps, int index, byte[] value, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
            JdbcConverter.convertBytes((PreparedStatement)ps, (int)index, (byte[])value, (Integer)targetColType);
        }
    };

    public int getDataType(String dataType) {
        if (dataType != null && !dataType.isEmpty()) {
            if (dataType.equals("ACCP")) {
                return 1;
            }
            if (dataType.equals("CHAR")) {
                return 2;
            }
            if (dataType.equals("CLNT")) {
                return 3;
            }
            if (dataType.equals("CUKY")) {
                return 4;
            }
            if (dataType.equals("CURR")) {
                return 5;
            }
            if (dataType.equals("DATS")) {
                return 6;
            }
            if (dataType.equals("DEC")) {
                return 7;
            }
            if (dataType.equals("FLTP")) {
                return 8;
            }
            if (dataType.equals("INT1")) {
                return 9;
            }
            if (dataType.equals("INT2")) {
                return 10;
            }
            if (dataType.equals("INT4")) {
                return 11;
            }
            if (dataType.equals("LANG")) {
                return 12;
            }
            if (dataType.equals("LCHR")) {
                return 13;
            }
            if (dataType.equals("LRAW")) {
                return 14;
            }
            if (dataType.equals("NUMC")) {
                return 15;
            }
            if (dataType.equals("PREC")) {
                return 16;
            }
            if (dataType.equals("QUAN")) {
                return 17;
            }
            if (dataType.equals("RAW")) {
                return 18;
            }
            if (dataType.equals("RAWSTRING")) {
                return 19;
            }
            if (dataType.equals("SSTRING")) {
                return 20;
            }
            if (dataType.equals("STRING")) {
                return 21;
            }
            if (dataType.equals("TIMS")) {
                return 22;
            }
            if (dataType.equals("VARC")) {
                return 23;
            }
            if (dataType.equals("UNIT")) {
                return 24;
            }
        }
        return -1;
    }

    public static void main(String[] argv) {
        new BigDecimal("1000");
    }

    private boolean isString(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    public ParserProvider getParserProvider() {
        return new ParserProvider(this){

            public AbstractParser getParser(int dataType) {
                switch (dataType) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 12: 
                    case 13: 
                    case 15: 
                    case 16: 
                    case 20: 
                    case 21: 
                    case 23: 
                    case 24: {
                        return AbstractParser.defaultStringParser;
                    }
                    case 9: 
                    case 10: {
                        return new AbstractParser.AbstractShortParser(){

                            public Short parse(String value) throws EngineExceptionI {
                                return Short.parseShort(value.trim());
                            }
                        };
                    }
                    case 11: {
                        return new AbstractParser.AbstractIntegerParser(){

                            public Integer parse(String value) throws EngineExceptionI {
                                return Integer.parseInt(value.trim());
                            }
                        };
                    }
                    case 8: {
                        return AbstractParser.defaultDoubleParser;
                    }
                    case 5: 
                    case 7: 
                    case 17: {
                        return AbstractParser.defaultBigDecimalParser;
                    }
                    case 6: {
                        return IDOCDataTypeProvider.this.dateParser;
                    }
                    case 22: {
                        return IDOCDataTypeProvider.this.timeParser;
                    }
                }
                return null;
            }
        };
    }

    public Unparser getUnparser() throws EngineExceptionI {
        return new Unparser(this){

            public String printString(String str, int targetType) {
                return str;
            }

            public String printFloat(Float d, int targetType) {
                return d.toString();
            }

            public String printDouble(Double d, int targetType) {
                return d.toString();
            }

            public String printDecimal(BigDecimal dec, int targetType) {
                return dec.toPlainString();
            }

            public String printDateTime(Calendar cal, int targetType) {
                switch (targetType) {
                    case 22: {
                        return IDOCDataTypeProvider.this.stf.format(cal.getTime());
                    }
                    case 6: {
                        return IDOCDataTypeProvider.this.sdf.format(cal.getTime());
                    }
                    case 1: {
                        return IDOCDataTypeProvider.this.spf.format(cal.getTime());
                    }
                }
                return IDOCDataTypeProvider.this.sdefaultf.format(cal.getTime());
            }

            public String printBoolean(boolean b, int targetType) {
                if (IDOCDataTypeProvider.this.isString(targetType)) {
                    return b ? "true" : "false";
                }
                return b ? "1" : "0";
            }

            public String print(Object val, int valueType) {
                return null;
            }

            public String printBytes(byte[] bytes, int targetType) {
                return new String(bytes);
            }
        };
    }
}

