/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.license.server;

import com.semarchy.xdi.license.server.Log;
import com.semarchy.xdi.license.server.Messages;
import com.semarchy.xdi.license.server.VirtualServer;
import com.semarchy.xdi.license.server.model.Group;
import com.semarchy.xdi.license.server.model.Server;
import com.semarchy.xdi.license.server.plugin.IDesignerFilterManager;
import com.semarchy.xdi.license.server.plugin.IDesignerFilterPlugin;
import com.semarchy.xdi.license.server.plugin.ssl.IDesignerSslPlugin;
import com.semarchy.xdi.license.server.plugin.tls.IDesignerTlsPlugin;
import com.semarchy.xdi.license.server.validation.SignatureUtil;
import com.semarchy.xdi.license.server.validation.VerificationUtil;
import jakarta.servlet.Servlet;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.BindException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.security.ConstraintMapping;
import org.eclipse.jetty.ee10.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.Constraint;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.resource.PathResourceFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.FileSystemXmlApplicationContext;

@SpringBootApplication
public class LicenceServer {
    private Marshaller marshaller;
    private Marshaller stambiaMarshaller;
    private Unmarshaller unmarshaller;
    Map<String, VirtualServer> groups = Collections.synchronizedMap(new HashMap());
    public static LicenceServer INSTANCE = new LicenceServer();
    private Server server;
    private org.eclipse.jetty.server.Server jettyServer;
    long preDate = 0L;
    String lock = new String("");
    private Thread thread;
    public static BeanFactory beanFactory = null;
    CmdLineOption cmd = new CmdLineOption();

    public static void restart() {
        System.exit(-1111);
    }

    public LicenceServer() {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"com.semarchy.xdi.license.server.model");
            this.marshaller = jc.createMarshaller();
            this.unmarshaller = jc.createUnmarshaller();
            jc = JAXBContext.newInstance((String)"com.stambia.licence.model");
            this.stambiaMarshaller = jc.createMarshaller();
        }
        catch (JAXBException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public VirtualServer getVirtualServer(String groupCode) {
        return this.groups.get(groupCode);
    }

    public Set<String> groupList() {
        return this.groups.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Server server) throws Exception {
        boolean needToRestart = false;
        if (server != null) {
            String string = this.lock;
            synchronized (string) {
                Log.getServerLogger().info(Messages.getString("LicenceServer.6"));
                String stringServer = VerificationUtil.getServerToString(server, Log.getServerLogger());
                if (null == server.getSignature() || !SignatureUtil.verifySignature(server.getSignature(), stringServer, Log.getServerLogger())) {
                    Log.getServerLogger().error(Messages.getString("LicenceServer.7"));
                    throw new Exception(Messages.getString("LicenceServer.0"));
                }
                if (this.server != null && server.getPort() != this.server.getPort()) {
                    needToRestart = true;
                }
                this.server = server;
                HashSet<String> old = new HashSet<String>();
                old.addAll(this.groups.keySet());
                IDesignerFilterManager filterManager = null;
                if (beanFactory != null) {
                    try {
                        filterManager = (IDesignerFilterManager)beanFactory.getBean(IDesignerFilterManager.class);
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        Log.getServerLogger().info(Messages.getString("LicenceServer.9"));
                    }
                }
                for (Group group : this.server.getGroup()) {
                    if (null == group.getPermission() || group.getPermission().isEmpty()) {
                        Log.getServerLogger().warn(Messages.getString("LicenceServer.10") + group.getCode() + Messages.getString("LicenceServer.11"));
                    }
                    old.remove(group.getCode());
                    VirtualServer vs = this.groups.get(group.getCode());
                    if (vs == null) {
                        vs = new VirtualServer();
                    }
                    this.groups.put(group.getCode(), vs);
                    vs.setGroup(group);
                    if (filterManager == null) continue;
                    IDesignerFilterPlugin filter = filterManager.getFilterPlugin(group.getCode());
                    if (filter != null) {
                        Log.getServerLogger().info(Messages.getString("LicenceServer.12") + group.getCode());
                        List<String> list = filter.getUserNames();
                        if (null != list) {
                            list.removeAll(Collections.singleton(null));
                        }
                        if (filter.logUserListAtStartup()) {
                            int i = 1;
                            for (String user : list) {
                                Log.getServerLogger().info(Messages.getString("LicenceServer.13") + i++ + Messages.getString("LicenceServer.14") + user);
                            }
                        }
                        Log.getServerLogger().info(Messages.getString("LicenceServer.15") + list.size() + Messages.getString("LicenceServer.16") + group.getCode());
                        vs.setFilter(filter);
                        continue;
                    }
                    Log.getServerLogger().info(Messages.getString("LicenceServer.17") + group.getCode());
                }
                for (String key : old) {
                    this.groups.remove(key);
                }
                if (needToRestart) {
                    try {
                        this.stopHTTPServer();
                    }
                    catch (Exception e) {
                        Log.getServerLogger().error(Messages.getString("LicenceServer.18"), (Throwable)e);
                        needToRestart = false;
                    }
                }
                Log.getServerLogger().info(Messages.getString("LicenceServer.19"));
            }
        }
        if (needToRestart) {
            try {
                this.startHTTPServer();
            }
            catch (Exception e) {
                Log.getServerLogger().error(Messages.getString("LicenceServer.20"), (Throwable)e);
            }
        }
    }

    public void stopHTTPServer() throws Exception {
        this.jettyServer.stop();
        this.jettyServer.join();
    }

    public Server loadServerWithFile() throws Exception {
        if (this.cmd.getFile().exists()) {
            if (this.cmd.getFile().lastModified() > this.preDate) {
                JAXBElement o = (JAXBElement)this.unmarshaller.unmarshal(this.cmd.getFile());
                this.preDate = this.cmd.getFile().lastModified();
                return (Server)o.getValue();
            }
        } else {
            throw new Exception(Messages.getString("LicenceServer.21") + this.cmd.getFileName() + Messages.getString("LicenceServer.22"));
        }
        return null;
    }

    public synchronized String marshallToString(JAXBElement element) throws JAXBException {
        StringWriter sw = new StringWriter();
        if ("com.stambia.licence.model".equals(element.getDeclaredType().getPackage().getName())) {
            this.stambiaMarshaller.marshal((Object)element, (Writer)sw);
        } else {
            this.marshaller.marshal((Object)element, (Writer)sw);
        }
        return sw.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readArgs(String[] args) throws Exception {
        Server serverTemp;
        this.preDate = 0L;
        CmdLineParser parser = new CmdLineParser((Object)this.cmd);
        parser.parseArgument(args);
        if (this.cmd.isUsage()) {
            parser.printUsage((OutputStream)System.out);
            System.exit(-1);
        }
        Log.setLogLevel(this.cmd.getLogLevel());
        Log.setEnableConsole(this.cmd.isConsoleEnable());
        Log.setBaseDir(this.cmd.getBasedir());
        Log.setLogDir(this.cmd.getLogdir());
        if (!this.cmd.getMode().equals("file")) throw new Exception(Messages.getString("LicenceServer.28"));
        if (this.cmd.getFileName() == null) throw new Exception(Messages.getString("LicenceServer.26"));
        if (this.cmd.springConfXmlFile() != null) {
            try {
                beanFactory = new FileSystemXmlApplicationContext(this.cmd.springConfXmlFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null == (serverTemp = this.loadServerWithFile())) return;
        this.server = serverTemp;
    }

    public void startServer() throws Exception {
        this.load(this.server);
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    try {
                        LicenceServer.this.load(LicenceServer.this.loadServerWithFile());
                    }
                    catch (Exception e) {
                        Log.getServerLogger().error(Messages.getString("LicenceServer.31"), (Throwable)e);
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
        this.thread.setName("Refresh thread");
        this.thread.setDaemon(true);
        this.thread.start();
        this.startHTTPServer();
    }

    public Thread getThread() {
        return this.thread;
    }

    public void startHTTPServer() throws Exception {
        ResourceConfig rc = new ResourceConfig().packages(new String[]{"com.semarchy.xdi.license.server.resource"});
        ServletHolder sh = new ServletHolder((Servlet)new ServletContainer(rc));
        this.jettyServer = new org.eclipse.jetty.server.Server();
        ConstraintSecurityHandler security = this.createConstraintSecurityHandler();
        IDesignerSslPlugin designerSslPlugin = null;
        IDesignerTlsPlugin designerTlsPlugin = null;
        if (beanFactory != null) {
            try {
                designerSslPlugin = (IDesignerSslPlugin)beanFactory.getBean(IDesignerSslPlugin.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                Log.getServerLogger().info(Messages.getString("LicenceServer.45"));
            }
            try {
                designerTlsPlugin = (IDesignerTlsPlugin)beanFactory.getBean(IDesignerTlsPlugin.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                Log.getServerLogger().info(Messages.getString("LicenceServer.46"));
            }
        }
        Boolean isHttpsNeedToBeDisabled = false;
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        if (designerSslPlugin != null) {
            if (null == designerSslPlugin.getEnableSsl()) {
                throw new Exception(Messages.getString("LicenceServer.47"));
            }
            if (designerSslPlugin.getEnableSsl().booleanValue()) {
                sslContextFactory.setKeyStoreType(designerSslPlugin.getKeyStoreType());
                sslContextFactory.setKeyStorePath(designerSslPlugin.getKeyStore());
                sslContextFactory.setKeyStorePassword(designerSslPlugin.getKeyStorePassword());
                sslContextFactory.setCertAlias(designerSslPlugin.getKeyAlias());
                sslContextFactory.setKeyManagerPassword(designerSslPlugin.getKeyPassword());
                sslContextFactory.setTrustStorePath(designerSslPlugin.getKeyStore());
                sslContextFactory.setTrustStorePassword(designerSslPlugin.getKeyStorePassword());
            } else {
                isHttpsNeedToBeDisabled = true;
            }
        }
        if (null != designerTlsPlugin) {
            if (null != designerTlsPlugin.getIncludeProtocols()) {
                sslContextFactory.setIncludeProtocols(designerTlsPlugin.getIncludeProtocols());
            }
            if (null != designerTlsPlugin.getExcludeProtocols()) {
                sslContextFactory.setExcludeProtocols(designerTlsPlugin.getExcludeProtocols());
            }
        }
        HttpConfiguration http_config = new HttpConfiguration();
        HttpConfiguration https_config = new HttpConfiguration(http_config);
        https_config.setSendServerVersion(Boolean.FALSE.booleanValue());
        boolean disableSNIHostCheck = Boolean.TRUE.equals(designerSslPlugin.getDisableSNIHostCheck());
        https_config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer(!disableSNIHostCheck));
        ServerConnector serverConnector = isHttpsNeedToBeDisabled != false ? new ServerConnector(this.jettyServer, new ConnectionFactory[]{new HttpConnectionFactory(https_config)}) : new ServerConnector(this.jettyServer, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config)});
        serverConnector.setPort(this.server.getPort());
        this.jettyServer.setConnectors(new Connector[]{serverConnector});
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        context.addServlet(sh, "/*");
        security.setHandler((Handler)context);
        ErrorHandler errorHandler = new ErrorHandler(){

            protected void writeErrorHtml(Request request, Writer writer, Charset charset, int code, String message, Throwable cause, boolean showStacks) throws IOException {
                try (InputStream htmlInput = LicenceServer.class.getResourceAsStream("/templates/error.html");
                     InputStreamReader htmlReader = new InputStreamReader(htmlInput, StandardCharsets.UTF_8);){
                    IO.copy((Reader)htmlReader, (Writer)writer);
                }
                catch (Exception e) {
                    Log.getServerLogger().warn("unexpected", (Throwable)e);
                    writer.append(" <h1>You're close!</h1><p>This URL is the Semarchy xDI License Server");
                }
            }

            protected boolean generateAcceptableResponse(Request request, Response response, Callback callback, String contentType, List<Charset> charsets, int code, String message, Throwable cause) throws IOException {
                Charset charset;
                MimeTypes.Type type;
                switch (contentType) {
                    case "text/html": 
                    case "text/*": 
                    case "*/*": {
                        type = MimeTypes.Type.TEXT_HTML;
                        charset = charsets.stream().findFirst().orElse(StandardCharsets.ISO_8859_1);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                boolean showStacks = this.isShowStacks();
                StringWriter writer = new StringWriter();
                this.writeErrorHtml(request, writer, charset, code, message, cause, showStacks);
                writer.flush();
                response.getHeaders().put(type.getContentTypeField(charset));
                response.write(true, ByteBuffer.wrap(writer.toString().getBytes()), callback);
                return true;
            }
        };
        context.setErrorHandler((Request.Handler)errorHandler);
        this.jettyServer.start();
    }

    private ConstraintSecurityHandler createConstraintSecurityHandler() {
        String realmFile = this.cmd.getJettySecurityRealm();
        HashLoginService loginService = new HashLoginService("MyRealm", new PathResourceFactory().newResource(realmFile));
        this.jettyServer.addBean((Object)loginService);
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        this.jettyServer.setHandler((Handler)security);
        ArrayList<ConstraintMapping> constraintMappingList = new ArrayList<ConstraintMapping>();
        for (String groupCode : this.groups.keySet()) {
            constraintMappingList.add(this.createConstraint("hostList_auth", "viewer", "/" + groupCode + "/hostList/*"));
            constraintMappingList.add(this.createConstraint("hostList_auth", "viewer", "/api/2/" + groupCode + "/hostList/*"));
            constraintMappingList.add(this.createConstraint("sessionList_auth", "admin", "/" + groupCode + "/sessionList/*"));
            constraintMappingList.add(this.createConstraint("sessionList_auth", "admin", "/api/2/" + groupCode + "/sessionList/*"));
        }
        constraintMappingList.add(this.createConstraint("groupList_auth", "admin", "/groupList/*"));
        constraintMappingList.add(this.createConstraint("groupList_auth", "admin", "/api/2/groupList/*"));
        constraintMappingList.add(this.createConstraint("sessionList_auth", "admin", "/sessionList/*"));
        constraintMappingList.add(this.createConstraint("sessionList_auth", "admin", "/api/2/sessionList/*"));
        constraintMappingList.add(this.createConstraint("hostList_auth", "admin", "/hostList/*"));
        constraintMappingList.add(this.createConstraint("hostList_auth", "admin", "/api/2/hostList/*"));
        constraintMappingList.add(this.createConstraint("update_auth", "lbo", "/update/*"));
        constraintMappingList.add(this.createConstraint("update_auth", "lbo", "/api/2/update/*"));
        HashSet<String> knownRoles = new HashSet<String>();
        knownRoles.add("admin");
        knownRoles.add("lbo");
        knownRoles.add("viewer");
        security.setConstraintMappings(constraintMappingList, knownRoles);
        security.setAuthenticator((Authenticator)new BasicAuthenticator());
        security.setLoginService((LoginService)loginService);
        return security;
    }

    private ConstraintMapping createConstraint(String constraintName, String role, String pathSpec) {
        Constraint constraint = Constraint.from((String)constraintName, (Constraint.Authorization)Constraint.Authorization.SPECIFIC_ROLE, (String[])new String[]{role});
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setPathSpec(pathSpec);
        mapping.setConstraint(constraint);
        return mapping;
    }

    public static void main(String[] args) throws Exception {
        try {
            INSTANCE.readArgs(args);
            SpringApplication application = new SpringApplication(new Class[]{LicenceServer.class});
            application.setWebApplicationType(WebApplicationType.NONE);
            if (!LicenceServer.INSTANCE.cmd.isStop()) {
                application.addListeners(new ApplicationListener[]{new ApplicationPidFileWriter()});
            }
            application.run(args);
            String version = LicenceServer.class.getPackage().getImplementationVersion();
            if (null == version) {
                version = "latest";
            }
            Log.getServerLogger().info(Messages.getString("LicenceServer.66") + version);
            if (LicenceServer.INSTANCE.cmd.isStop()) {
                INSTANCE.askToStop();
            } else {
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Log.getServerLogger().info(Messages.getString("LicenceServer.67"));
                    }
                }));
                if (LicenceServer.INSTANCE.cmd.getRestartDelay() > -1) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(LicenceServer.INSTANCE.cmd.getRestartDelay());
                                LicenceServer.restart();
                            }
                            catch (InterruptedException e) {
                                Log.getServerLogger().error(Messages.getString("LicenceServer.68"));
                            }
                        }
                    });
                    thread.start();
                }
                INSTANCE.startServer();
            }
        }
        catch (BindException e) {
            e.printStackTrace();
            System.exit(-2);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void askToStop() {
        try {
            String file = "application.pid";
            Path path = Paths.get(file, new String[0]);
            String pid = Files.readAllLines(path).get(0);
            String cmd = System.getProperty("os.name").toLowerCase().indexOf("windows") > -1 ? "taskkill /F /T /PID " + pid : "kill -15 " + pid;
            Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            Log.getServerLogger().error(Messages.getString("LicenceServer.69") + e.getMessage());
        }
    }

    public CmdLineOption getCmd() {
        return this.cmd;
    }

    public class CmdLineOption {
        @Option(name="-stop", usage="mode <server|file>", required=false)
        private boolean stop = false;
        @Option(name="-mode", usage="mode <server|file>", aliases={"-m"}, required=false)
        private String mode = "file";
        @Option(name="-file", usage="file parameters name", aliases={"-f"}, required=false)
        private String fileName = "license.xml";
        @Option(name="-console", usage="console", aliases={"-c"}, required=false)
        private boolean console = false;
        @Option(name="-basedir", usage="basedir", aliases={"-bd"}, required=false)
        private String basedir = ".";
        @Option(name="-restartdelay", usage="delay<m|h|d>", aliases={"-rd"}, required=false)
        private String restartDelay = null;
        @Option(name="-logdir", usage="logdir", aliases={"-ld"}, required=false)
        private String logdir = "log";
        @Option(name="-usage", usage="usage", required=false)
        private boolean usage = false;
        @Option(name="-loglevel", usage="loglevel <all|info|debug|error|warn|fatal|trace|off>", aliases={"-ll"}, required=false)
        private String logLevel = null;
        @Option(name="-conf", usage="Xml Spring Context", aliases={"-cf"}, required=false)
        private String springContext = null;
        @Option(name="-securityrealm", usage="Jetty Security Realm", aliases={"-sr"}, required=false)
        private String jettySecurityRealm = null;

        public Level getLogLevel() {
            Level level;
            if (this.logLevel != null && (level = Level.toLevel((String)this.logLevel.toUpperCase())) != null) {
                return level;
            }
            return Level.INFO;
        }

        public String springConfXmlFile() {
            return this.springContext;
        }

        public String getJettySecurityRealm() {
            return this.jettySecurityRealm;
        }

        public boolean isUsage() {
            return this.usage;
        }

        public String getLogdir() {
            return this.logdir;
        }

        public String getBasedir() {
            return this.basedir;
        }

        public boolean isStop() {
            return this.stop;
        }

        public String getFileName() {
            if (new File(this.fileName).isAbsolute()) {
                return this.fileName;
            }
            return this.basedir + File.separator + this.fileName;
        }

        public boolean isConsoleEnable() {
            return this.console;
        }

        public Object getMode() {
            return this.mode;
        }

        public File getFile() {
            return this.getFileName() != null ? new File(this.getFileName()) : null;
        }

        public int getRestartDelay() {
            if (this.restartDelay != null && this.restartDelay.length() > 1) {
                int i = Integer.valueOf(this.restartDelay.substring(0, this.restartDelay.length() - 1));
                if (this.restartDelay.endsWith("m")) {
                    return i * 60 * 1000;
                }
                if (this.restartDelay.endsWith("h")) {
                    return i * 60 * 60 * 10000;
                }
                if (this.restartDelay.endsWith("d")) {
                    return i * 24 * 60 * 60 * 10000;
                }
            }
            return -1;
        }
    }
}

