/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.license.server;

import java.io.File;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class Log {
    private static Logger logger = null;
    private static boolean consoleEnable;
    public static Level logLevel;
    static String baseDir;
    static String logDir;

    public static Logger getServerLogger() {
        if (logger == null) {
            Object path = ".";
            File file = new File(logDir);
            path = file.isAbsolute() ? file.getAbsolutePath() : baseDir + File.separator + logDir;
            String filename = (String)path + File.separator + "xdi-license-server.log";
            String consolePattern = "%d  %-5p %r --- [%t] %c %m%n";
            String filePattern = "%d [%-5p] %m%n";
            ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
            LoggerComponentBuilder loggerComponentBuilder = (LoggerComponentBuilder)builder.newLogger("com.semarchy", logLevel).addAttribute("additivity", false);
            LayoutComponentBuilder layoutBuilder = (LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", filePattern);
            ComponentBuilder triggeringPolicy = builder.newComponent("Policies").addComponent(builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", "1M"));
            ComponentBuilder maxFileStrategy = builder.newComponent("DefaultRolloverStrategy").addAttribute("max", 10);
            AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("rolling", "RollingFile").addAttribute("fileName", filename)).addAttribute("filePattern", filename + ".%i")).add(layoutBuilder).addComponent(triggeringPolicy)).addComponent(maxFileStrategy);
            builder.add(appenderBuilder);
            if (!consoleEnable) {
                loggerComponentBuilder.add(builder.newAppenderRef("rolling"));
                builder.add(loggerComponentBuilder);
            }
            builder.add(builder.newAppender("console", "Console").add((LayoutComponentBuilder)builder.newLayout(PatternLayout.class.getSimpleName()).addAttribute("pattern", consolePattern)));
            builder.add((RootLoggerComponentBuilder)builder.newRootLogger(logLevel).add(builder.newAppenderRef("console")));
            Configurator.reconfigure((Configuration)((Configuration)builder.build()));
            logger = LogManager.getLogger(Log.class);
        }
        return logger;
    }

    public static void setEnableConsole(boolean _consoleEnable) {
        consoleEnable = _consoleEnable;
    }

    public static void setBaseDir(String _baseDir) {
        baseDir = _baseDir;
    }

    public static void setLogDir(String logdir) {
        logDir = logdir;
    }

    public static void setLogLevel(Level loglevel) {
        logLevel = loglevel;
    }

    static {
        logLevel = Level.INFO;
    }
}

