/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.FieldSetter;
import org.kohsuke.args4j.IllegalAnnotationError;
import org.kohsuke.args4j.Messages;
import org.kohsuke.args4j.MethodSetter;
import org.kohsuke.args4j.MultiValueFieldSetter;
import org.kohsuke.args4j.NamedOptionDef;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.BooleanOptionHandler;
import org.kohsuke.args4j.spi.DoubleOptionHandler;
import org.kohsuke.args4j.spi.EnumOptionHandler;
import org.kohsuke.args4j.spi.FileOptionHandler;
import org.kohsuke.args4j.spi.IntOptionHandler;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;
import org.kohsuke.args4j.spi.StringOptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdLineParser {
    private final Object bean;
    private final List<OptionHandler> options = new ArrayList<OptionHandler>();
    private final List<OptionHandler> arguments = new ArrayList<OptionHandler>();
    private boolean parsingOptions = true;
    private OptionHandler currentOptionHandler = null;
    private int usageWidth = 80;
    private static final Map<Class, Constructor<? extends OptionHandler>> handlerClasses = Collections.synchronizedMap(new HashMap());

    public CmdLineParser(Object bean) {
        this.bean = bean;
        for (Class<?> c = bean.getClass(); c != null; c = c.getSuperclass()) {
            Argument a;
            Option o;
            for (Method method : c.getDeclaredMethods()) {
                o = method.getAnnotation(Option.class);
                if (o != null) {
                    this.addOption(new MethodSetter(bean, method), o);
                }
                if ((a = method.getAnnotation(Argument.class)) == null) continue;
                this.addArgument(new MethodSetter(bean, method), a);
            }
            for (AccessibleObject accessibleObject : c.getDeclaredFields()) {
                o = ((Field)accessibleObject).getAnnotation(Option.class);
                if (o != null) {
                    this.addOption(this.createFieldSetter((Field)accessibleObject), o);
                }
                if ((a = ((Field)accessibleObject).getAnnotation(Argument.class)) == null) continue;
                this.addArgument(this.createFieldSetter((Field)accessibleObject), a);
            }
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (this.arguments.get(i) != null) continue;
            throw new IllegalAnnotationError("No argument annotation for index " + i);
        }
        Collections.sort(this.options, new Comparator<OptionHandler>(){

            @Override
            public int compare(OptionHandler o1, OptionHandler o2) {
                return o1.option.toString().compareTo(o2.option.toString());
            }
        });
    }

    private Setter createFieldSetter(Field f) {
        if (List.class.isAssignableFrom(f.getType())) {
            return new MultiValueFieldSetter(this.bean, f);
        }
        return new FieldSetter(this.bean, f);
    }

    private void addArgument(Setter setter, Argument a) {
        OptionHandler h = this.createOptionHandler(new OptionDef(a, setter.isMultiValued()), setter);
        int index = a.index();
        while (index >= this.arguments.size()) {
            this.arguments.add(null);
        }
        if (this.arguments.get(index) != null) {
            throw new IllegalAnnotationError("Argument with index " + index + " is used more than once");
        }
        this.arguments.set(index, h);
    }

    private void addOption(Setter setter, Option o) {
        OptionHandler h = this.createOptionHandler(new NamedOptionDef(o, setter.isMultiValued()), setter);
        this.checkOptionNotInMap(o.name());
        for (String alias : o.aliases()) {
            this.checkOptionNotInMap(alias);
        }
        this.options.add(h);
    }

    private void checkOptionNotInMap(String name) throws IllegalAnnotationError {
        if (this.findOptionByName(name) != null) {
            throw new IllegalAnnotationError("Option name " + name + " is used more than once");
        }
    }

    protected OptionHandler createOptionHandler(OptionDef o, Setter setter) {
        Constructor<? extends OptionHandler> handlerType;
        Class<? extends OptionHandler> h = o.handler();
        if (h == OptionHandler.class) {
            Class t = setter.getType();
            if (Enum.class.isAssignableFrom(t)) {
                return new EnumOptionHandler(this, o, setter, t);
            }
            handlerType = handlerClasses.get(t);
            if (handlerType == null) {
                throw new IllegalAnnotationError("No OptionHandler is registered to handle " + t);
            }
        } else {
            handlerType = CmdLineParser.getConstructor(h);
        }
        try {
            return handlerType.newInstance(this, o, setter);
        }
        catch (InstantiationException e) {
            throw new IllegalAnnotationError(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAnnotationError(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalAnnotationError(e);
        }
    }

    public String printExample(ExampleMode mode) {
        return this.printExample(mode, null);
    }

    public String printExample(ExampleMode mode, ResourceBundle rb) {
        StringBuilder buf = new StringBuilder();
        for (OptionHandler h : this.options) {
            OptionDef option = h.option;
            if (option.usage().length() == 0 || !mode.print(option)) continue;
            buf.append(' ');
            buf.append(h.getNameAndMeta(rb));
        }
        return buf.toString();
    }

    public void printUsage(OutputStream out) {
        this.printUsage(new OutputStreamWriter(out), null);
    }

    public void printUsage(Writer out, ResourceBundle rb) {
        int curLen;
        PrintWriter w = new PrintWriter(out);
        int len = 0;
        for (OptionHandler h : this.arguments) {
            curLen = this.getPrefixLen(h, rb);
            len = Math.max(len, curLen);
        }
        for (OptionHandler h : this.options) {
            curLen = this.getPrefixLen(h, rb);
            len = Math.max(len, curLen);
        }
        for (OptionHandler h : this.arguments) {
            this.printOption(w, h, len, rb);
        }
        for (OptionHandler h : this.options) {
            this.printOption(w, h, len, rb);
        }
        w.flush();
    }

    private void printOption(PrintWriter w, OptionHandler h, int len, ResourceBundle rb) {
        int descriptionWidth = this.usageWidth - len - 4;
        String usage = h.option.usage();
        if (usage.length() == 0) {
            return;
        }
        String nameAndMeta = h.getNameAndMeta(rb);
        w.print(' ');
        w.print(nameAndMeta);
        for (int i = nameAndMeta.length(); i < len; ++i) {
            w.print(' ');
        }
        w.print(" : ");
        if (rb != null) {
            usage = rb.getString(usage);
        }
        while (usage != null && usage.length() > 0) {
            int idx = usage.indexOf(10);
            if (idx >= 0 && idx <= descriptionWidth) {
                w.println(usage.substring(0, idx));
                if ((usage = usage.substring(idx + 1)).length() <= 0) continue;
                this.indent(w, len + 4);
                continue;
            }
            if (usage.length() <= descriptionWidth) {
                w.println(usage);
                break;
            }
            w.println(usage.substring(0, descriptionWidth));
            usage = usage.substring(descriptionWidth);
            this.indent(w, len + 4);
        }
    }

    private int getPrefixLen(OptionHandler h, ResourceBundle rb) {
        if (h.option.usage().length() == 0) {
            return 0;
        }
        return h.getNameAndMeta(rb).length();
    }

    private void indent(PrintWriter w, int i) {
        while (i > 0) {
            w.print(' ');
            --i;
        }
    }

    private String getOptionName() {
        return this.currentOptionHandler.option.toString();
    }

    public void parseArgument(String ... args) throws CmdLineException {
        CmdLineImpl cmdLine = new CmdLineImpl(args);
        HashSet<OptionHandler> present = new HashSet<OptionHandler>();
        int argIndex = 0;
        while (cmdLine.hasMore()) {
            String arg = cmdLine.getCurrentToken();
            if (this.isOption(arg)) {
                boolean isKeyValuePair = arg.indexOf(61) != -1;
                OptionHandler optionHandler = this.currentOptionHandler = isKeyValuePair ? this.findOptionHandler(arg) : this.findOptionByName(arg);
                if (this.currentOptionHandler == null) {
                    throw new CmdLineException(Messages.UNDEFINED_OPTION.format(arg));
                }
                cmdLine.proceed(1);
            } else {
                if (argIndex >= this.arguments.size()) {
                    Messages msg = this.arguments.size() == 0 ? Messages.NO_ARGUMENT_ALLOWED : Messages.TOO_MANY_ARGUMENTS;
                    throw new CmdLineException(msg.format(arg));
                }
                this.currentOptionHandler = this.arguments.get(argIndex);
                if (!this.currentOptionHandler.option.isMultiValued()) {
                    ++argIndex;
                }
            }
            int diff = this.currentOptionHandler.parseArguments(cmdLine);
            cmdLine.proceed(diff);
            present.add(this.currentOptionHandler);
        }
        for (OptionHandler handler : this.options) {
            if (!handler.option.required() || present.contains(handler)) continue;
            throw new CmdLineException(Messages.REQUIRED_OPTION_MISSING.format(handler.option.toString()));
        }
        for (OptionHandler handler : this.arguments) {
            if (!handler.option.required() || present.contains(handler)) continue;
            throw new CmdLineException(Messages.REQUIRED_ARGUMENT_MISSING.format(handler.option.toString()));
        }
    }

    private OptionHandler findOptionHandler(String name) {
        OptionHandler handler = this.findOptionByName(name);
        if (handler == null) {
            for (int i = name.length(); i > 1; --i) {
                String prefix = name.substring(0, i);
                Map<String, OptionHandler> possibleHandlers = this.filter(this.options, prefix);
                handler = possibleHandlers.get(prefix);
                if (handler == null) continue;
                return handler;
            }
        }
        return handler;
    }

    private OptionHandler findOptionByName(String name) {
        for (OptionHandler h : this.options) {
            NamedOptionDef option = (NamedOptionDef)h.option;
            if (name.equals(option.name())) {
                return h;
            }
            for (String alias : option.aliases()) {
                if (!name.equals(alias)) continue;
                return h;
            }
        }
        return null;
    }

    private Map<String, OptionHandler> filter(List<OptionHandler> opt, String keyFilter) {
        TreeMap<String, OptionHandler> rv = new TreeMap<String, OptionHandler>();
        for (OptionHandler h : opt) {
            if (!opt.toString().startsWith(keyFilter)) continue;
            rv.put(opt.toString(), h);
        }
        return rv;
    }

    protected boolean isOption(String arg) {
        return this.parsingOptions && arg.startsWith("-");
    }

    public static void registerHandler(Class valueType, Class<? extends OptionHandler> handlerClass) {
        if (valueType == null || handlerClass == null) {
            throw new IllegalArgumentException();
        }
        if (!OptionHandler.class.isAssignableFrom(handlerClass)) {
            throw new IllegalArgumentException("Not an OptionHandler class");
        }
        Constructor<? extends OptionHandler> c = CmdLineParser.getConstructor(handlerClass);
        handlerClasses.put(valueType, c);
    }

    private static Constructor<? extends OptionHandler> getConstructor(Class<? extends OptionHandler> handlerClass) {
        try {
            return handlerClass.getConstructor(CmdLineParser.class, OptionDef.class, Setter.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(handlerClass + " does not have the proper constructor");
        }
    }

    public void setUsageWidth(int usageWidth) {
        this.usageWidth = usageWidth;
    }

    public void stopOptionParsing() {
        this.parsingOptions = false;
    }

    public void printSingleLineUsage(OutputStream out) {
        this.printSingleLineUsage(new OutputStreamWriter(out), null);
    }

    public void printSingleLineUsage(Writer w, ResourceBundle rb) {
        PrintWriter pw = new PrintWriter(w);
        for (OptionHandler h : this.arguments) {
            this.printSingleLineOption(pw, h, rb);
        }
        for (OptionHandler h : this.options) {
            this.printSingleLineOption(pw, h, rb);
        }
        pw.flush();
    }

    private void printSingleLineOption(PrintWriter pw, OptionHandler h, ResourceBundle rb) {
        pw.print(' ');
        if (!h.option.required()) {
            pw.print('[');
        }
        pw.print(h.getNameAndMeta(rb));
        if (h.option.isMultiValued()) {
            pw.print(" ...");
        }
        if (!h.option.required()) {
            pw.print(']');
        }
    }

    static {
        CmdLineParser.registerHandler(Boolean.class, BooleanOptionHandler.class);
        CmdLineParser.registerHandler(Boolean.TYPE, BooleanOptionHandler.class);
        CmdLineParser.registerHandler(File.class, FileOptionHandler.class);
        CmdLineParser.registerHandler(Integer.class, IntOptionHandler.class);
        CmdLineParser.registerHandler(Integer.TYPE, IntOptionHandler.class);
        CmdLineParser.registerHandler(Double.class, DoubleOptionHandler.class);
        CmdLineParser.registerHandler(Double.TYPE, DoubleOptionHandler.class);
        CmdLineParser.registerHandler(String.class, StringOptionHandler.class);
    }

    private class CmdLineImpl
    implements Parameters {
        private final String[] args;
        private int pos;

        CmdLineImpl(String[] args) {
            this.args = args;
            this.pos = 0;
        }

        protected boolean hasMore() {
            return this.pos < this.args.length;
        }

        protected String getCurrentToken() {
            return this.args[this.pos];
        }

        private void proceed(int n) {
            this.pos += n;
        }

        public String getParameter(int idx) throws CmdLineException {
            if (this.pos + idx >= this.args.length) {
                throw new CmdLineException(Messages.MISSING_OPERAND.format(CmdLineParser.this.getOptionName()));
            }
            return this.args[this.pos + idx];
        }
    }
}

