/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ftp;

import com.stambia.ftp.FtpSession;
import com.stambia.ftp.Messages;
import com.stambia.ftp.exceptions.FtpCommandException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;

public class FtpCommandLine {
    public static void main(String[] args) throws FileNotFoundException, NoSuchAlgorithmException {
        boolean raiseException = false;
        boolean verbose = true;
        String protocol = "NONE";
        boolean isImplicit = false;
        int i = 0;
        while (i < args.length) {
            if (args[i] != null) {
                if (args[i].equals("-v")) {
                    verbose = false;
                } else if (args[i].equals("-e")) {
                    raiseException = true;
                } else if (args[i].equals("-p")) {
                    if (i + 1 < args.length) {
                        protocol = args[i + 1];
                    }
                } else if (args[i].equals("-i")) {
                    isImplicit = true;
                }
            }
            ++i;
        }
        InputStreamReader is = new InputStreamReader(System.in);
        BufferedReader br = new BufferedReader(is);
        FtpSession f = new FtpSession(protocol, isImplicit);
        f.setOutputStream(System.out);
        f.setVerbose(verbose);
        f.setRaiseException(raiseException);
        String str = "";
        System.out.print(Messages.getString("FtpCommandLine.0"));
        while (str != null && !str.equals("exit")) {
            try {
                str = br.readLine();
                f.executeCommand(str);
                if (str.contentEquals("exit")) continue;
                System.out.print(">");
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
            }
            catch (NumberFormatException e) {
                e.printStackTrace(System.out);
            }
            catch (FtpCommandException e) {
                e.printStackTrace(System.out);
            }
        }
    }
}

