/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ftp.commands;

import com.stambia.ftp.commands.FtpCommand;
import com.stambia.ftp.commands.FtpCommand_DELE;
import com.stambia.ftp.commands.Messages;
import com.stambia.ftp.exceptions.BadSyntaxException;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.utils.FtpCommandHandler;
import com.stambia.ftp.utils.FtpCommandResponses;
import com.stambia.ftp.utils.FtpFilesFilter;
import com.stambia.ftp.utils.FtpFilesOnlyFilter;
import com.stambia.ftp.utils.FtpStatisticListener;
import com.stambia.ftp.utils.FtpUtils;
import java.io.IOException;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileFilter;

public class FtpCommand_DELE_MULTIPLEFILES
extends FtpCommand<FTPClient> {
    public FtpCommand_DELE_MULTIPLEFILES(String command, String[] parameters) {
        super(command, parameters);
    }

    public FtpCommand_DELE_MULTIPLEFILES(FtpCommand<FTPClient> ftpCmd) {
        super(ftpCmd);
    }

    @Override
    public void executeCommand(FTPClient ftpCli, String localPath, boolean verbose, FtpCommandHandler commandHandler, List<FtpStatisticListener> statisticsListeners) throws IOException, FtpCommandException {
        StringBuilder response = new StringBuilder();
        String parameter0 = FtpUtils.removeFirstAndLastQuotes(this.getParameters()[0]);
        if (parameter0 != null) {
            if (parameter0.contains("*") || parameter0.contains("?") || parameter0.endsWith("/") || parameter0.endsWith("\\") || parameter0.equals("./")) {
                String serverSeparator = parameter0.contains("/") ? "/" : "\\";
                int serverSeparatorLastIndex = parameter0.lastIndexOf(serverSeparator);
                String filePath = ".";
                if (serverSeparatorLastIndex > 0) {
                    filePath = parameter0.substring(0, serverSeparatorLastIndex);
                }
                if (parameter0.endsWith("/") || parameter0.endsWith("\\")) {
                    this.appendResponse(ftpCli, verbose, commandHandler, response, filePath, statisticsListeners, new FtpFilesOnlyFilter(), parameter0);
                } else if (parameter0.contains("*") || parameter0.contains("?")) {
                    String filePattern = parameter0.substring(serverSeparatorLastIndex + 1);
                    this.appendResponse(ftpCli, verbose, commandHandler, response, filePath, statisticsListeners, new FtpFilesFilter(filePattern), parameter0);
                } else {
                    BadSyntaxException e = new BadSyntaxException(parameter0);
                    commandHandler.handleError(parameter0, e);
                }
            } else {
                FtpCommand_DELE ftpCmd = new FtpCommand_DELE(this);
                ((FtpCommand)ftpCmd).executeCommand(ftpCli, localPath, verbose, commandHandler, statisticsListeners);
            }
        } else {
            BadSyntaxException exception = new BadSyntaxException(FtpCommandResponses.MISSING_PARAMETER);
            commandHandler.handleError("", exception);
        }
    }

    private void appendResponse(FTPClient ftpCli, boolean verbose, FtpCommandHandler commandHandler, StringBuilder response, String filePath, List<FtpStatisticListener> statisticsListeners, FTPFileFilter fileFilter, String remotePath) throws IOException, FtpCommandException {
        FTPFile[] fileList = ftpCli.listFiles(filePath, fileFilter);
        if (fileList == null || fileList.length == 0) {
            throw new IOException(Messages.getString("FtpCommand_DELE_MULTIPLEFILES.0") + remotePath);
        }
        this.fireStatiscitEvent(statisticsListeners, FtpStatisticListener.Statistic.DELETED_FILES_NUMBER, fileList.length);
        FTPFile[] fTPFileArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            FTPFile file = fTPFileArray[n2];
            String fileName = file.getName();
            ftpCli.sendCommand("DELE", filePath + "/" + fileName);
            this.defaultResponseManager(ftpCli, verbose, commandHandler);
            this.fireStatiscitEvent(statisticsListeners, FtpStatisticListener.Statistic.DELETED_FILES_SIZE, file.getSize());
            ++n2;
        }
    }
}

