/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ftp.utils;

import com.stambia.ftp.commands.FtpCommands;
import com.stambia.ftp.utils.Messages;
import java.io.File;

public class FtpUtils {
    public static String addQuotes(String string) {
        if (((String)string).startsWith("\"") && ((String)string).endsWith("\"")) {
            return string;
        }
        if (!((String)string).contains(" ")) {
            return string;
        }
        string = "\"" + (String)string + "\"";
        return string;
    }

    public static String removeFirstQuotes(String string) {
        if (string != null && (string.startsWith("\"") || string.startsWith("'"))) {
            return string.substring(1);
        }
        return string;
    }

    public static String removeLastQuotes(String string) {
        if (string != null && (string.endsWith("\"") || string.endsWith("'"))) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String removeFirstAndLastQuotes(String string) {
        string = FtpUtils.removeFirstQuotes(string);
        string = FtpUtils.removeLastQuotes(string);
        return string;
    }

    public static String getFileName(String string) {
        File f = new File(FtpUtils.removeFirstAndLastQuotes(string));
        return f.getName();
    }

    public static String buildFilePath(String pathString, String defaultPath) {
        return FtpUtils.addLastSlash(FtpUtils.buildPath(pathString, defaultPath)) + FtpUtils.getFileName(pathString);
    }

    public static String buildPath(String pathString, String defaultPath) {
        String pathStringWithoutQuotes;
        if (defaultPath == null) {
            defaultPath = "";
        }
        if ((pathStringWithoutQuotes = FtpUtils.removeFirstAndLastQuotes(pathString)) != null) {
            pathString = pathStringWithoutQuotes.replace("*", "");
            Object newPath = "";
            File file = new File(pathString);
            if (file.isDirectory()) {
                return pathString;
            }
            if (!file.isAbsolute()) {
                if (pathString.startsWith("./")) {
                    newPath = FtpUtils.addLastSlash(defaultPath) + pathString.substring(2);
                    return FtpUtils.addLastSlash((String)newPath);
                }
                if (FtpUtils.isDirectory(pathString)) {
                    newPath = FtpUtils.addLastSlash(defaultPath) + pathString;
                    return newPath;
                }
                return FtpUtils.addLastSlash(defaultPath);
            }
            return FtpUtils.addLastSlash(file.getParent());
        }
        return pathStringWithoutQuotes;
    }

    public static String retrievePath(String path, String current) {
        String filePath = "";
        if (path.startsWith("*")) {
            filePath = current;
        } else if (path.contains("*")) {
            filePath = path.substring(0, path.indexOf("*"));
        } else if (path.contains("/")) {
            filePath = path.substring(0, path.lastIndexOf("/"));
        } else if (path.contains("\\")) {
            filePath = path.substring(0, path.lastIndexOf("\\"));
        }
        return FtpUtils.addLastSlash(filePath);
    }

    public static boolean isDirectoryAndExists(String path) {
        File file = new File(path);
        return file.isDirectory();
    }

    public static boolean isDirectory(String path) {
        return (path = FtpUtils.removeFirstAndLastQuotes(path)) != null && (path.endsWith("/") || path.endsWith("\\"));
    }

    public static boolean isVerbose(String verboseString, boolean actualVerbose) {
        if (verboseString == null || verboseString.equals("")) {
            return !actualVerbose;
        }
        if (verboseString.equals("y") || verboseString.equals("yes") || verboseString.equals("true")) {
            return true;
        }
        if (verboseString.equals("n") || verboseString.equals("no") || verboseString.equals("false")) {
            return false;
        }
        return !actualVerbose;
    }

    public static String[] removeFirstParameter(String[] parameters) {
        if (parameters.length > 1) {
            String[] newParameters = new String[parameters.length - 1];
            int i = 0;
            while (i < parameters.length - 1) {
                newParameters[i] = parameters[i + 1];
                ++i;
            }
            return newParameters;
        }
        return parameters;
    }

    public static String addLastSlash(String s) {
        if (s != null) {
            if (s.endsWith("/") || s.endsWith("\\")) {
                return s;
            }
            return s + "/";
        }
        return s;
    }

    public static String getStambiaCommandsHelp() {
        String lineReturn = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append(Messages.getString("FtpUtils.0") + lineReturn);
        int i = 0;
        for (String ftpCmd : FtpCommands.retrieveSortedCommandList()) {
            if (i < 5) {
                sb.append(ftpCmd + "\t");
                ++i;
                continue;
            }
            sb.append(ftpCmd + lineReturn);
            i = 0;
        }
        return sb.toString();
    }

    public static String removeLastLineReturn(String s) {
        boolean b = true;
        while (b) {
            if (s.endsWith("\n")) {
                s = s.substring(0, s.lastIndexOf("\n"));
                continue;
            }
            if (s.endsWith("\r")) {
                s = s.substring(0, s.lastIndexOf("\r"));
                continue;
            }
            b = false;
        }
        return s;
    }

    public static final String convertLineReturns(String message) {
        String userOs = System.getProperty("os.name").toLowerCase();
        String userSystemLineSeparator = System.lineSeparator();
        message = userOs.contains("win") ? message.replace(userSystemLineSeparator, "\\r\\n").replace("\n", userSystemLineSeparator).replace("\r", userSystemLineSeparator).replace("\\r\\n", userSystemLineSeparator) : (userOs.contains("mac") ? message.replace("\r\n", userSystemLineSeparator).replace("\n", userSystemLineSeparator) : message.replace("\r\n", userSystemLineSeparator).replace("\r", userSystemLineSeparator));
        return message;
    }
}

