/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import com.stambia.ftp.commands.FtpCommand;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.utils.FtpCommandHandler;
import com.stambia.ftp.utils.FtpCommandParser;
import com.stambia.ftp.utils.FtpCommandResponses;
import com.stambia.ftp.utils.FtpStatisticListener;
import com.stambia.ftp.utils.FtpUtils;
import com.stambia.ftp.utils.IFtpSession;
import com.stambia.sftp.Messages;
import com.stambia.sftp.commands.SFtpCommand_APPEND;
import com.stambia.sftp.commands.SFtpCommand_CD;
import com.stambia.sftp.commands.SFtpCommand_CHGRP;
import com.stambia.sftp.commands.SFtpCommand_CHMOD;
import com.stambia.sftp.commands.SFtpCommand_CHOWN;
import com.stambia.sftp.commands.SFtpCommand_GET;
import com.stambia.sftp.commands.SFtpCommand_HELP;
import com.stambia.sftp.commands.SFtpCommand_LCD;
import com.stambia.sftp.commands.SFtpCommand_LIST;
import com.stambia.sftp.commands.SFtpCommand_LPWD;
import com.stambia.sftp.commands.SFtpCommand_LSTAT;
import com.stambia.sftp.commands.SFtpCommand_MKDIR;
import com.stambia.sftp.commands.SFtpCommand_PUT;
import com.stambia.sftp.commands.SFtpCommand_PWD;
import com.stambia.sftp.commands.SFtpCommand_QUIT;
import com.stambia.sftp.commands.SFtpCommand_RENAME;
import com.stambia.sftp.commands.SFtpCommand_RM;
import com.stambia.sftp.commands.SFtpCommand_RMDIR;
import com.stambia.sftp.commands.SFtpCommand_STAT;
import com.stambia.sftp.commands.SFtpCommand_UNKNOWN;
import com.stambia.sftp.commands.SFtpCommand_VERSION;
import com.stambia.sftp.commands.SFtpCommands;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class SFtpSession
implements IFtpSession {
    public static int FTP_PORT = 21;
    public static int FTPS_PORT = 990;
    public static boolean isImplicitDefault = false;
    public static String defaultLocalPath = "./";
    private Session ftpCli;
    private ChannelSftp channelSftp;
    private FtpCommand<ChannelSftp> ftpCmd;
    private String localPath = defaultLocalPath;
    private String protocol;
    private boolean verbose = true;
    private boolean raiseException = false;
    private boolean quitBoolean = true;
    private OutputStream os;
    private PrintStream ps;
    private SFtpCommands enumCommand;
    List<FtpStatisticListener> statisticListeners = new ArrayList<FtpStatisticListener>();
    private StringBuilder commandLog = new StringBuilder();
    FtpCommandHandler commandHandler = new FtpCommandHandler(){

        @Override
        public void handleResponse(String response) {
            String returns = FtpUtils.convertLineReturns(response);
            if (SFtpSession.this.ps != null) {
                SFtpSession.this.ps.println(returns);
            }
            SFtpSession.this.commandLog.append(response);
        }

        @Override
        public void handleError(String response, FtpCommandException e) throws FtpCommandException {
            if (response != null) {
                if (SFtpSession.this.ps != null) {
                    SFtpSession.this.ps.println(e.getMessage());
                }
                SFtpSession.this.commandLog.append(e.getMessage());
            }
            if (SFtpSession.this.raiseException) {
                throw e;
            }
        }

        @Override
        public void handleError(String response, IOException e) throws IOException {
            if (response != null) {
                if (SFtpSession.this.ps != null) {
                    SFtpSession.this.ps.println(e.getMessage());
                }
                SFtpSession.this.commandLog.append(e.getMessage());
            }
            if (SFtpSession.this.raiseException) {
                throw e;
            }
        }
    };

    public SFtpSession(Session ftpCli, ChannelSftp channelSftp) {
        this.ftpCli = ftpCli;
        this.channelSftp = channelSftp;
    }

    public ChannelSftp getChannelSftp() {
        return this.channelSftp;
    }

    @Override
    public void addListener(FtpStatisticListener statisticListener) {
        this.statisticListeners.add(statisticListener);
    }

    public SFtpSession(Session ftpClient) {
        this.ftpCli = ftpClient;
    }

    @Override
    public String executeCommand(String commandString) throws IOException, FtpCommandException {
        String command = FtpCommandParser.retrieveCommand(commandString);
        String[] parameters = FtpCommandParser.retrieveParameters(commandString);
        this.commandLog.setLength(0);
        if (command != null && !command.equals("")) {
            if (command.equals("quote")) {
                if (parameters[0] != null) {
                    command = parameters[0];
                    parameters = FtpUtils.removeFirstParameter(parameters);
                } else {
                    this.commandHandler.handleResponse(FtpCommandResponses.MISSING_PARAMETER);
                    return FtpCommandResponses.MISSING_PARAMETER;
                }
            }
            try {
                this.enumCommand = SFtpCommands.valueOf(command);
            }
            catch (IllegalArgumentException e) {
                this.enumCommand = SFtpCommands.unknown;
            }
            try {
                switch (this.enumCommand) {
                    case ls: {
                        this.ftpCmd = new SFtpCommand_LIST(command, parameters);
                        break;
                    }
                    case list: {
                        this.ftpCmd = new SFtpCommand_LIST(command, parameters);
                        break;
                    }
                    case mlsd: {
                        this.ftpCmd = new SFtpCommand_LIST(command, parameters);
                        break;
                    }
                    case mlst: {
                        this.ftpCmd = new SFtpCommand_LIST(command, parameters);
                        break;
                    }
                    case nlst: {
                        this.ftpCmd = new SFtpCommand_LIST(command, parameters);
                        break;
                    }
                    case dir: {
                        this.ftpCmd = new SFtpCommand_LIST(command, parameters);
                        break;
                    }
                    case cwd: {
                        this.ftpCmd = new SFtpCommand_CD(command, parameters);
                        break;
                    }
                    case cd: {
                        this.ftpCmd = new SFtpCommand_CD(command, parameters);
                        break;
                    }
                    case lcd: {
                        this.ftpCmd = new SFtpCommand_LCD(command, parameters);
                        break;
                    }
                    case put: {
                        this.ftpCmd = new SFtpCommand_PUT(command, parameters);
                        break;
                    }
                    case send: {
                        this.ftpCmd = new SFtpCommand_PUT(command, parameters);
                        break;
                    }
                    case stor: {
                        this.ftpCmd = new SFtpCommand_PUT(command, parameters);
                        break;
                    }
                    case appe: {
                        this.ftpCmd = new SFtpCommand_APPEND(command, parameters);
                        break;
                    }
                    case append: {
                        this.ftpCmd = new SFtpCommand_APPEND(command, parameters);
                        break;
                    }
                    case get: {
                        this.ftpCmd = new SFtpCommand_GET(command, parameters);
                        break;
                    }
                    case recv: {
                        this.ftpCmd = new SFtpCommand_GET(command, parameters);
                        break;
                    }
                    case retr: {
                        this.ftpCmd = new SFtpCommand_GET(command, parameters);
                        break;
                    }
                    case dele: {
                        this.ftpCmd = new SFtpCommand_RM(command, parameters);
                        break;
                    }
                    case rm: {
                        this.ftpCmd = new SFtpCommand_RM(command, parameters);
                        break;
                    }
                    case delete: {
                        this.ftpCmd = new SFtpCommand_RM(command, parameters);
                        break;
                    }
                    case rmd: {
                        this.ftpCmd = new SFtpCommand_RMDIR(command, parameters);
                        break;
                    }
                    case rmdir: {
                        this.ftpCmd = new SFtpCommand_RMDIR(command, parameters);
                        break;
                    }
                    case rename: {
                        this.ftpCmd = new SFtpCommand_RENAME(command, parameters);
                        break;
                    }
                    case pwd: {
                        this.ftpCmd = new SFtpCommand_PWD(command, parameters);
                        break;
                    }
                    case lpwd: {
                        this.ftpCmd = new SFtpCommand_LPWD(command, parameters);
                        break;
                    }
                    case mkd: {
                        this.ftpCmd = new SFtpCommand_MKDIR(command, parameters);
                        break;
                    }
                    case mkdir: {
                        this.ftpCmd = new SFtpCommand_MKDIR(command, parameters);
                        break;
                    }
                    case rhelp: {
                        this.ftpCmd = new SFtpCommand_HELP(command, parameters);
                        break;
                    }
                    case help: {
                        this.commandHandler.handleResponse(FtpUtils.getStambiaCommandsHelp());
                        return this.getLog();
                    }
                    case stat: {
                        this.ftpCmd = new SFtpCommand_STAT(command, parameters);
                        break;
                    }
                    case lstat: {
                        this.ftpCmd = new SFtpCommand_LSTAT(command, parameters);
                        break;
                    }
                    case status: {
                        this.ftpCmd = new SFtpCommand_STAT(command, parameters);
                        break;
                    }
                    case version: {
                        this.ftpCmd = new SFtpCommand_VERSION(command, parameters);
                        break;
                    }
                    case chgrp: {
                        this.ftpCmd = new SFtpCommand_CHGRP(command, parameters);
                        break;
                    }
                    case chown: {
                        this.ftpCmd = new SFtpCommand_CHOWN(command, parameters);
                        break;
                    }
                    case chmod: {
                        this.ftpCmd = new SFtpCommand_CHMOD(command, parameters);
                        break;
                    }
                    case quit: 
                    case close: 
                    case exit: 
                    case disconnect: 
                    case bye: {
                        this.quitBoolean = false;
                        this.ftpCmd = new SFtpCommand_QUIT(command, parameters);
                        break;
                    }
                    case unknown: {
                        this.quitBoolean = false;
                        this.ftpCmd = new SFtpCommand_UNKNOWN(command, parameters);
                        break;
                    }
                    case verbose: {
                        this.verbose = FtpUtils.isVerbose(parameters[0], this.verbose);
                        if (this.verbose) {
                            this.commandHandler.handleResponse(FtpCommandResponses.VERBOSE_YES);
                            return FtpCommandResponses.VERBOSE_YES;
                        }
                        this.commandHandler.handleResponse(FtpCommandResponses.VERBOSE_NO);
                        return FtpCommandResponses.VERBOSE_NO;
                    }
                    default: {
                        this.commandHandler.handleResponse(Messages.getString("SFtpSession.0"));
                    }
                }
                this.ftpCmd.executeCommand(this.channelSftp, this.localPath, this.verbose, this.commandHandler, this.statisticListeners);
                return this.getLog();
            }
            catch (IOException e) {
                this.commandHandler.handleError("", e);
                return this.getLog();
            }
        }
        this.commandHandler.handleResponse(FtpCommandResponses.MISSING_COMMAND);
        return this.getLog();
    }

    public void executeCommandList(String commandList) throws IOException, FtpCommandException {
        this.quitBoolean = true;
        if ((commandList.contains("\n") || commandList.contains("\\n")) && commandList != null) {
            String[] commands;
            String[] stringArray = commands = commandList.split("\\n");
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                String command = stringArray[n2];
                this.executeCommand(command);
                ++n2;
            }
            if (this.quitBoolean && this.ftpCli != null) {
                this.ftpCli.disconnect();
            }
        } else {
            this.executeCommand(commandList);
        }
    }

    @Override
    public void dispose() throws IOException {
        if (this.ftpCli != null) {
            this.ftpCli.disconnect();
        }
        if (this.ps != null) {
            this.ps.close();
        }
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String path) {
        this.localPath = path;
    }

    public Session getFtpCli() {
        return this.ftpCli;
    }

    public void setFtpCli(Session ftpCli) {
        this.ftpCli = ftpCli;
    }

    public String getLog() {
        return this.commandLog.toString();
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    @Override
    public void setOutputStream(OutputStream os) {
        this.os = os;
        this.ps = new PrintStream(os);
    }

    @Override
    public void setRaiseException(boolean raiseException) {
        this.raiseException = raiseException;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public List<FtpStatisticListener> getStatisticListeners() {
        return this.statisticListeners;
    }
}

