/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.sftp.commands;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import com.stambia.ftp.commands.FtpCommand;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.utils.FtpCommandHandler;
import com.stambia.ftp.utils.FtpStatisticListener;
import com.stambia.ftp.utils.FtpUtils;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class SFtpCommand_LIST
extends FtpCommand<ChannelSftp> {
    public SFtpCommand_LIST(String command, String[] parameters) {
        super(command, parameters);
    }

    public SFtpCommand_LIST(FtpCommand<ChannelSftp> ftpCmd) {
        super(ftpCmd);
    }

    @Override
    public void executeCommand(ChannelSftp ftpCli, String localPath, boolean verbose, FtpCommandHandler commandHandler, List<FtpStatisticListener> statisticsListeners) throws IOException, FtpCommandException {
        String parameter1;
        StringBuilder response = new StringBuilder();
        int listSize = 0;
        String parameter0 = FtpUtils.removeFirstAndLastQuotes(this.getParameters()[0]);
        if (parameter0 == null) {
            parameter0 = "";
        }
        if ((parameter1 = FtpUtils.removeFirstAndLastQuotes(this.getParameters()[1])) == null) {
            parameter1 = "";
        }
        if (parameter0.equals("") || parameter0.equals("-l")) {
            try {
                Vector fileList = ftpCli.ls(localPath);
                if (verbose) {
                    int i = 0;
                    while (i < fileList.size()) {
                        ChannelSftp.LsEntry ls = (ChannelSftp.LsEntry)fileList.elementAt(i);
                        if (!ls.getAttrs().isDir()) {
                            this.fireStatiscitEvent(statisticsListeners, FtpStatisticListener.Statistic.LISTED_FILES_SIZE, ls.getAttrs().getSize());
                            if (parameter0.equals("-l")) {
                                response.append(ls.getLongname() + "\n");
                            } else {
                                response.append(ls.getFilename() + "\n");
                            }
                            ++listSize;
                        }
                        ++i;
                    }
                } else {
                    response.append(fileList.toString());
                }
                this.fireStatiscitEvent(statisticsListeners, FtpStatisticListener.Statistic.LISTED_FILES_NUMBER, listSize);
            }
            catch (SftpException e) {
                FtpCommandException ftpCommandException = new FtpCommandException(e.getMessage());
                commandHandler.handleError("", ftpCommandException);
            }
        } else {
            try {
                Vector fileList = ftpCli.ls(parameter0);
                if (verbose) {
                    if (parameter1.equals("-l")) {
                        int i = 0;
                        while (i < fileList.size()) {
                            response.append(((ChannelSftp.LsEntry)fileList.elementAt(i)).getLongname() + "\n");
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < fileList.size()) {
                            response.append(((ChannelSftp.LsEntry)fileList.elementAt(i)).getFilename() + "\n");
                            ++i;
                        }
                    }
                } else {
                    response.append(fileList.toString());
                }
            }
            catch (SftpException e) {
                FtpCommandException ftpCommandException = new FtpCommandException(e.getMessage());
                commandHandler.handleError("", ftpCommandException);
            }
        }
        commandHandler.handleResponse(response.toString());
    }
}

