/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.ClassUtils;
import org.springframework.ws.server.endpoint.adapter.DefaultMethodEndpointAdapter;
import org.springframework.ws.server.endpoint.adapter.method.MarshallingPayloadMethodProcessor;
import org.springframework.ws.server.endpoint.adapter.method.MessageContextMethodArgumentResolver;
import org.springframework.ws.server.endpoint.adapter.method.SourcePayloadMethodProcessor;
import org.springframework.ws.server.endpoint.adapter.method.StaxPayloadMethodArgumentResolver;
import org.springframework.ws.server.endpoint.adapter.method.XPathParamMethodArgumentResolver;
import org.springframework.ws.server.endpoint.adapter.method.dom.Dom4jPayloadMethodProcessor;
import org.springframework.ws.server.endpoint.adapter.method.dom.DomPayloadMethodProcessor;
import org.springframework.ws.server.endpoint.adapter.method.dom.JDomPayloadMethodProcessor;
import org.springframework.ws.server.endpoint.adapter.method.dom.XomPayloadMethodProcessor;
import org.springframework.ws.server.endpoint.adapter.method.jaxb.JaxbElementPayloadMethodProcessor;
import org.springframework.ws.server.endpoint.adapter.method.jaxb.XmlRootElementPayloadMethodProcessor;
import org.springframework.ws.server.endpoint.mapping.PayloadRootAnnotationMethodEndpointMapping;
import org.springframework.ws.soap.addressing.server.AnnotationActionEndpointMapping;
import org.springframework.ws.soap.server.endpoint.SimpleSoapExceptionResolver;
import org.springframework.ws.soap.server.endpoint.SoapFaultAnnotationExceptionResolver;
import org.springframework.ws.soap.server.endpoint.adapter.method.SoapHeaderElementMethodArgumentResolver;
import org.springframework.ws.soap.server.endpoint.adapter.method.SoapMethodArgumentResolver;
import org.springframework.ws.soap.server.endpoint.mapping.SoapActionAnnotationMethodEndpointMapping;
import org.w3c.dom.Element;

class AnnotationDrivenBeanDefinitionParser
implements BeanDefinitionParser {
    private static final boolean dom4jPresent = ClassUtils.isPresent((String)"org.dom4j.Element", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader());
    private static final boolean jaxb2Present = ClassUtils.isPresent((String)"jakarta.xml.bind.Binder", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader());
    private static final boolean jdomPresent = ClassUtils.isPresent((String)"org.jdom2.Element", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader());
    private static final boolean staxPresent = ClassUtils.isPresent((String)"javax.xml.stream.XMLInputFactory", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader());
    private static final boolean xomPresent = ClassUtils.isPresent((String)"nu.xom.Element", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader());

    AnnotationDrivenBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource((Object)element);
        CompositeComponentDefinition compDefinition = new CompositeComponentDefinition(element.getTagName(), source);
        parserContext.pushContainingComponent(compDefinition);
        this.registerEndpointMappings(source, parserContext);
        this.registerEndpointAdapters(element, source, parserContext);
        this.registerEndpointExceptionResolvers(source, parserContext);
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    private void registerEndpointMappings(Object source, ParserContext parserContext) {
        RootBeanDefinition payloadRootMappingDef = this.createBeanDefinition(PayloadRootAnnotationMethodEndpointMapping.class, source);
        payloadRootMappingDef.getPropertyValues().add("order", (Object)0);
        parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)payloadRootMappingDef);
        RootBeanDefinition soapActionMappingDef = this.createBeanDefinition(SoapActionAnnotationMethodEndpointMapping.class, source);
        soapActionMappingDef.getPropertyValues().add("order", (Object)1);
        parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)soapActionMappingDef);
        RootBeanDefinition annActionMappingDef = this.createBeanDefinition(AnnotationActionEndpointMapping.class, source);
        annActionMappingDef.getPropertyValues().add("order", (Object)2);
        parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)annActionMappingDef);
    }

    private void registerEndpointAdapters(Element element, Object source, ParserContext parserContext) {
        RootBeanDefinition adapterDef = this.createBeanDefinition(DefaultMethodEndpointAdapter.class, source);
        ManagedList argumentResolvers = new ManagedList();
        argumentResolvers.setSource(source);
        ManagedList returnValueHandlers = new ManagedList();
        returnValueHandlers.setSource(source);
        argumentResolvers.add((Object)this.createBeanDefinition(MessageContextMethodArgumentResolver.class, source));
        argumentResolvers.add((Object)this.createBeanDefinition(XPathParamMethodArgumentResolver.class, source));
        argumentResolvers.add((Object)this.createBeanDefinition(SoapMethodArgumentResolver.class, source));
        argumentResolvers.add((Object)this.createBeanDefinition(SoapHeaderElementMethodArgumentResolver.class, source));
        RuntimeBeanReference domProcessor = this.createBeanReference(DomPayloadMethodProcessor.class, source, parserContext);
        argumentResolvers.add((Object)domProcessor);
        returnValueHandlers.add((Object)domProcessor);
        RuntimeBeanReference sourceProcessor = this.createBeanReference(SourcePayloadMethodProcessor.class, source, parserContext);
        argumentResolvers.add((Object)sourceProcessor);
        returnValueHandlers.add((Object)sourceProcessor);
        if (dom4jPresent) {
            RuntimeBeanReference dom4jProcessor = this.createBeanReference(Dom4jPayloadMethodProcessor.class, source, parserContext);
            argumentResolvers.add((Object)dom4jProcessor);
            returnValueHandlers.add((Object)dom4jProcessor);
        }
        if (jaxb2Present) {
            RuntimeBeanReference xmlRootElementProcessor = this.createBeanReference(XmlRootElementPayloadMethodProcessor.class, source, parserContext);
            argumentResolvers.add((Object)xmlRootElementProcessor);
            returnValueHandlers.add((Object)xmlRootElementProcessor);
            RuntimeBeanReference jaxbElementProcessor = this.createBeanReference(JaxbElementPayloadMethodProcessor.class, source, parserContext);
            argumentResolvers.add((Object)jaxbElementProcessor);
            returnValueHandlers.add((Object)jaxbElementProcessor);
        }
        if (jdomPresent) {
            RuntimeBeanReference jdomProcessor = this.createBeanReference(JDomPayloadMethodProcessor.class, source, parserContext);
            argumentResolvers.add((Object)jdomProcessor);
            returnValueHandlers.add((Object)jdomProcessor);
        }
        if (staxPresent) {
            argumentResolvers.add((Object)this.createBeanDefinition(StaxPayloadMethodArgumentResolver.class, source));
        }
        if (xomPresent) {
            RuntimeBeanReference xomProcessor = this.createBeanReference(XomPayloadMethodProcessor.class, source, parserContext);
            argumentResolvers.add((Object)xomProcessor);
            returnValueHandlers.add((Object)xomProcessor);
        }
        if (element.hasAttribute("marshaller")) {
            RuntimeBeanReference marshallerReference = new RuntimeBeanReference(element.getAttribute("marshaller"));
            RuntimeBeanReference unmarshallerReference = element.hasAttribute("unmarshaller") ? new RuntimeBeanReference(element.getAttribute("unmarshaller")) : marshallerReference;
            RootBeanDefinition marshallingProcessorDef = this.createBeanDefinition(MarshallingPayloadMethodProcessor.class, source);
            marshallingProcessorDef.getPropertyValues().add("marshaller", (Object)marshallerReference);
            marshallingProcessorDef.getPropertyValues().add("unmarshaller", (Object)unmarshallerReference);
            argumentResolvers.add((Object)marshallingProcessorDef);
            returnValueHandlers.add((Object)marshallingProcessorDef);
        }
        adapterDef.getPropertyValues().add("methodArgumentResolvers", (Object)argumentResolvers);
        adapterDef.getPropertyValues().add("methodReturnValueHandlers", (Object)returnValueHandlers);
        parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)adapterDef);
    }

    private void registerEndpointExceptionResolvers(Object source, ParserContext parserContext) {
        RootBeanDefinition annotationResolverDef = this.createBeanDefinition(SoapFaultAnnotationExceptionResolver.class, source);
        annotationResolverDef.getPropertyValues().add("order", (Object)0);
        parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)annotationResolverDef);
        RootBeanDefinition simpleResolverDef = this.createBeanDefinition(SimpleSoapExceptionResolver.class, source);
        simpleResolverDef.getPropertyValues().add("order", (Object)Integer.MAX_VALUE);
        parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)simpleResolverDef);
    }

    private RuntimeBeanReference createBeanReference(Class<?> beanClass, Object source, ParserContext parserContext) {
        RootBeanDefinition beanDefinition = this.createBeanDefinition(beanClass, source);
        String beanName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)beanDefinition);
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)beanDefinition, beanName));
        return new RuntimeBeanReference(beanName);
    }

    private RootBeanDefinition createBeanDefinition(Class<?> beanClass, Object source) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(beanClass);
        beanDefinition.setSource(source);
        beanDefinition.setRole(2);
        return beanDefinition;
    }
}

