/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.config.annotation;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.server.endpoint.adapter.DefaultMethodEndpointAdapter;
import org.springframework.ws.server.endpoint.adapter.method.MethodArgumentResolver;
import org.springframework.ws.server.endpoint.adapter.method.MethodReturnValueHandler;
import org.springframework.ws.server.endpoint.mapping.PayloadRootAnnotationMethodEndpointMapping;
import org.springframework.ws.soap.addressing.server.AnnotationActionEndpointMapping;
import org.springframework.ws.soap.server.endpoint.SimpleSoapExceptionResolver;
import org.springframework.ws.soap.server.endpoint.SoapFaultAnnotationExceptionResolver;
import org.springframework.ws.soap.server.endpoint.mapping.SoapActionAnnotationMethodEndpointMapping;

public class WsConfigurationSupport {
    private List<EndpointInterceptor> interceptors;

    @Bean
    public PayloadRootAnnotationMethodEndpointMapping payloadRootAnnotationMethodEndpointMapping() {
        PayloadRootAnnotationMethodEndpointMapping endpointMapping = new PayloadRootAnnotationMethodEndpointMapping();
        endpointMapping.setOrder(0);
        endpointMapping.setInterceptors(this.getInterceptors());
        return endpointMapping;
    }

    @Bean
    public SoapActionAnnotationMethodEndpointMapping soapActionAnnotationMethodEndpointMapping() {
        SoapActionAnnotationMethodEndpointMapping endpointMapping = new SoapActionAnnotationMethodEndpointMapping();
        endpointMapping.setOrder(1);
        endpointMapping.setInterceptors(this.getInterceptors());
        return endpointMapping;
    }

    @Bean
    public AnnotationActionEndpointMapping annotationActionEndpointMapping() {
        AnnotationActionEndpointMapping endpointMapping = new AnnotationActionEndpointMapping();
        endpointMapping.setOrder(2);
        endpointMapping.setPostInterceptors(this.getInterceptors());
        return endpointMapping;
    }

    protected final EndpointInterceptor[] getInterceptors() {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<EndpointInterceptor>();
            this.addInterceptors(this.interceptors);
        }
        return this.interceptors.toArray(new EndpointInterceptor[0]);
    }

    protected void addInterceptors(List<EndpointInterceptor> interceptors) {
    }

    @Bean
    public DefaultMethodEndpointAdapter defaultMethodEndpointAdapter() {
        DefaultMethodEndpointAdapter adapter = DefaultMethodEndpointAdapter.withDefaults();
        LinkedList<MethodArgumentResolver> argumentResolvers = new LinkedList<MethodArgumentResolver>(adapter.getMethodArgumentResolvers());
        this.addArgumentResolvers(argumentResolvers);
        adapter.setMethodArgumentResolvers(argumentResolvers);
        LinkedList<MethodReturnValueHandler> returnValueHandlers = new LinkedList<MethodReturnValueHandler>(adapter.getMethodReturnValueHandlers());
        this.addReturnValueHandlers(returnValueHandlers);
        adapter.setMethodReturnValueHandlers(returnValueHandlers);
        return adapter;
    }

    protected void addArgumentResolvers(List<MethodArgumentResolver> argumentResolvers) {
    }

    protected void addReturnValueHandlers(List<MethodReturnValueHandler> returnValueHandlers) {
    }

    @Bean
    public SoapFaultAnnotationExceptionResolver soapFaultAnnotationExceptionResolver() {
        SoapFaultAnnotationExceptionResolver exceptionResolver = new SoapFaultAnnotationExceptionResolver();
        exceptionResolver.setOrder(0);
        return exceptionResolver;
    }

    @Bean
    public SimpleSoapExceptionResolver simpleSoapExceptionResolver() {
        SimpleSoapExceptionResolver exceptionResolver = new SimpleSoapExceptionResolver();
        exceptionResolver.setOrder(Integer.MAX_VALUE);
        return exceptionResolver;
    }
}

