/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Ordered;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointExceptionResolver;
import org.springframework.ws.server.endpoint.MethodEndpoint;

public abstract class AbstractEndpointExceptionResolver
implements EndpointExceptionResolver,
Ordered {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int order = Integer.MAX_VALUE;
    private Set<?> mappedEndpoints;
    private Log warnLogger;

    public void setMappedEndpoints(Set<?> mappedEndpoints) {
        this.mappedEndpoints = mappedEndpoints;
    }

    public void setWarnLogCategory(String loggerName) {
        this.warnLogger = LogFactory.getLog((String)loggerName);
    }

    public final void setOrder(int order) {
        this.order = order;
    }

    public final int getOrder() {
        return this.order;
    }

    @Override
    public final boolean resolveException(MessageContext messageContext, Object endpoint, Exception ex) {
        boolean resolved;
        Object mappedEndpoint;
        if (endpoint instanceof MethodEndpoint) {
            MethodEndpoint methodEndpoint = (MethodEndpoint)endpoint;
            v0 = methodEndpoint.getBean();
        } else {
            v0 = mappedEndpoint = endpoint;
        }
        if (this.mappedEndpoints != null && !this.mappedEndpoints.contains(mappedEndpoint)) {
            return false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolving exception from endpoint [" + String.valueOf(endpoint) + "]: " + String.valueOf(ex)));
        }
        if (resolved = this.resolveExceptionInternal(messageContext, endpoint, ex)) {
            this.logException(ex, messageContext);
        }
        return resolved;
    }

    protected void logException(Exception ex, MessageContext messageContext) {
        if (this.warnLogger != null && this.warnLogger.isWarnEnabled()) {
            this.warnLogger.warn((Object)this.buildLogMessage(ex, messageContext), (Throwable)ex);
        }
    }

    protected String buildLogMessage(Exception ex, MessageContext messageContext) {
        return "Endpoint execution resulted in exception";
    }

    protected abstract boolean resolveExceptionInternal(MessageContext var1, Object var2, Exception var3);
}

