/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint;

import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointExceptionResolver;
import org.springframework.ws.server.endpoint.AbstractEndpointExceptionResolver;

public class CompositeEndpointExceptionResolver
implements EndpointExceptionResolver {
    private final Iterable<AbstractEndpointExceptionResolver> resolvers;

    public CompositeEndpointExceptionResolver(Iterable<AbstractEndpointExceptionResolver> resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    public final boolean resolveException(MessageContext messageContext, Object endpoint, Exception ex) {
        AbstractEndpointExceptionResolver currentResolver = null;
        for (AbstractEndpointExceptionResolver resolver : this.resolvers) {
            currentResolver = resolver;
            if (!currentResolver.resolveException(messageContext, endpoint, ex)) continue;
            return true;
        }
        if (currentResolver != null) {
            currentResolver.logException(ex, messageContext);
        }
        return false;
    }
}

