/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.mapping.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.JAXBIntrospector;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.springframework.core.MethodParameter;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.mapping.AbstractAnnotationMethodEndpointMapping;
import org.springframework.ws.server.endpoint.support.PayloadRootUtils;
import org.springframework.xml.transform.TransformerHelper;

public class XmlRootElementEndpointMapping
extends AbstractAnnotationMethodEndpointMapping<QName> {
    private TransformerHelper transformerHelper = new TransformerHelper();

    public void setTransformerHelper(TransformerHelper transformerHelper) {
        this.transformerHelper = transformerHelper;
    }

    @Override
    protected QName getLookupKeyForMethod(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            QName result;
            MethodParameter methodParameter = new MethodParameter(method, i);
            Class parameterType = methodParameter.getParameterType();
            if (!parameterType.isAnnotationPresent(XmlRootElement.class) || (result = this.handleRootElement(parameterType)) == null) continue;
            return result;
        }
        return null;
    }

    private QName handleRootElement(Class<?> parameterType) {
        try {
            Object param = parameterType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            QName result = this.getElementName(parameterType, param);
            if (result != null) {
                return result;
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private QName getElementName(Class<?> parameterType, Object param) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{parameterType});
            JAXBIntrospector introspector = context.createJAXBIntrospector();
            return introspector.getElementName(param);
        }
        catch (JAXBException ex) {
            return null;
        }
    }

    @Override
    protected QName getLookupKeyForMessage(MessageContext messageContext) throws Exception {
        return PayloadRootUtils.getPayloadRootQName(messageContext.getRequest().getPayloadSource(), this.transformerHelper);
    }
}

