/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFault;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.springframework.ws.soap.saaj.SaajSoapFault;
import org.springframework.ws.soap.saaj.SaajSoapFaultException;
import org.springframework.ws.soap.soap12.Soap12Fault;

class SaajSoap12Fault
extends SaajSoapFault
implements Soap12Fault {
    SaajSoap12Fault(SOAPFault fault) {
        super(fault);
    }

    @Override
    public String getFaultActorOrRole() {
        return this.getSaajFault().getFaultRole();
    }

    @Override
    public void setFaultActorOrRole(String faultRole) {
        try {
            this.getSaajFault().setFaultRole(faultRole);
        }
        catch (SOAPException ex) {
            throw new SaajSoapFaultException(ex);
        }
    }

    @Override
    public Iterator<QName> getFaultSubcodes() {
        return this.getSaajFault().getFaultSubcodes();
    }

    @Override
    public void addFaultSubcode(QName subcode) {
        try {
            this.getSaajFault().appendFaultSubcode(subcode);
        }
        catch (SOAPException ex) {
            throw new SaajSoapFaultException(ex);
        }
    }

    @Override
    public String getFaultNode() {
        return this.getSaajFault().getFaultNode();
    }

    @Override
    public void setFaultNode(String uri) {
        try {
            this.getSaajFault().setFaultNode(uri);
        }
        catch (SOAPException ex) {
            throw new SaajSoapFaultException(ex);
        }
    }

    @Override
    public void setFaultReasonText(Locale locale, String text) {
        try {
            this.getSaajFault().addFaultReasonText(text, locale);
        }
        catch (SOAPException ex) {
            throw new SaajSoapFaultException(ex);
        }
    }

    @Override
    public String getFaultReasonText(Locale locale) {
        try {
            return this.getSaajFault().getFaultReasonText(locale);
        }
        catch (SOAPException ex) {
            throw new SaajSoapFaultException(ex);
        }
    }

    @Override
    public String getFaultStringOrReason() {
        return this.getSaajFault().getFaultString();
    }
}

