/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import jakarta.xml.soap.Detail;
import jakarta.xml.soap.DetailEntry;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFaultElement;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapFaultDetail;
import org.springframework.ws.soap.SoapFaultDetailElement;
import org.springframework.ws.soap.saaj.SaajSoapElement;
import org.springframework.ws.soap.saaj.SaajSoapFaultDetailElement;
import org.springframework.ws.soap.saaj.SaajSoapFaultException;
import org.w3c.dom.Node;

class SaajSoapFaultDetail
extends SaajSoapElement<SOAPFaultElement>
implements SoapFaultDetail {
    SaajSoapFaultDetail(SOAPFaultElement faultElement) {
        super(faultElement);
    }

    @Override
    public Result getResult() {
        return new DOMResult((Node)this.getSaajDetail());
    }

    @Override
    public SoapFaultDetailElement addFaultDetailElement(QName name) {
        try {
            DetailEntry detailEntry = this.getSaajDetail().addDetailEntry(name);
            return new SaajSoapFaultDetailElement(detailEntry);
        }
        catch (SOAPException ex) {
            throw new SaajSoapFaultException(ex);
        }
    }

    @Override
    public Iterator<SoapFaultDetailElement> getDetailEntries() {
        Iterator iterator = this.getSaajDetail().getDetailEntries();
        return new SaajSoapFaultDetailElementIterator(iterator);
    }

    protected Detail getSaajDetail() {
        return (Detail)this.getSaajElement();
    }

    private static final class SaajSoapFaultDetailElementIterator
    implements Iterator<SoapFaultDetailElement> {
        private final Iterator<DetailEntry> iterator;

        private SaajSoapFaultDetailElementIterator(Iterator<DetailEntry> iterator) {
            Assert.notNull(iterator, (String)"No iterator given");
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public SoapFaultDetailElement next() {
            DetailEntry saajDetailEntry = this.iterator.next();
            return new SaajSoapFaultDetailElement(saajDetailEntry);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

