/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInvocationChain;
import org.springframework.ws.server.MessageDispatcher;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.soap.SoapFault;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.server.SoapEndpointInterceptor;
import org.springframework.ws.soap.server.SoapEndpointInvocationChain;
import org.springframework.ws.soap.soap11.Soap11Header;
import org.springframework.ws.soap.soap12.Soap12Header;

public class SoapMessageDispatcher
extends MessageDispatcher {
    public static final String DEFAULT_MUST_UNDERSTAND_FAULT_STRING = "One or more mandatory SOAP header blocks not understood";
    private String mustUnderstandFaultString = "One or more mandatory SOAP header blocks not understood";
    private Locale mustUnderstandFaultStringLocale = Locale.ENGLISH;

    public void setMustUnderstandFaultString(String mustUnderstandFaultString) {
        this.mustUnderstandFaultString = mustUnderstandFaultString;
    }

    public void setMustUnderstandFaultStringLocale(Locale mustUnderstandFaultStringLocale) {
        this.mustUnderstandFaultStringLocale = mustUnderstandFaultStringLocale;
    }

    @Override
    protected boolean handleRequest(EndpointInvocationChain mappedEndpoint, MessageContext messageContext) {
        if (messageContext.getRequest() instanceof SoapMessage) {
            String[] actorsOrRoles = null;
            boolean isUltimateReceiver = true;
            if (mappedEndpoint instanceof SoapEndpointInvocationChain) {
                SoapEndpointInvocationChain soapChain = (SoapEndpointInvocationChain)mappedEndpoint;
                actorsOrRoles = soapChain.getActorsOrRoles();
                isUltimateReceiver = soapChain.isUltimateReceiver();
            }
            return this.handleHeaders(mappedEndpoint, messageContext, actorsOrRoles, isUltimateReceiver);
        }
        return true;
    }

    private boolean handleHeaders(EndpointInvocationChain mappedEndpoint, MessageContext messageContext, String[] actorsOrRoles, boolean isUltimateReceiver) {
        SoapMessage soapRequest = (SoapMessage)messageContext.getRequest();
        SoapHeader soapHeader = soapRequest.getSoapHeader();
        if (soapHeader == null) {
            return true;
        }
        Iterator<SoapHeaderElement> headerIterator = soapHeader instanceof Soap11Header ? ((Soap11Header)soapHeader).examineHeaderElementsToProcess(actorsOrRoles) : ((Soap12Header)soapHeader).examineHeaderElementsToProcess(actorsOrRoles, isUltimateReceiver);
        ArrayList<QName> notUnderstoodHeaderNames = new ArrayList<QName>();
        while (headerIterator.hasNext()) {
            SoapHeaderElement headerElement = headerIterator.next();
            QName headerName = headerElement.getName();
            if (headerElement.getMustUnderstand() && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Handling MustUnderstand header " + String.valueOf(headerName)));
            }
            if (!headerElement.getMustUnderstand() || this.headerUnderstood(mappedEndpoint, headerElement)) continue;
            notUnderstoodHeaderNames.add(headerName);
        }
        if (notUnderstoodHeaderNames.isEmpty()) {
            return true;
        }
        SoapMessage response = (SoapMessage)messageContext.getResponse();
        this.createMustUnderstandFault(response, notUnderstoodHeaderNames, actorsOrRoles);
        return false;
    }

    private boolean headerUnderstood(EndpointInvocationChain mappedEndpoint, SoapHeaderElement headerElement) {
        Object[] interceptors = mappedEndpoint.getInterceptors();
        if (ObjectUtils.isEmpty((Object[])interceptors)) {
            return false;
        }
        for (Object interceptor : interceptors) {
            if (!(interceptor instanceof SoapEndpointInterceptor) || !((SoapEndpointInterceptor)interceptor).understands(headerElement)) continue;
            return true;
        }
        return false;
    }

    private void createMustUnderstandFault(SoapMessage soapResponse, List<QName> notUnderstoodHeaderNames, String[] actorsOrRoles) {
        SoapHeader header;
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Could not handle mustUnderstand headers: " + StringUtils.collectionToCommaDelimitedString(notUnderstoodHeaderNames) + ". Returning fault"));
        }
        SoapBody responseBody = soapResponse.getSoapBody();
        SoapFault fault = responseBody.addMustUnderstandFault(this.mustUnderstandFaultString, this.mustUnderstandFaultStringLocale);
        if (!ObjectUtils.isEmpty((Object[])actorsOrRoles)) {
            fault.setFaultActorOrRole(actorsOrRoles[0]);
        }
        if ((header = soapResponse.getSoapHeader()) instanceof Soap12Header) {
            Soap12Header soap12Header = (Soap12Header)header;
            for (QName headerName : notUnderstoodHeaderNames) {
                soap12Header.addNotUnderstoodHeaderElement(headerName);
            }
        }
    }
}

