/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine;

import com.indy.engine.core.ISessionContext;
import com.indy.engine.core.common.objects2.IVariable;

public class VariableResolver {
    private VariableResolver() {
    }

    public static String resolveVariableExpressions(String callingVariable, ISessionContext ctx, String vCode) {
        if (vCode.indexOf("${") == -1) {
            return vCode;
        }
        StringBuilder result = new StringBuilder();
        int currIndex = -1;
        while (currIndex + 1 < vCode.length()) {
            char curChar;
            if ((curChar = vCode.charAt(++currIndex)) == '$' && currIndex + 1 < vCode.length() && vCode.charAt(currIndex + 1) == '{') {
                StringBuilder varName = new StringBuilder();
                boolean variableSyntaxDetected = false;
                int k = currIndex + 2;
                while (k < vCode.length()) {
                    char c = vCode.charAt(k);
                    if (c == '}' && k + 1 < vCode.length() && vCode.charAt(k + 1) == '$') {
                        variableSyntaxDetected = true;
                        currIndex = k + 1;
                        break;
                    }
                    varName.append(c);
                    ++k;
                }
                if (variableSyntaxDetected) {
                    String sResolvedVar = ctx.resolveVariableName(varName.toString(), callingVariable);
                    IVariable var = ctx.getVariable(sResolvedVar);
                    if (var != null) {
                        result.append(var.getValue());
                        continue;
                    }
                    result.append("${" + varName.toString() + "}$");
                    continue;
                }
                result.append(curChar);
                continue;
            }
            result.append(curChar);
        }
        return result.toString();
    }
}

