/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.command.impl;

import com.indy.engine.Global;
import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.command.impl.EncryptCommand;
import com.indy.engine.command.impl.ExecuteDeliveryCommand;
import com.indy.engine.command.impl.GetSchedules;
import com.indy.engine.command.impl.ListRemoteConnectionCommand;
import com.indy.engine.command.impl.ListRepositoriesCommand;
import com.indy.engine.command.impl.ListScheduleCommand;
import com.indy.engine.command.impl.MarkInactiveSessionsAsDead;
import com.indy.engine.command.impl.Messages;
import com.indy.engine.command.impl.PauseScheduleCommand;
import com.indy.engine.command.impl.PurgeLogCronDefineCommand;
import com.indy.engine.command.impl.ReloadModules;
import com.indy.engine.command.impl.RemoveDeliveryCommand;
import com.indy.engine.command.impl.RemoveScheduleCommand;
import com.indy.engine.command.impl.RestartSessionCommand;
import com.indy.engine.command.impl.ResumeScheduleCommand;
import com.indy.engine.command.impl.RuntimeCommand;
import com.indy.engine.command.impl.ScheduleDeliveryCommand;
import com.indy.engine.command.impl.ScheduleDetailCommand;
import com.indy.engine.command.impl.StopSessionCommand;
import com.indy.engine.command.impl.WaitSessionCommand;
import com.indy.engine.common.command.parser.CommandI;
import com.indy.engine.common.command.parser.CommandInstanceI;
import com.indy.engine.common.command.parser.CommandLine;
import com.indy.engine.common.command.parser.CommandLineParser;
import com.indy.engine.common.command.parser.CommandLineParserI;
import com.indy.engine.common.command.parser.CommandParserExceptionI;
import com.indy.engine.common.command.parser.ICommandExecutorI;
import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.core.common.objects2.DeliveryExchange;
import com.indy.engine.core.common.objects2.EngineScheduleDetail;
import com.indy.engine.core.common.objects2.SessionDataExchange;
import com.indy.engine.rmi.SessionFilterCriteria;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InternalEngineCommandsI {
    private PrintStream out;
    CommandLineParserI commandParser = new CommandLineParserI();
    IEngineClient engineAPI = null;
    String hostConnected = "";
    String portConnected = "";
    private Map<String, Object> ctx;
    public final Logger logger = LogManager.getLogger((String)"com.indy.engine");
    public static final String MSG_SYNTAX_ERROR = Messages.getString("InternalEngineCommandsI.0");
    boolean disableExit = false;
    boolean disableConnect = false;
    private boolean disablePut;
    private CommandLineParser parser;
    String pHost;
    String pPort;

    public InternalEngineCommandsI(PrintStream out, IEngineClient engineAPI, boolean disableExit, boolean disableConnect, boolean disablePut, Map<String, Object> ctx) {
        this.out = out;
        this.engineAPI = engineAPI;
        this.disableConnect = disableConnect;
        this.disableExit = disableExit;
        this.disablePut = disablePut;
        this.ctx = ctx;
        this.defineCommands();
    }

    private void defineCommands() {
        this.parser = new CommandLineParser();
        this.parser.register(ExecuteDeliveryCommand.class.getAnnotation(CommandLine.class), ExecuteDeliveryCommand.class);
        this.parser.register(ScheduleDeliveryCommand.class.getAnnotation(CommandLine.class), ScheduleDeliveryCommand.class);
        this.parser.register(ListScheduleCommand.class.getAnnotation(CommandLine.class), ListScheduleCommand.class);
        this.parser.register(ScheduleDetailCommand.class.getAnnotation(CommandLine.class), ScheduleDetailCommand.class);
        this.parser.register(PauseScheduleCommand.class.getAnnotation(CommandLine.class), PauseScheduleCommand.class);
        this.parser.register(ResumeScheduleCommand.class.getAnnotation(CommandLine.class), ResumeScheduleCommand.class);
        this.parser.register(RemoveScheduleCommand.class.getAnnotation(CommandLine.class), RemoveScheduleCommand.class);
        this.parser.register(GetSchedules.class.getAnnotation(CommandLine.class), GetSchedules.class);
        this.parser.register(ListRemoteConnectionCommand.class.getAnnotation(CommandLine.class), ListRemoteConnectionCommand.class);
        this.parser.register(RemoveDeliveryCommand.class.getAnnotation(CommandLine.class), RemoveDeliveryCommand.class);
        this.parser.register(ListRepositoriesCommand.class.getAnnotation(CommandLine.class), ListRepositoriesCommand.class);
        this.parser.register(WaitSessionCommand.class.getAnnotation(CommandLine.class), WaitSessionCommand.class);
        this.parser.register(RestartSessionCommand.class.getAnnotation(CommandLine.class), RestartSessionCommand.class);
        this.parser.register(StopSessionCommand.class.getAnnotation(CommandLine.class), StopSessionCommand.class);
        this.parser.register(PurgeLogCronDefineCommand.class.getAnnotation(CommandLine.class), PurgeLogCronDefineCommand.class);
        this.parser.register(EncryptCommand.class.getAnnotation(CommandLine.class), EncryptCommand.class);
        this.parser.register(ReloadModules.class.getAnnotation(CommandLine.class), ReloadModules.class);
        this.parser.register(MarkInactiveSessionsAsDead.class.getAnnotation(CommandLine.class), MarkInactiveSessionsAsDead.class);
        if (!this.disableConnect) {
            this.comConnectDefine();
        }
        this.comEngineVersionDefine();
        this.comExecuteCommandFileDefine();
        if (!this.disableExit) {
            this.comExitDefine();
        }
        this.comGetLstDeliveriesDefine();
        this.comGetLstTriggersDefine();
        this.comGetTriggersDetailDefine();
        this.comGetDeliverySchedulesDefine();
        this.comGiveYourVersionDefine();
        this.comHelpDefine();
        this.comRemoveTriggerDefine();
        this.comSoapDefine();
        if (!this.disablePut) {
            this.comPutDelivery();
        }
        this.comSchedulePurgeLogCronDefine();
        this.operationService();
        this.getServices();
        this.comRuntime();
        this.comKillRuntime();
        this.getSessions();
        this.getDeliveries();
        this.getTriggers();
        this.pauseTrigger();
        this.resumeTrigger();
    }

    private void resumeTrigger() {
        try {
            CommandI command = new CommandI("resume trigger", "resume trigger <name>", "resume trigger <name>", new ICommandExecutorI(){

                public void execute(CommandInstanceI pr) throws Exception {
                    if (InternalEngineCommandsI.this.connectOrReconnect()) {
                        try {
                            HashMap<String, String> parameters = new HashMap<String, String>();
                            parameters.put("triggerName", pr.getParameterValue(0));
                            String group = pr.getParameterValue(1);
                            if (group == null) {
                                group = "Cron Expression";
                            }
                            parameters.put("triggerGroupName", group);
                            InternalEngineCommandsI.this.engineAPI.resumeTrigger(parameters);
                        }
                        catch (Exception e) {
                            InternalEngineCommandsI.this.out.println(e.getMessage());
                            throw e;
                        }
                    }
                }
            }, true, Messages.getString("InternalEngineCommandsI.1"));
            this.commandParser.AddCommand(command);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
            this.logger.warn("unexpected", (Throwable)e);
        }
    }

    private void pauseTrigger() {
        try {
            CommandI command = new CommandI("pause trigger", "pause trigger <name>", "pause trigger <name>", new ICommandExecutorI(){

                public void execute(CommandInstanceI pr) throws Exception {
                    if (InternalEngineCommandsI.this.connectOrReconnect()) {
                        try {
                            HashMap<String, String> parameters = new HashMap<String, String>();
                            parameters.put("triggerName", pr.getParameterValue(0));
                            String group = pr.getParameterValue(1);
                            if (group == null) {
                                group = "Cron Expression";
                            }
                            parameters.put("triggerGroupName", group);
                            InternalEngineCommandsI.this.engineAPI.pauseTrigger(parameters);
                        }
                        catch (Exception e) {
                            InternalEngineCommandsI.this.out.println(e.getMessage());
                            throw e;
                        }
                    }
                }
            }, true, Messages.getString("InternalEngineCommandsI.2"));
            this.commandParser.AddCommand(command);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
            this.logger.warn("unexpected", (Throwable)e);
        }
    }

    void comHelpDefine() {
        try {
            CommandI comHelp = new CommandI("help", "help [on <commandName>]", Messages.getString("InternalEngineCommandsI.3"), commandInstance -> {
                List lstCommands = this.commandParser.getLstCommands();
                String commandToHelp = commandInstance.getParameterValue(0);
                if (commandToHelp != null) {
                    Map map = this.parser.getHelp(commandToHelp);
                    if (map.size() > 0) {
                        this.out.println(((CommandLineParser.Help)map.get(commandToHelp)).getDescription());
                    } else {
                        this.out.println(this.commandParser.getCommandNamed(commandToHelp).getCommandDefinition());
                    }
                } else {
                    Map map = this.parser.getHelp(null);
                    ArrayList<Object> commandList = new ArrayList<Object>();
                    ArrayList<CommandLineParser.Help> deprecatedCommandList = new ArrayList<CommandLineParser.Help>();
                    commandList.addAll(map.values());
                    for (CommandI commandI : lstCommands) {
                        if (map.get(commandI.getCommandName()) != null) continue;
                        CommandLineParser.Help help = new CommandLineParser.Help();
                        help.setDescription(commandI.getCommandDefinition());
                        help.setUsage(commandI.getCommandModel());
                        help.setCommandName(commandI.getCommandName());
                        help.setDeprecated(commandI.isDeprecated());
                        if (commandI.isDeprecated()) {
                            help.setSeeCommand(commandI.getSeeCommand());
                            deprecatedCommandList.add(help);
                            continue;
                        }
                        commandList.add(help);
                    }
                    Collections.sort(commandList, (arg0, arg1) -> arg0.getCommandeName().compareTo(arg1.getCommandeName()));
                    Collections.sort(deprecatedCommandList, (arg0, arg1) -> arg0.getCommandeName().compareTo(arg1.getCommandeName()));
                    for (CommandLineParser.Help help : commandList) {
                        this.out.println(help.getUsage());
                        this.out.println("\t" + help.getDescription());
                    }
                    this.out.println();
                    this.out.println("--- Deprecated commands");
                    for (CommandLineParser.Help help : deprecatedCommandList) {
                        this.out.println(help.getUsage());
                        this.out.println("\t" + help.getDescription());
                        this.out.println("\t" + help.getSeeCommand());
                    }
                }
            });
            this.commandParser.AddCommand(comHelp);
        }
        catch (CommandParserExceptionI e) {
            this.logger.warn("unexpected", (Throwable)e);
        }
    }

    void comGiveYourVersionDefine() {
        try {
            CommandI yourVersion = new CommandI("versions", "versions", Messages.getString("InternalEngineCommandsI.4"), commandInstance -> {
                if (this.connectOrReconnect() && this.engineAPI != null) {
                    try {
                        Map map = this.engineAPI.getVersion();
                        this.out.println(Messages.getString("InternalEngineCommandsI.releaseVersion") + String.valueOf(map.get("branding.engine")));
                        this.out.println(Messages.getString("InternalEngineCommandsI.5") + String.valueOf(map.get("runtime")));
                        this.out.println(Messages.getString("InternalEngineCommandsI.6") + String.valueOf(map.get("scheduler")));
                        this.out.println(Messages.getString("InternalEngineCommandsI.7") + String.valueOf(map.get("command")));
                        this.out.println(Messages.getString("InternalEngineCommandsI.8") + String.valueOf(map.get("common")));
                        this.out.println(Messages.getString("InternalEngineCommandsI.9") + String.valueOf(map.get("action")));
                        this.out.println(Messages.getString("InternalEngineCommandsI.10") + String.valueOf(map.get("api")));
                    }
                    catch (Exception e) {
                        this.logger.error(Messages.getString("InternalEngineCommandsI.129"), (Throwable)e);
                        this.out.println(e.getMessage());
                    }
                }
            });
            this.commandParser.AddCommand(yourVersion);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
        }
        catch (Exception e) {
            this.logger.warn("unexpected", (Throwable)e);
        }
    }

    void comEngineVersionDefine() {
        try {
            CommandI comEngineVersion = new CommandI("runtime version", "runtime version", Messages.getString("InternalEngineCommandsI.11"), new ICommandExecutorI(){

                public void execute(CommandInstanceI pr) throws Exception {
                    if (InternalEngineCommandsI.this.connectOrReconnect()) {
                        Map m = InternalEngineCommandsI.this.engineAPI.getVersion();
                        InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.12") + String.valueOf(m.get("branding.engine")));
                    }
                }
            });
            this.commandParser.AddCommand(comEngineVersion);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
        }
    }

    void comExitDefine() {
        try {
            CommandI comExit = new CommandI("exit", "exit", Messages.getString("InternalEngineCommandsI.13"), new ICommandExecutorI(){

                public void execute(CommandInstanceI commandInstance) {
                }
            });
            this.commandParser.AddCommand(comExit);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
        }
    }

    void comRemoveTriggerDefine() {
        try {
            CommandI comRemoveTrigger = new CommandI("remove trigger", "remove trigger <triggerName>", Messages.getString("InternalEngineCommandsI.14"), new ICommandExecutorI(){

                public void execute(CommandInstanceI pr) throws Exception {
                    String triggerName = null;
                    if (InternalEngineCommandsI.this.connectOrReconnect()) {
                        try {
                            triggerName = pr.getParameterValue(0);
                            InternalEngineCommandsI.this.engineAPI.removeJobTrigger(triggerName);
                            InternalEngineCommandsI.this.out.println(triggerName + " removed");
                        }
                        catch (Exception e) {
                            InternalEngineCommandsI.this.out.println(e.getMessage());
                            throw e;
                        }
                    }
                }
            }, true, Messages.getString("InternalEngineCommandsI.15"));
            this.commandParser.AddCommand(comRemoveTrigger);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
        }
    }

    void comPutDelivery() {
        try {
            CommandI comPutDelivery = new CommandI("put delivery", "put delivery <deliveryName>", Messages.getString("InternalEngineCommandsI.16"), new ICommandExecutorI(){

                public void execute(CommandInstanceI pr) throws Exception {
                    String deliveryName = null;
                    if (InternalEngineCommandsI.this.connectOrReconnect()) {
                        try {
                            deliveryName = pr.getParameterValue(0);
                            HashMap<String, String> parameters = new HashMap<String, String>();
                            parameters.put("name", deliveryName);
                            InputStream in = Global.getRepository(null).getInputStream(deliveryName);
                            BufferedInputStream istream = new BufferedInputStream(in);
                            InternalEngineCommandsI.this.engineAPI.putDelivery((Object)istream, parameters);
                            InternalEngineCommandsI.this.out.println(deliveryName + Messages.getString("InternalEngineCommandsI.17"));
                            ((InputStream)istream).close();
                            in.close();
                        }
                        catch (Exception e) {
                            InternalEngineCommandsI.this.out.println(e.getMessage());
                            throw e;
                        }
                    }
                }
            });
            this.commandParser.AddCommand(comPutDelivery);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
        }
    }

    void comSoapDefine() {
        try {
            CommandI comStartWebServiceServer = new CommandI("soap server", "soap server [build|start|stop]", Messages.getString("InternalEngineCommandsI.18"), new ICommandExecutorI(){

                public void execute(CommandInstanceI pr) throws Exception {
                    if (InternalEngineCommandsI.this.connectOrReconnect()) {
                        String mode = pr.getParameterValue(0);
                        try {
                            HashMap<String, String> map = new HashMap<String, String>();
                            if (mode.equals("start")) {
                                map.put("action", "start");
                                InternalEngineCommandsI.this.engineAPI.soapServerAction(map);
                                InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.19"));
                            } else if (mode.equals("stop")) {
                                map.put("action", "stop");
                                InternalEngineCommandsI.this.engineAPI.soapServerAction(map);
                                InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.20"));
                            } else if (mode.equals("build")) {
                                map.put("action", "build");
                                InternalEngineCommandsI.this.engineAPI.soapServerAction(map);
                                InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.21"));
                            }
                        }
                        catch (Exception e) {
                            InternalEngineCommandsI.this.out.println(e.getMessage());
                            throw e;
                        }
                    }
                }
            });
            this.commandParser.AddCommand(comStartWebServiceServer);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
        }
    }

    void comGetLstDeliveriesDefine() {
        try {
            CommandI comGetLstDeliveries = new CommandI("get list deliveries", "get list deliveries [to <file>]", Messages.getString("InternalEngineCommandsI.22"), new ICommandExecutorI(){

                public void execute(CommandInstanceI pr) throws Exception {
                    if (InternalEngineCommandsI.this.connectOrReconnect()) {
                        try (FileOutputStream fos = null;){
                            List al = InternalEngineCommandsI.this.engineAPI.getLstDeliveries(null);
                            String fileName = null;
                            try {
                                fileName = pr.getParameterValue(0);
                                if (fileName != null) {
                                    fos = new FileOutputStream(fileName);
                                }
                            }
                            catch (Exception e) {
                                fileName = null;
                            }
                            if (al != null) {
                                Iterator it = al.iterator();
                                while (it.hasNext()) {
                                    if (fileName == null) {
                                        InternalEngineCommandsI.this.out.println((String)it.next());
                                        continue;
                                    }
                                    fos.write(((String)it.next() + System.getProperty("line.separator")).getBytes());
                                }
                                al.clear();
                                if (fileName != null) {
                                    InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.23") + fileName);
                                }
                            } else {
                                InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.24"));
                            }
                        }
                    }
                }
            });
            this.commandParser.AddCommand(comGetLstDeliveries);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
        }
    }

    void comGetLstTriggersDefine() {
        try {
            CommandI comGetLstTriggers = new CommandI("get list triggers", "get list triggers [to <file>]", Messages.getString("InternalEngineCommandsI.25"), new ICommandExecutorI(){

                public void execute(CommandInstanceI pr) throws Exception {
                    if (InternalEngineCommandsI.this.connectOrReconnect()) {
                        try (FileOutputStream fos = null;){
                            List al = InternalEngineCommandsI.this.engineAPI.getLstTriggers();
                            String fileName = null;
                            try {
                                fileName = pr.getParameterValue(0);
                                if (fileName != null) {
                                    fos = new FileOutputStream(fileName);
                                }
                            }
                            catch (Exception e) {
                                fileName = null;
                            }
                            if (!al.isEmpty()) {
                                Iterator it = al.iterator();
                                while (it.hasNext()) {
                                    if (fileName == null) {
                                        InternalEngineCommandsI.this.out.println((String)it.next());
                                        continue;
                                    }
                                    fos.write(((String)it.next() + System.getProperty("line.separator")).getBytes());
                                }
                                if (fileName != null) {
                                    InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.26") + fileName);
                                }
                            } else {
                                InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.27"));
                            }
                        }
                    }
                }
            }, true, Messages.getString("InternalEngineCommandsI.28"));
            this.commandParser.AddCommand(comGetLstTriggers);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
        }
    }

    void comGetTriggersDetailDefine() {
        try {
            CommandI comGetLstTriggers = new CommandI("get trigger detail", "get trigger detail <triggerName> [to <file>]", Messages.getString("InternalEngineCommandsI.29"), new ICommandExecutorI(){

                public void execute(CommandInstanceI pr) throws Exception {
                    if (InternalEngineCommandsI.this.connectOrReconnect()) {
                        String triggerName = pr.getParameterValue(0);
                        if (triggerName == null) {
                            InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.30"));
                        } else {
                            InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.31") + triggerName);
                            try (FileOutputStream fos = null;){
                                EngineScheduleDetail esd = new EngineScheduleDetail(InternalEngineCommandsI.this.engineAPI.getTriggerDetail(triggerName));
                                String fileName = null;
                                try {
                                    fileName = pr.getParameterValue(1);
                                    if (fileName != null) {
                                        fos = new FileOutputStream(fileName);
                                    }
                                }
                                catch (Exception e) {
                                    fileName = null;
                                }
                                if (fileName == null) {
                                    InternalEngineCommandsI.this.out.println(esd.toString());
                                } else {
                                    fos.write((esd.toString() + System.getProperty("line.separator")).getBytes());
                                }
                                if (fileName != null) {
                                    InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.32") + fileName);
                                }
                            }
                        }
                    }
                }
            }, true, Messages.getString("InternalEngineCommandsI.34"));
            this.commandParser.AddCommand(comGetLstTriggers);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
        }
    }

    void comGetDeliverySchedulesDefine() {
        try {
            CommandI comGetLstTriggers = new CommandI("get delivery schedules", "get delivery schedules <deliveryName> [to <file>]", Messages.getString("InternalEngineCommandsI.35"), new ICommandExecutorI(){

                public void execute(CommandInstanceI pr) throws Exception {
                    if (InternalEngineCommandsI.this.connectOrReconnect()) {
                        String deliveryName = pr.getParameterValue(0);
                        if (deliveryName == null) {
                            InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.36"));
                        } else {
                            InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.37") + deliveryName);
                            try (FileOutputStream fos = null;){
                                List lst = InternalEngineCommandsI.this.engineAPI.getLstSchedules(deliveryName);
                                String fileName = null;
                                try {
                                    fileName = pr.getParameterValue(1);
                                    if (fileName != null) {
                                        fos = new FileOutputStream(fileName);
                                    }
                                }
                                catch (Exception e) {
                                    fileName = null;
                                }
                                if (lst != null) {
                                    int i = 0;
                                    while (i < lst.size()) {
                                        EngineScheduleDetail esd = new EngineScheduleDetail((Map)lst.get(i));
                                        if (fileName == null) {
                                            InternalEngineCommandsI.this.out.println(esd.toString());
                                        } else {
                                            fos.write((esd.toString() + System.getProperty("line.separator")).getBytes());
                                        }
                                        ++i;
                                    }
                                    if (fileName != null) {
                                        InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.38") + fileName);
                                    }
                                } else {
                                    InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.39"));
                                }
                            }
                        }
                    }
                }
            });
            this.commandParser.AddCommand(comGetLstTriggers);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
        }
    }

    void operationService() {
        try {
            CommandI command = new CommandI("<start|stop|restart> <name> service", "<start|stop|restart> <name> service ", Messages.getString("InternalEngineCommandsI.43"), new ICommandExecutorI(){

                public void execute(CommandInstanceI pr) throws Exception {
                    if (InternalEngineCommandsI.this.connectOrReconnect()) {
                        String name = pr.getParameterValue(1);
                        String action = pr.getParameterValue(0);
                        try {
                            InternalEngineCommandsI.this.engineAPI.manageService(action, name);
                            InternalEngineCommandsI.this.out.println(String.format(Messages.getString("InternalEngineCommandsI.manageService"), name, action));
                        }
                        catch (Exception e) {
                            InternalEngineCommandsI.this.out.println(e.getMessage());
                            throw e;
                        }
                    }
                }
            });
            this.commandParser.AddCommand(command);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
            this.logger.warn("unexpected", (Throwable)e);
        }
    }

    void getDeliveries() {
        try {
            CommandI command = new CommandI("get deliveries [id <id1,id2,idn>]", "get deliveries [id <id1,id2,idn>] [format <format>] [repository <name>]", "get deliveries [id <id1,id2,idn>]", new ICommandExecutorI(){

                public void execute(CommandInstanceI pr) throws Exception {
                    if (InternalEngineCommandsI.this.connectOrReconnect()) {
                        try {
                            String repository;
                            String _ids = pr.getParameterValue(0);
                            HashMap<String, Object> ques = new HashMap<String, Object>();
                            if (_ids != null) {
                                ArrayList<String> ids = new ArrayList<String>();
                                String[] stringArray = _ids.split(",");
                                int n = stringArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String id = stringArray[n2];
                                    if (id != null && !id.isEmpty()) {
                                        ids.add(id.trim());
                                    }
                                    ++n2;
                                }
                                ques.put("ids", ids);
                            }
                            if ((repository = pr.getParameterValue(2)) != null) {
                                ques.put("dir", repository);
                            }
                            Map map = InternalEngineCommandsI.this.engineAPI.getDeliveries(ques);
                            HashMap<String, Column> columns = new HashMap<String, Column>();
                            int position = 0;
                            columns.put("name", new Column(position++, Messages.getString("InternalEngineCommandsI.60"), 0));
                            columns.put("builduser", new Column(position++, Messages.getString("InternalEngineCommandsI.61"), 0));
                            columns.put("configuration", new Column(position++, Messages.getString("InternalEngineCommandsI.62"), 0));
                            columns.put("description", new Column(position++, Messages.getString("InternalEngineCommandsI.63"), 0));
                            columns.put("id", new Column(position++, Messages.getString("InternalEngineCommandsI.64"), 0));
                            columns.put("packageid", new Column(position++, Messages.getString("InternalEngineCommandsI.65"), 0));
                            columns.put("processid", new Column(position++, Messages.getString("InternalEngineCommandsI.66"), 0));
                            columns.put("username", new Column(position++, Messages.getString("InternalEngineCommandsI.67"), 0));
                            columns.put("version", new Column(position++, Messages.getString("InternalEngineCommandsI.68"), 0));
                            columns.put("builddate", new Column(position++, Messages.getString("InternalEngineCommandsI.69"), 0));
                            columns.put("exportdate", new Column(position++, Messages.getString("InternalEngineCommandsI.70"), 0));
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
                            for (Map deliv : map.values()) {
                                DeliveryExchange de = new DeliveryExchange(deliv);
                                ((Column)columns.get((Object)"name")).datas.add(de.getName());
                                ((Column)columns.get((Object)"builduser")).datas.add(de.getBuildUser());
                                ((Column)columns.get((Object)"configuration")).datas.add(de.getConfiguration());
                                ((Column)columns.get((Object)"description")).datas.add(de.getDescription());
                                ((Column)columns.get((Object)"id")).datas.add(de.getId());
                                ((Column)columns.get((Object)"packageid")).datas.add(de.getPackageId());
                                ((Column)columns.get((Object)"processid")).datas.add(de.getProcId());
                                ((Column)columns.get((Object)"username")).datas.add(de.getUserName());
                                ((Column)columns.get((Object)"version")).datas.add(de.getVersion());
                                if (de.getBuildDate() != null) {
                                    ((Column)columns.get((Object)"builddate")).datas.add(sdf.format(de.getBuildDate()));
                                }
                                if (de.getExportDate() == null) continue;
                                ((Column)columns.get((Object)"exportdate")).datas.add(sdf.format(de.getExportDate()));
                            }
                            String format = pr.getParameterValue(1);
                            InternalEngineCommandsI.this.out.println(InternalEngineCommandsI.formatList2(columns, format));
                        }
                        catch (Exception e) {
                            InternalEngineCommandsI.this.logger.error(Messages.getString("InternalEngineCommandsI.129"), (Throwable)e);
                            InternalEngineCommandsI.this.out.println(e.getMessage());
                            throw e;
                        }
                    }
                }
            });
            this.commandParser.AddCommand(command);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
            this.logger.warn("unexpected", (Throwable)e);
        }
    }

    void getTriggers() {
        try {
            CommandI command = new CommandI("get triggers [name <name1,name2,namen>] [format <format>]", "get triggers [name <name1,name2,namen>] [format <format>]", "get triggers [name <name1,name2,namen>] [format <format>]", new ICommandExecutorI(){

                public void execute(CommandInstanceI pr) throws Exception {
                    if (InternalEngineCommandsI.this.connectOrReconnect()) {
                        String _ids = pr.getParameterValue(0);
                        ArrayList<String> names = null;
                        if (_ids != null) {
                            names = new ArrayList<String>();
                            String[] stringArray = _ids.split(",");
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String id = stringArray[n2];
                                if (id != null && !id.isEmpty()) {
                                    names.add(id.trim());
                                }
                                ++n2;
                            }
                        }
                        HashMap<String, Column> columns = new HashMap<String, Column>();
                        int position = 0;
                        columns.put("name", new Column(position++, Messages.getString("InternalEngineCommandsI.71"), 0));
                        columns.put("deliveryname", new Column(position++, Messages.getString("InternalEngineCommandsI.72"), 0));
                        columns.put("cronexpression", new Column(position++, Messages.getString("InternalEngineCommandsI.73"), 0));
                        columns.put("executiontype", new Column(position++, Messages.getString("InternalEngineCommandsI.75"), 0));
                        columns.put("starttime", new Column(position++, Messages.getString("InternalEngineCommandsI.76"), 0));
                        columns.put("endtime", new Column(position++, Messages.getString("InternalEngineCommandsI.77"), 0));
                        columns.put("nextexecution", new Column(position++, Messages.getString("InternalEngineCommandsI.78"), 0));
                        columns.put("purgesize", new Column(position++, Messages.getString("InternalEngineCommandsI.79"), 0));
                        columns.put("purgeunit", new Column(position++, Messages.getString("InternalEngineCommandsI.80"), 0));
                        columns.put("jobname", new Column(position++, Messages.getString("InternalEngineCommandsI.81"), 0));
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
                        for (String triggerName : InternalEngineCommandsI.this.engineAPI.getLstTriggers()) {
                            if (names != null && !names.contains(triggerName)) continue;
                            EngineScheduleDetail detail = new EngineScheduleDetail(InternalEngineCommandsI.this.engineAPI.getTriggerDetail(triggerName));
                            ((Column)columns.get((Object)"jobname")).datas.add(detail.getJobName());
                            ((Column)columns.get((Object)"name")).datas.add(detail.getTriggerName());
                            ((Column)columns.get((Object)"deliveryname")).datas.add(detail.getDeliveryName());
                            ((Column)columns.get((Object)"cronexpression")).datas.add(detail.getCronExpression());
                            ((Column)columns.get((Object)"executiontype")).datas.add(String.valueOf(detail.getExecutionType()));
                            if (detail.getStartTime() != null) {
                                ((Column)columns.get((Object)"starttime")).datas.add(sdf.format(detail.getStartTime()));
                            } else {
                                ((Column)columns.get((Object)"starttime")).datas.add("");
                            }
                            if (detail.getEndTime() != null) {
                                ((Column)columns.get((Object)"endtime")).datas.add(sdf.format(detail.getEndTime()));
                            } else {
                                ((Column)columns.get((Object)"endtime")).datas.add("");
                            }
                            if (detail.getNextExecution() != null) {
                                ((Column)columns.get((Object)"nextexecution")).datas.add(sdf.format(detail.getNextExecution()));
                            } else {
                                ((Column)columns.get((Object)"nextexecution")).datas.add("");
                            }
                            ((Column)columns.get((Object)"purgesize")).datas.add(detail.getPurgeSize());
                            ((Column)columns.get((Object)"purgeunit")).datas.add(detail.getPurgeUnit());
                        }
                        String format = pr.getParameterValue(1);
                        InternalEngineCommandsI.this.out.println(InternalEngineCommandsI.formatList2(columns, format));
                    }
                }
            }, true, "get schedule detail");
            this.commandParser.AddCommand(command);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
            this.logger.warn("unexpected error", (Throwable)e);
        }
    }

    void getServices() {
        try {
            CommandI command = new CommandI("get services ", "get services [name <name>] [format <format>]", "get services [name <name>] [format <format>]", new ICommandExecutorI(){

                public void execute(CommandInstanceI pr) throws Exception {
                    if (InternalEngineCommandsI.this.connectOrReconnect()) {
                        try {
                            String name = pr.getParameterValue(0);
                            HashMap<String, Column> columns = new HashMap<String, Column>();
                            int position = 0;
                            columns.put("name", new Column(position++, Messages.getString("InternalEngineCommandsI.82"), 0));
                            columns.put("status", new Column(position++, Messages.getString("InternalEngineCommandsI.83"), 0));
                            columns.put("duration", new Column(position, Messages.getString("InternalEngineCommandsI.84"), 0));
                            InternalEngineCommandsI.this.engineAPI.getServicesInformations(name).forEach(i -> {
                                boolean ok;
                                boolean bl = ok = name == null;
                                if (name != null && i[0].equals(name)) {
                                    ok = true;
                                }
                                if (ok) {
                                    ((Column)map.get((Object)"name")).datas.add(i[0]);
                                    ((Column)map.get((Object)"status")).datas.add(i[1]);
                                    ((Column)map.get((Object)"duration")).datas.add(i[2]);
                                }
                            });
                            String format = pr.getParameterValue(1);
                            InternalEngineCommandsI.this.out.println(InternalEngineCommandsI.formatList2(columns, format));
                        }
                        catch (Exception ex) {
                            InternalEngineCommandsI.this.logger.error("Failed to list services state", (Throwable)ex);
                            throw ex;
                        }
                    }
                }
            });
            this.commandParser.AddCommand(command);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
            this.logger.warn("unexpected", (Throwable)e);
        }
    }

    void comRuntime() {
        try {
            CommandI command = new CommandI("stop runtime [wait sessions] ", "stop runtime [wait sessions] ", "stop runtime [wait sessions] ", new ICommandExecutorI(){

                public void execute(CommandInstanceI pr) throws Exception {
                    if (InternalEngineCommandsI.this.connectOrReconnect()) {
                        int mode = 1;
                        String _mode = pr.getParameterValue(0);
                        if (_mode != null) {
                            mode = 2;
                        }
                        try {
                            InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.85"));
                            HashMap<String, Integer> parameters = new HashMap<String, Integer>();
                            parameters.put("type", 0);
                            parameters.put("mode", mode);
                            InternalEngineCommandsI.this.engineAPI.stopEngine(parameters);
                        }
                        catch (Exception e) {
                            if (e.getMessage() != null) {
                                InternalEngineCommandsI.this.out.println(e.getMessage());
                            } else if (e.getCause() != null) {
                                InternalEngineCommandsI.this.out.println(e.getCause().getMessage());
                            }
                            InternalEngineCommandsI.this.logger.error(Messages.getString("InternalEngineCommandsI.129"), (Throwable)e);
                            throw e;
                        }
                    }
                }
            });
            this.commandParser.AddCommand(command);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
            this.logger.warn("unexpected", (Throwable)e);
        }
    }

    void comKillRuntime() {
        try {
            CommandI command = new CommandI("kill runtime", "kill runtime", Messages.getString("InternalEngineCommandsI.87"), new ICommandExecutorI(){

                public void execute(CommandInstanceI pr) throws Exception {
                    if (InternalEngineCommandsI.this.connectOrReconnect()) {
                        try {
                            InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.86"));
                            HashMap<String, Integer> parameters = new HashMap<String, Integer>();
                            parameters.put("type", 0);
                            parameters.put("mode", 0);
                            InternalEngineCommandsI.this.engineAPI.stopEngine(parameters);
                        }
                        catch (Exception e) {
                            if (e.getMessage() != null) {
                                InternalEngineCommandsI.this.out.println(e.getMessage());
                            } else if (e.getCause() != null) {
                                InternalEngineCommandsI.this.out.println(e.getCause().getMessage());
                            }
                            InternalEngineCommandsI.this.logger.error(Messages.getString("InternalEngineCommandsI.129"), (Throwable)e);
                            throw e;
                        }
                    }
                }
            });
            this.commandParser.AddCommand(command);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
            this.logger.warn("unexpected", (Throwable)e);
        }
    }

    public static String formatList2(Map<String, Column> cols, String format) {
        if (format == null) {
            ArrayList<Column> list = new ArrayList<Column>(cols.values());
            Collections.sort(list);
            return InternalEngineCommandsI.formatList(list);
        }
        Object ret = "";
        if (cols.size() > 0) {
            int dataSize;
            ArrayList<Column> list = new ArrayList<Column>(cols.values());
            boolean pad = format.contains("#");
            if (pad) {
                InternalEngineCommandsI.determineColSize(list, false);
            }
            if ((dataSize = ((Column)list.get((int)0)).datas.size()) > 0) {
                int i = dataSize - 1;
                while (i >= 0) {
                    String tmp = format.replace("%%", "\u00a4\u00b5\u00b2");
                    tmp = tmp.replace("$$", "\u00b2\u00b5\u00a4");
                    for (String key : cols.keySet()) {
                        Column col = cols.get(key);
                        String str = col.datas.get(i);
                        if (str == null) {
                            str = "";
                        }
                        int _type = col.type;
                        if (pad) {
                            tmp = _type == 0 ? tmp.replace("%" + key + "#", ActionCodeTypeI.rpad((String)str, (int)col.maxSize, (String)" ")) : tmp.replace("%" + key + "#", ActionCodeTypeI.lpad((String)str, (int)col.maxSize, (String)" "));
                        }
                        tmp = tmp.replace("%" + key, str);
                    }
                    tmp = tmp.replace("\u00a4\u00b5\u00b2", "%");
                    tmp = tmp.replace("\u00b2\u00b5\u00a4", "$");
                    tmp = tmp.replace("\\n", "\n");
                    tmp = tmp.replace("\\t", "\t");
                    ret = (String)ret + tmp + "\n";
                    --i;
                }
            }
        }
        ret = (String)ret + "\n";
        return ret;
    }

    private static void determineColSize(List<Column> cols, boolean useHeaderSize) {
        if (cols.size() > 0) {
            int col = 0;
            while (col < cols.size()) {
                Column column = cols.get(col);
                column.maxSize = useHeaderSize ? column.header.length() : 0;
                if (column.datas.size() > 0) {
                    int row = 0;
                    while (row < column.datas.size()) {
                        String _data = column.datas.get(row);
                        if (_data != null && _data.length() > column.maxSize) {
                            column.maxSize = _data.length();
                        }
                        ++row;
                    }
                }
                ++col;
            }
        }
    }

    private static String formatList(List<Column> cols) {
        Collections.sort(cols);
        Object ret = "";
        if (cols.size() > 0) {
            InternalEngineCommandsI.determineColSize(cols, true);
            int i = 0;
            while (i < cols.size()) {
                ret = (String)ret + ActionCodeTypeI.rpad((String)cols.get((int)i).header, (int)cols.get((int)i).maxSize, (String)" ") + " ";
                ++i;
            }
            ret = (String)ret + "\n";
            int dataSize = cols.get((int)0).datas.size();
            if (dataSize > 0) {
                int i2 = dataSize - 1;
                while (i2 >= 0) {
                    int j = 0;
                    while (j < cols.size()) {
                        Column col = cols.get(j);
                        String str = "";
                        if (col.datas.size() > i2) {
                            str = col.datas.get(i2);
                        } else {
                            System.out.print("");
                        }
                        str = str == null ? "" : str;
                        int _type = col.type;
                        ret = _type == 0 ? (String)ret + ActionCodeTypeI.rpad((String)str, (int)col.maxSize, (String)" ") + " " : (String)ret + ActionCodeTypeI.lpad((String)str, (int)col.maxSize, (String)" ") + " ";
                        ++j;
                    }
                    ret = (String)ret + "\n";
                    --i2;
                }
            }
        }
        ret = (String)ret + "\n";
        return ret;
    }

    public static Map<String, Column> createSessionsColumns(boolean error) {
        HashMap<String, Column> columns = new HashMap<String, Column>();
        int position = 0;
        columns.put("name", new Column(position++, Messages.getString("InternalEngineCommandsI.88"), 0));
        columns.put("status", new Column(position++, Messages.getString("InternalEngineCommandsI.89"), 0));
        columns.put("begindate", new Column(position++, Messages.getString("InternalEngineCommandsI.90"), 0));
        columns.put("enddate", new Column(position++, Messages.getString("InternalEngineCommandsI.91"), 0));
        columns.put("configuration", new Column(position++, Messages.getString("InternalEngineCommandsI.92"), 0));
        columns.put("id", new Column(position++, Messages.getString("InternalEngineCommandsI.93"), 0));
        columns.put("deliveryid", new Column(position++, Messages.getString("InternalEngineCommandsI.94"), 0));
        columns.put("runtimehost", new Column(position++, Messages.getString("InternalEngineCommandsI.95"), 0));
        columns.put("runtimeport", new Column(position++, Messages.getString("InternalEngineCommandsI.96"), 1));
        columns.put("executionmode", new Column(position++, Messages.getString("InternalEngineCommandsI.97"), 0));
        columns.put("guesthost", new Column(position++, Messages.getString("InternalEngineCommandsI.98"), 0));
        columns.put("iter", new Column(position++, Messages.getString("InternalEngineCommandsI.99"), 1));
        columns.put("launchmode", new Column(position++, Messages.getString("InternalEngineCommandsI.100"), 0));
        columns.put("parentid", new Column(position++, Messages.getString("InternalEngineCommandsI.101"), 0));
        columns.put("parsentiter", new Column(position++, Messages.getString("InternalEngineCommandsI.102"), 0));
        columns.put("parentiter", new Column(position++, Messages.getString("InternalEngineCommandsI.103"), 0));
        columns.put("logversion", new Column(position++, Messages.getString("InternalEngineCommandsI.104"), 0));
        columns.put("returncode", new Column(position++, Messages.getString("InternalEngineCommandsI.105"), 1));
        columns.put("returnCode", new Column(position, Messages.getString("InternalEngineCommandsI.105"), 1));
        if (error) {
            columns.put("errormessage", new Column(columns.keySet().size(), Messages.getString("InternalEngineCommandsI.106"), 0));
            columns.put("exception", new Column(columns.keySet().size(), Messages.getString("InternalEngineCommandsI.107"), 0));
        }
        return columns;
    }

    public static void fillSessionsColumns(Map<String, Column> columns, Map<String, Object> session, SimpleDateFormat sdf, IEngineClient engineAPI2) {
        SessionDataExchange sde = new SessionDataExchange(session);
        boolean i = false;
        columns.get((Object)"name").datas.add(sde.getName());
        columns.get((Object)"status").datas.add(InternalEngineCommandsI.getStringEngineStatus(sde.getStatus()));
        columns.get((Object)"returncode").datas.add(String.valueOf(sde.getStatus()));
        columns.get((Object)"returnCode").datas.add(String.valueOf(sde.getStatus()));
        if (sde.getBeginDate() != null) {
            columns.get((Object)"begindate").datas.add(sdf.format(sde.getBeginDate()));
        } else {
            columns.get((Object)"begindate").datas.add("");
        }
        if (sde.getEndDate() != null) {
            columns.get((Object)"enddate").datas.add(sdf.format(sde.getEndDate()));
        } else {
            columns.get((Object)"enddate").datas.add("");
        }
        columns.get((Object)"configuration").datas.add(sde.getConfiguration());
        columns.get((Object)"id").datas.add(sde.getId());
        columns.get((Object)"deliveryid").datas.add(sde.getDeliveryId());
        columns.get((Object)"runtimehost").datas.add(sde.getEngineHost());
        columns.get((Object)"runtimeport").datas.add(String.valueOf(sde.getEnginePort()));
        columns.get((Object)"executionmode").datas.add(sde.getExecutionMode());
        columns.get((Object)"guesthost").datas.add(sde.getGuestHost());
        columns.get((Object)"iter").datas.add(String.valueOf(sde.getIter()));
        columns.get((Object)"launchmode").datas.add(sde.getLaunchMode());
        columns.get((Object)"parentid").datas.add(sde.getParentSessionId());
        columns.get((Object)"parsentiter").datas.add(String.valueOf(sde.getParentSessionIter()));
        columns.get((Object)"parentiter").datas.add(String.valueOf(sde.getParentSessionIter()));
        columns.get((Object)"logversion").datas.add(sde.getVersion());
        if (columns.get("errormessage") != null || columns.get("exception") != null) {
            boolean ok = false;
            try {
                try {
                    Map ret;
                    if (engineAPI2 != null && (ret = engineAPI2.getLstRootSessionVariables(sde.getId())) != null) {
                        Map actionInfo;
                        String actionId;
                        Map map = (Map)ret.get("CORE_SESSION_FAILURE_CAUSE_ACTION_ID");
                        if (map == null) {
                            map = (Map)ret.get("CORE_SESSION_FAILURE_CAUSE_ACTION_ID ");
                        }
                        if (map != null && (actionId = (String)map.get("value")) != null && (actionInfo = engineAPI2.getActionExtInfo(sde.getId(), actionId)) != null) {
                            String actionName = (String)actionInfo.get("name");
                            Map sessionErrors = engineAPI2.getLstSessionErrors(sde.getId());
                            for (Map.Entry ret4 : sessionErrors.entrySet()) {
                                String exception = "";
                                Map stackTraceVariable = engineAPI2.getActionVariable(sde.getId(), (String)ret4.getKey(), VariableType.CORE_STACK_TRACE.getName());
                                for (String key : stackTraceVariable.keySet()) {
                                    if (!"source".equals(key)) continue;
                                    exception = (String)stackTraceVariable.get(key);
                                    break;
                                }
                                String varname = (String)((Map)ret4.getValue()).get("name");
                                String actionVarName = varname.substring(0, varname.lastIndexOf("/"));
                                if (!actionName.equals(actionVarName)) continue;
                                columns.get((Object)"errormessage").datas.add((String)((Map)ret4.getValue()).get("value"));
                                columns.get((Object)"exception").datas.add(exception);
                                ok = true;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    if (!ok) {
                        columns.get((Object)"errormessage").datas.add("");
                        columns.get((Object)"exception").datas.add("");
                    }
                }
            }
            finally {
                if (!ok) {
                    columns.get((Object)"errormessage").datas.add("");
                    columns.get((Object)"exception").datas.add("");
                }
            }
        }
    }

    void getSessions() {
        try {
            CommandI command = new CommandI("get sessions [name <name>] [id <id1,id2,idn>] [status <running,error,done,stopped>] [duration <min>] [to <max>] [limit <limit>] [format <format>] [configuration <configuration>]", "get sessions [name <name>] [id <id1,id2,idn>] [status <running,error,done,stopped>] [duration <min>] [to <max>] [limit <limit>] [format <format>] [configuration <configuration>]", Messages.getString("InternalEngineCommandsI.108"), new ICommandExecutorI(){

                public void execute(CommandInstanceI pr) throws Exception {
                    if (InternalEngineCommandsI.this.connectOrReconnect()) {
                        int n;
                        int n2;
                        Object object;
                        SessionFilterCriteria sfc = new SessionFilterCriteria();
                        int index = 0;
                        sfc.setSessName(pr.getParameterValue(index++));
                        String _ids = pr.getParameterValue(index++);
                        String _status = pr.getParameterValue(index++);
                        String minduration = pr.getParameterValue(index++);
                        String maxduration = pr.getParameterValue(index++);
                        String limit = pr.getParameterValue(index++);
                        String format = pr.getParameterValue(index++);
                        sfc.setSessConfigName(pr.getParameterValue(index++));
                        if (_ids != null) {
                            ArrayList<String> ids = new ArrayList<String>();
                            object = _ids.split(",");
                            n2 = ((String[])object).length;
                            n = 0;
                            while (n < n2) {
                                String id = object[n];
                                if (id != null && !id.isEmpty()) {
                                    ids.add(id.trim());
                                }
                                ++n;
                            }
                            sfc.setLstSession(ids);
                        }
                        if (_status != null) {
                            ArrayList<Integer> status = new ArrayList<Integer>();
                            object = _status.split(",");
                            n2 = ((String[])object).length;
                            n = 0;
                            while (n < n2) {
                                String state = object[n];
                                if (state != null && !state.isEmpty()) {
                                    if (state.toLowerCase().equals("running")) {
                                        status.add(2);
                                    } else if (state.toLowerCase().equals("error")) {
                                        status.add(-1);
                                    } else if (state.toLowerCase().equals("stopped")) {
                                        status.add(-2);
                                    } else if (state.toLowerCase().equals("done") || state.toLowerCase().equals("executed")) {
                                        status.add(1);
                                    } else {
                                        InternalEngineCommandsI.this.out.println("status: " + state + " not supported");
                                        return;
                                    }
                                }
                                ++n;
                            }
                            sfc.setLstStatus(status);
                        }
                        sfc.setCurrentEngine(true);
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
                        if (minduration != null) {
                            try {
                                sfc.setMinDuration(Long.valueOf(minduration));
                            }
                            catch (NumberFormatException e) {
                                InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.109") + minduration + Messages.getString("InternalEngineCommandsI.110"));
                                throw e;
                            }
                        }
                        if (maxduration != null) {
                            try {
                                sfc.setMaxDuration(Long.valueOf(maxduration));
                            }
                            catch (NumberFormatException e) {
                                InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.111") + minduration + Messages.getString("InternalEngineCommandsI.112"));
                                throw e;
                            }
                        }
                        if (limit != null) {
                            if (Integer.valueOf(limit) > 1000) {
                                InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.113"));
                                throw new Exception(Messages.getString("InternalEngineCommandsI.114"));
                            }
                            sfc.setNbSessions(Integer.valueOf(limit));
                        } else {
                            sfc.setNbSessions(20);
                        }
                        try {
                            Map ret = InternalEngineCommandsI.this.engineAPI.getLstSession(sfc.toMap());
                            Map<String, Column> columns = InternalEngineCommandsI.createSessionsColumns(format != null && (format.contains("errormessage") || format.contains("exception")));
                            for (Map session : ret.values()) {
                                InternalEngineCommandsI.fillSessionsColumns(columns, session, sdf, InternalEngineCommandsI.this.engineAPI);
                            }
                            InternalEngineCommandsI.this.out.println(InternalEngineCommandsI.formatList2(columns, format));
                        }
                        catch (Exception e) {
                            InternalEngineCommandsI.this.out.println(e.getMessage());
                            throw e;
                        }
                    }
                }
            });
            this.commandParser.AddCommand(command);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
            this.logger.warn("unexpected", (Throwable)e);
        }
    }

    public static String getStringEngineStatus(int intStatus) {
        String result = "";
        switch (intStatus) {
            case 2: {
                result = "RUNNING";
                break;
            }
            case 1: {
                result = "EXECUTED";
                break;
            }
            case -2: {
                result = "STOPPED";
                break;
            }
            case 0: {
                result = "NEVER_EXECUTED";
                break;
            }
            case 6: {
                result = "PAUSED";
                break;
            }
            case -1: {
                result = "ERROR";
                break;
            }
            case 9: {
                result = "PREPARING";
                break;
            }
            case 10: {
                result = "PREPARED";
                break;
            }
            case -4: {
                result = "DEAD";
                break;
            }
            default: {
                result = "OTHER";
            }
        }
        return result;
    }

    void comSchedulePurgeLogCronDefine() {
        try {
            CommandI command = new CommandI("schedule purge", "schedule purge keep <number> <minute|hour|day|session>  cron <cronExpression> [sessionname <name,name2,...>] [status <done,error,killed,dead>] [on host <hostname>] [port <hostport>] [currentRuntime]", Messages.getString("InternalEngineCommandsI.115"), new ICommandExecutorI(){

                public void execute(CommandInstanceI pr) throws Exception {
                    if (InternalEngineCommandsI.this.connectOrReconnect()) {
                        try {
                            String currentRuntime;
                            String status;
                            String hostName;
                            String _hostPort;
                            HashMap<String, Object> rules = new HashMap<String, Object>();
                            String jobName = null;
                            String size = pr.getParameterValue(0);
                            rules.put("size", size);
                            String unit = pr.getParameterValue(1);
                            unit = unit == null ? "day" : unit;
                            rules.put("unit", unit);
                            String cronExpression = pr.getParameterValue(2);
                            String sessionName = pr.getParameterValue(3);
                            if (sessionName != null) {
                                String[] tabSessionName = sessionName.split(",");
                                HashMap mapSessionName = new HashMap();
                                int i = 0;
                                String[] stringArray = tabSessionName;
                                int n = tabSessionName.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String session = stringArray[n2];
                                    HashMap<String, String> mapDetail = new HashMap<String, String>();
                                    mapDetail.put("filter", session);
                                    mapSessionName.put(String.valueOf(i), mapDetail);
                                    ++i;
                                    ++n2;
                                }
                                rules.put("purgeSessionName", mapSessionName);
                            }
                            if ((_hostPort = pr.getParameterValue(6)) != null) {
                                rules.put("port", Integer.parseInt(_hostPort));
                            }
                            if ((hostName = pr.getParameterValue(5)) != null) {
                                rules.put("host", InternalEngineCommandsI.this.pHost);
                            }
                            if ((status = pr.getParameterValue(4)) != null) {
                                ArrayList<Integer> list = new ArrayList<Integer>();
                                if (status.toLowerCase().contains("done")) {
                                    list.add(1);
                                }
                                if (status.toLowerCase().contains("error")) {
                                    list.add(-1);
                                }
                                if (status.toLowerCase().contains("killed")) {
                                    list.add(-2);
                                }
                                if (status.toLowerCase().contains("dead")) {
                                    list.add(-4);
                                }
                                rules.put("purgeStatusList", list);
                            }
                            if ((currentRuntime = pr.getParameterValue(7)) != null) {
                                rules.put("currentRuntime", currentRuntime);
                            }
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                            ArrayList<Map> lst = new ArrayList<Map>();
                            EngineScheduleDetail esd = new EngineScheduleDetail(1);
                            esd.setCronExpression(cronExpression);
                            esd.setJobName(jobName);
                            lst.add(esd.toMap());
                            boolean ret = false;
                            InternalEngineCommandsI.this.engineAPI.schedulePurgeLog(jobName, lst, rules);
                        }
                        catch (Exception e) {
                            InternalEngineCommandsI.this.out.println(e.getMessage());
                            throw e;
                        }
                    }
                }
            });
            this.commandParser.AddCommand(command);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
            this.logger.warn("unexpected", (Throwable)e);
        }
    }

    Map preparePurgeMap(CommandInstanceI pr, boolean schedule) throws Exception {
        int n;
        HashMap<String, Object> rules = new HashMap<String, Object>();
        int k = 0;
        String size = pr.getParameterValue(k++);
        String unit = pr.getParameterValue(k++);
        String cronExpression = schedule ? pr.getParameterValue(k++) : null;
        String sessionName = pr.getParameterValue(k++);
        String status = pr.getParameterValue(k++);
        String currentRuntime = pr.getParameterValue(k++);
        Object jobName = null;
        rules.put("size", size);
        rules.put("host", this.pHost);
        rules.put("port", this.pPort);
        unit = unit == null ? "day" : unit;
        rules.put("unit", unit);
        HashMap mapSessionName = new HashMap();
        if (sessionName != null) {
            String[] tabSessionName = sessionName.split(",");
            int i = 0;
            String[] stringArray = tabSessionName;
            int n2 = tabSessionName.length;
            n = 0;
            while (n < n2) {
                String session = stringArray[n];
                HashMap<String, String> mapDetail = new HashMap<String, String>();
                mapDetail.put("filter", session);
                mapSessionName.put(String.valueOf(i), mapDetail);
                ++i;
                ++n;
            }
            rules.put("purgeSessionName", mapSessionName);
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (status != null) {
            String[] stringArray = status.split(",");
            n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String sta = stringArray[n3];
                String _sta = sta.trim().toLowerCase();
                if (_sta.equals("done")) {
                    list.add(1);
                } else if (_sta.equals("error")) {
                    list.add(-1);
                } else if (_sta.equals("killed")) {
                    list.add(-2);
                } else if (_sta.equals("dead")) {
                    list.add(-4);
                } else {
                    throw new Exception(Messages.getString("InternalEngineCommandsI.117") + _sta + Messages.getString("InternalEngineCommandsI.118"));
                }
                ++n3;
            }
            rules.put("purgeStatusList", list);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        rules.put("currentRuntime", currentRuntime);
        return rules;
    }

    void comExecuteCommandFileDefine() {
        try {
            CommandI comExecuteCommandFile = new CommandI("execute commands file", "execute commands in file <file>", Messages.getString("InternalEngineCommandsI.125"), new ICommandExecutorI(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void execute(CommandInstanceI pr) throws Exception {
                    String fileName = pr.getParameterValue(0);
                    try {
                        Throwable throwable = null;
                        Object var4_8 = null;
                        try {
                            FileInputStream fis = new FileInputStream(fileName);
                            try {
                                try (Scanner scanner = new Scanner((InputStream)fis, "UTF-8");){
                                    while (scanner.hasNextLine()) {
                                        String line = scanner.nextLine();
                                        if (line.replaceAll("[ \\t]*", "").startsWith("#") || line.replaceAll("[ \\t]*", "").equals("")) continue;
                                        InternalEngineCommandsI.this.executeCommand(line);
                                    }
                                }
                                if (fis == null) return;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (fis == null) throw throwable;
                                fis.close();
                                throw throwable;
                            }
                            fis.close();
                            return;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                                throw throwable;
                            } else {
                                if (throwable == throwable3) throw throwable;
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (FileNotFoundException e) {
                        InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.126"));
                        throw e;
                    }
                    catch (SecurityException e) {
                        InternalEngineCommandsI.this.out.println(Messages.getString("InternalEngineCommandsI.127") + e.getMessage());
                        throw e;
                    }
                    catch (Exception e) {
                        throw e;
                    }
                }
            });
            this.commandParser.AddCommand(comExecuteCommandFile);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
        }
    }

    public boolean executeCommand(String args) {
        boolean ret = false;
        try {
            this.executeCommandWithException(args);
        }
        catch (Exception e) {
            this.out.println(e.getMessage());
        }
        return ret;
    }

    public void executeCommandWithException(String args) throws Exception {
        Object o = this.parser.parse(args);
        if (o instanceof RuntimeCommand) {
            ((RuntimeCommand)o).execute(this.engineAPI, this.out, this.ctx);
        } else {
            this.commandParser.executeCommandLine(args);
        }
    }

    void comConnectDefine() {
        try {
            CommandI comConnect = new CommandI("connect", "connect [to <host|connectionName>] [port <port>] [silent] [user <user>] [password <password>] [uncryptedPassword <password>]", Messages.getString("InternalEngineCommandsI.128"), new ICommandExecutorI(){

                public void execute(CommandInstanceI commandInstance) {
                }
            });
            this.commandParser.AddCommand(comConnect);
        }
        catch (CommandParserExceptionI e) {
            this.logger.error("unexpected", (Throwable)e);
        }
    }

    public boolean connectOrReconnect() {
        return true;
    }

    public static class Column
    implements Comparable<Column> {
        private int position;
        String header;
        public List<String> datas = new ArrayList<String>();
        int type;
        int maxSize;

        public Column(int position, String name, int type) {
            this.header = name;
            this.type = type;
            this.position = position;
        }

        @Override
        public int compareTo(Column o) {
            return this.position - o.position;
        }
    }
}

