/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.command.impl;

import com.indy.engine.command.impl.InternalEngineCommandsI;
import com.indy.engine.command.impl.Messages;
import com.indy.engine.command.impl.RuntimeCommand;
import com.indy.engine.common.command.parser.CommandLine;
import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.common.RemoteSessionInfo;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@CommandLine(startWith="get connections", removeString="get connections", description="get remote sessions", usage="get connections")
public class ListRemoteConnectionCommand
implements RuntimeCommand {
    @Override
    public void execute(IEngineClient engineAPI, PrintStream out, Map<String, Object> ctx) throws Exception {
        Map remoteSessions = engineAPI.getRemoteSessions(null);
        if (remoteSessions != null && !remoteSessions.isEmpty()) {
            HashMap<String, InternalEngineCommandsI.Column> columns = new HashMap<String, InternalEngineCommandsI.Column>();
            int position = 0;
            columns.put("user", new InternalEngineCommandsI.Column(position++, Messages.getString("ListRemoteConnectionCommand.0"), 0));
            columns.put("clientHost", new InternalEngineCommandsI.Column(position++, Messages.getString("ListRemoteConnectionCommand.1"), 0));
            columns.put("startDate", new InternalEngineCommandsI.Column(position++, Messages.getString("ListRemoteConnectionCommand.2"), 0));
            columns.put("lastAcess", new InternalEngineCommandsI.Column(position++, Messages.getString("ListRemoteConnectionCommand.3"), 0));
            columns.put("id", new InternalEngineCommandsI.Column(position++, Messages.getString("ListRemoteConnectionCommand.4"), 0));
            for (Map.Entry entry : remoteSessions.entrySet()) {
                if (!(entry.getValue() instanceof Map)) continue;
                RemoteSessionInfo rsi = RemoteSessionInfo.parse((Map)((Map)entry.getValue()));
                ((InternalEngineCommandsI.Column)columns.get((Object)"id")).datas.add(rsi.getRemoteSessionId());
                if (rsi.getUser() == null) {
                    ((InternalEngineCommandsI.Column)columns.get((Object)"user")).datas.add(null);
                } else {
                    ((InternalEngineCommandsI.Column)columns.get((Object)"user")).datas.add(rsi.getUser());
                }
                if (rsi.getStartDate() != null) {
                    ((InternalEngineCommandsI.Column)columns.get((Object)"startDate")).datas.add(rsi.getStartDate().toString());
                } else {
                    ((InternalEngineCommandsI.Column)columns.get((Object)"startDate")).datas.add(null);
                }
                Date dte = rsi.getLastAccess();
                if (dte != null) {
                    ((InternalEngineCommandsI.Column)columns.get((Object)"lastAcess")).datas.add(dte.toString());
                } else {
                    ((InternalEngineCommandsI.Column)columns.get((Object)"lastAcess")).datas.add("unknown");
                }
                ((InternalEngineCommandsI.Column)columns.get((Object)"clientHost")).datas.add(rsi.getClientHost());
            }
            out.println(InternalEngineCommandsI.formatList2(columns, null));
        } else {
            out.println(Messages.getString("ListRemoteConnectionCommand.5"));
        }
    }
}

