/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.command.impl;

import com.indy.engine.command.impl.Messages;
import com.indy.engine.command.impl.RuntimeCommand;
import com.indy.engine.common.command.parser.CommandLine;
import com.indy.engine.common.command.parser.CommandParameter;
import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.common.objects2.EngineScheduleDetail;
import com.indy.engine.scheduler.EngineSchedulerI;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Map;

@CommandLine(startWith="get schedule detail", removeString="get schedule", usage="get schedule detail <name> [to <file>]", description="Get detail of a schedule")
public class ScheduleDetailCommand
implements RuntimeCommand {
    @CommandParameter(name="detail", valueSample="scheduleName", usage="Schedule name")
    public String name;
    @CommandParameter(name="file", valueSample="file", usage="file")
    public String file;

    @Override
    public void execute(IEngineClient engineAPI, PrintStream out, Map<String, Object> ctx) throws Exception {
        if (this.name == null) {
            out.println(Messages.getString("ScheduleDetailCommand.0"));
        } else {
            String triggerName = EngineSchedulerI.getTriggerNameFromScheduleOrTriggerName(engineAPI, this.name);
            out.println(Messages.getString("ScheduleDetailCommand.1") + triggerName);
            try (FileOutputStream fos = null;){
                EngineScheduleDetail esd = new EngineScheduleDetail(engineAPI.getTriggerDetail(triggerName));
                try {
                    if (this.file != null) {
                        fos = new FileOutputStream(this.file);
                    }
                }
                catch (Exception e) {
                    this.file = null;
                }
                if (this.file == null) {
                    out.println(esd.toString());
                } else {
                    fos.write((esd.toString() + System.getProperty("line.separator")).getBytes());
                }
                if (this.file != null) {
                    out.println(Messages.getString("ScheduleDetailCommand.2") + this.file);
                }
            }
        }
    }
}

