/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main;

import com.indy.engine.Global;
import com.indy.engine.core.common.UUID32;
import com.indy.engine.main.Messages;
import com.indy.engine.main.WaitMainEngine;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MainEngineEnv {
    static Map<String, WaitMainEngine> pileHandler = Collections.synchronizedMap(new HashMap());
    static String lastSessionId;
    static long lastTstamp;
    static final Object idSemaphore;

    static {
        lastTstamp = -1L;
        idSemaphore = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String createId2(String sessionIdSalt) {
        Object object = idSemaphore;
        synchronized (object) {
            String vmid = null;
            long ts = -1L;
            int log = 0;
            Global.getLogger().info("Calculating session id...");
            do {
                if (vmid != null && log < 2) {
                    Global.getLogger().info("Calculating session id: {} id is already used", vmid);
                    log = 2;
                } else if (ts > -1L && ts == lastTstamp && log < 1) {
                    Global.getLogger().info("Calculating session id: {} timestamp is already used", (Object)ts);
                    log = 1;
                }
                ts = System.currentTimeMillis();
                if (ts == lastTstamp) continue;
                try {
                    vmid = UUID32.randomUUID((InetAddress)Global.getLocalHost(), (boolean)Global.isRandomSecure(), (long)ts, (String)sessionIdSalt).toString();
                }
                catch (UnknownHostException e) {
                    Global.getLogger().error(Messages.getString("MainEngineEnv.5"));
                    return null;
                }
            } while (vmid == null || vmid.equals(lastSessionId));
            lastSessionId = vmid;
            lastTstamp = ts;
            Global.getLogger().info("session id is: {}", (Object)vmid);
            return vmid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createId(String sessionIdSalt) {
        Object object = idSemaphore;
        synchronized (object) {
            String vmid = null;
            long ts = -1L;
            ts = System.currentTimeMillis();
            while (ts == lastTstamp) {
                ++ts;
            }
            try {
                vmid = UUID32.randomUUID((InetAddress)Global.getLocalHost(), (boolean)Global.isRandomSecure(), (long)ts, (String)sessionIdSalt).toString();
            }
            catch (UnknownHostException e) {
                Global.getLogger().error(Messages.getString("MainEngineEnv.7"));
                return null;
            }
            lastSessionId = vmid;
            lastTstamp = ts;
            return vmid;
        }
    }

    public static String createId() {
        return MainEngineEnv.createId(null);
    }
}

