/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main;

import com.indy.engine.main.MainEngineI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WaitMainEngine {
    List<MainEngineI> wait = new ArrayList<MainEngineI>();
    Set<MainEngineI> running = new HashSet<MainEngineI>();
    int size = 1;

    public WaitMainEngine(Integer nbMaxParallelSessions) {
        this.size = nbMaxParallelSessions;
    }

    public synchronized void add(MainEngineI e) {
        this.size = e.getNbMaxParallelSessions();
        if (this.running.size() < this.size) {
            this.addToRunning(e);
        } else {
            this.wait.add(e);
        }
    }

    private synchronized boolean addToRunning(MainEngineI e) {
        this.wait.remove(e);
        if (!e.isClear()) {
            this.running.add(e);
            e.addHandler(new MainEngineI.EngineHandler(){

                @Override
                public void beforeStarting(MainEngineI mainEngine) {
                }

                @Override
                public void beforeStoping(MainEngineI mainEngine) {
                    WaitMainEngine.this.engineStop(mainEngine);
                }
            });
            return true;
        }
        return false;
    }

    public synchronized boolean isRunning(MainEngineI engine) {
        for (MainEngineI engine2 : this.running) {
            if (!engine2.isClear()) continue;
            this.running.remove(engine2);
        }
        if (this.running.contains(engine)) {
            return true;
        }
        if (this.running.size() < this.size) {
            return this.addToRunning(engine);
        }
        return false;
    }

    public synchronized void engineStop(MainEngineI engine) {
        this.running.remove(engine);
        if (this.running.size() < this.size && this.wait.size() > 0) {
            boolean ok = false;
            do {
                MainEngineI start;
                if (!(ok = this.addToRunning(start = this.wait.get(0)))) continue;
                start.stopWaiting();
            } while (!ok && this.wait.size() > 0);
        }
    }

    public synchronized void remove(MainEngineI mainEngineI) {
        this.wait.remove(mainEngineI);
        this.running.remove(mainEngineI);
    }
}

