/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main.connections.tools;

import com.indy.engine.Global;
import com.indy.engine.main.connections.tools.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.semarchy.xdi.runtime.connection.jdbc.DataSourceConfiguration;
import com.semarchy.xdi.runtime.connection.jdbc.DataSourceManager;
import java.sql.Connection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JdbcFunctions {
    private static final Logger LOGGER = LogManager.getLogger(JdbcFunctions.class);

    private JdbcFunctions() {
    }

    public static Connection rapidConnect(String jdbcDriver, String jdbcUrl, String jdbcUser, String jdbcPassword, String encodedPasword, String moduleName) throws EngineExceptionI {
        Connection conn = null;
        DataSourceConfiguration configuration = new DataSourceConfiguration().enablePool(false);
        try {
            if (jdbcDriver == null) {
                throw new EngineExceptionI(Messages.getString("JdbcFunctions.3"));
            }
            configuration.jdbcParameters().driver(jdbcDriver);
            configuration.jdbcParameters().username(jdbcUser);
            String userLogRdbmsEncryptedPassword = encodedPasword;
            if (jdbcPassword == null && userLogRdbmsEncryptedPassword != null) {
                try {
                    Global.engineServer.getIsSemaphore(Messages.getString("JdbcFunctions.4"));
                    jdbcPassword = Global.engineServer.getStringAsciiInfo(userLogRdbmsEncryptedPassword);
                }
                catch (Exception e) {
                    LOGGER.warn("unexpected", (Throwable)e);
                }
            }
            configuration.jdbcParameters().password(jdbcPassword);
            configuration.jdbcParameters().moduleName(moduleName);
            if (jdbcUrl == null) {
                throw new EngineExceptionI(Messages.getString("JdbcFunctions.5"));
            }
            configuration.jdbcParameters().url(jdbcUrl);
            conn = DataSourceManager.instance().getDataSource(configuration).getConnection();
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        return conn;
    }
}

