/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main.repository.impl;

import com.ctc.wstx.stax.WstxInputFactory;
import com.indy.engine.core.repository.IDeliveryRepositoryPlugin;
import com.indy.engine.main.repository.impl.CommonAnalyticsRepository;
import com.indy.engine.shared.plugin.IPluginFactory;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AnalyticsV2Repository
extends CommonAnalyticsRepository {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private long lastRefreshTime = 0L;
    private static final QName nameAttr = new QName("name");
    private static final QName idAttr = new QName("id");
    private static final String deliveryPath = String.join((CharSequence)"/", "", "response", "delivery");
    private static final String repositoryResource = "repo";
    private static final String deliveriesResource = "getLstDeliveries";
    private static final String deliveryResource = "getDelivery";
    private static final String nameParam = "?name=";
    private static final String versionParam = "&version=";
    private static final WstxInputFactory wstxInputFactory = new WstxInputFactory();

    public AnalyticsV2Repository(IPluginFactory.IPluginConfiguration conf, IPluginFactory.IRelativePathResolver resolver) {
        super(conf, resolver);
    }

    @Override
    protected final String getSynchronizeQuery(IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo) {
        StringBuilder query = new StringBuilder(this.getDeliveryContentQuery(deliveryInfo));
        String deliveryVersion = deliveryInfo.getVersion();
        if (deliveryVersion != null) {
            query.append(versionParam).append(deliveryVersion);
        }
        return query.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, IDeliveryRepositoryPlugin.DeliveryInfo> getDeliveriesInfo(boolean refresh) throws Exception {
        Map map = this.deliveriesInfo;
        synchronized (map) {
            if (refresh && System.currentTimeMillis() - this.lastRefreshTime > 1000L) {
                String remoteName = this.httpRepositoryStore.getRemoteName();
                StringBuilder query = new StringBuilder(String.join((CharSequence)"/", repositoryResource, remoteName, deliveriesResource));
                StringBuilder path = new StringBuilder();
                HttpResponse<InputStream> connection = this.connect(query.toString());
                if (connection != null) {
                    this.lastRefreshTime = System.currentTimeMillis();
                    XMLEventReader reader = null;
                    try {
                        InputStream inputStream = connection.body();
                        reader = wstxInputFactory.createXMLEventReader(inputStream, "UTF-8");
                        path.setLength(0);
                        HashMap oldDelivs = new HashMap(this.deliveriesInfo);
                        this.deliveriesInfo.clear();
                        while (reader.hasNext()) {
                            XMLEvent event = (XMLEvent)reader.next();
                            if (event.isStartElement()) {
                                StartElement element = event.asStartElement();
                                QName elementName = element.getName();
                                String localPart = elementName.getLocalPart();
                                path.append("/").append(localPart);
                                if (deliveryPath.equals(path.toString())) {
                                    Attribute idAttribute;
                                    IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo = new IDeliveryRepositoryPlugin.DeliveryInfo();
                                    Attribute nameAttribute = element.getAttributeByName(nameAttr);
                                    String deliveryName = null;
                                    if (nameAttribute != null) {
                                        deliveryName = nameAttribute.getValue();
                                        deliveryInfo.setName(deliveryName);
                                    }
                                    if ((idAttribute = element.getAttributeByName(idAttr)) != null) {
                                        String deliveryId = idAttribute.getValue();
                                        deliveryInfo.setId(deliveryId);
                                        IDeliveryRepositoryPlugin.DeliveryInfo oldDeliv = (IDeliveryRepositoryPlugin.DeliveryInfo)oldDelivs.get(deliveryName);
                                        if (oldDeliv != null && deliveryId.equals(oldDeliv.getId()) && oldDeliv.getFile() != null) {
                                            deliveryInfo.setFile(oldDeliv.getFile());
                                        }
                                    }
                                    this.deliveriesInfo.put(deliveryName, deliveryInfo);
                                }
                            }
                            if (!event.isEndElement()) continue;
                            int lastPathSeparatorIndex = path.lastIndexOf("/");
                            String truncatedPath = path.substring(0, lastPathSeparatorIndex);
                            path.setLength(0);
                            path.append(truncatedPath);
                        }
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Exception e) {
                                this.logger.warn("unexpected", (Throwable)e);
                            }
                        }
                    }
                }
            }
            return new HashMap<String, IDeliveryRepositoryPlugin.DeliveryInfo>(this.deliveriesInfo);
        }
    }

    public IDeliveryRepositoryPlugin.DeliveryInfo getDeliveryInfo(String deliveryName) throws Exception {
        this.getDeliveriesInfo(true);
        return (IDeliveryRepositoryPlugin.DeliveryInfo)this.deliveriesInfo.get(deliveryName);
    }

    @Override
    protected final String getDeliveryContentQuery(IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo) {
        String remoteName = this.httpRepositoryStore.getRemoteName();
        String deliveryName = deliveryInfo.getName();
        return String.join((CharSequence)"/", repositoryResource, remoteName, "getDelivery?name=" + deliveryName);
    }
}

