/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main.repository.impl;

import com.indy.engine.core.repository.IDeliveryRepositoryPlugin;
import com.indy.engine.main.repository.impl.CommonAnalyticsRepository;
import com.indy.engine.main.repository.stores.HttpRepositoryStore;
import com.indy.engine.shared.plugin.IPluginFactory;
import com.indy.runtime.json.JsonUtils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class AnalyticsV3Repository
extends CommonAnalyticsRepository {
    private String checkSum = null;
    private long lastRefreshTime = 0L;
    private static final String projectAttr = "project";
    private static final String packageAttr = "package";
    private static final String nameAttr = "name";
    private static final String idAttr = "id";
    private static final String apiPath = String.join((CharSequence)"/", "services", "api");
    private static final String checkSumResource = "checksum";
    private static final String deliveriesResource = "deliveries";
    private static final String environmentResource = String.join((CharSequence)"/", apiPath, "2", "environment");
    private static final String deliveryResource = String.join((CharSequence)"/", apiPath, "1", "application", "default", "repository", "default", "delivery");
    private static final String contentResource = "content";
    private static final String checkSumParam = "checksum=";

    public AnalyticsV3Repository(IPluginFactory.IPluginConfiguration conf, IPluginFactory.IRelativePathResolver resolver) {
        super(conf, resolver);
    }

    @Override
    protected final String getSynchronizeQuery(IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo) {
        return this.getDeliveryContentQuery(deliveryInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, IDeliveryRepositoryPlugin.DeliveryInfo> getDeliveriesInfo(boolean refresh) throws Exception {
        Map map = this.deliveriesInfo;
        synchronized (map) {
            if (refresh && System.currentTimeMillis() - this.lastRefreshTime > 1000L) {
                int responseCode;
                String environment = this.httpRepositoryStore.getEnvironment();
                StringBuilder query = new StringBuilder(String.join((CharSequence)"/", environmentResource, environment, deliveriesResource));
                if (this.checkSum != null) {
                    query.append("?");
                    query.append(checkSumParam).append(this.checkSum);
                }
                this.lastRefreshTime = System.currentTimeMillis();
                HttpResponse<InputStream> connection = this.connect(query.toString());
                if (connection != null && (responseCode = connection.statusCode()) != 304) {
                    InputStream inputStream = connection.body();
                    HashMap rawResponse = (HashMap)JsonUtils.jsonNodeToObject((InputStream)inputStream, (String)"UTF-8");
                    this.checkSum = rawResponse.get(checkSumResource).toString();
                    ArrayList deliveriesList = (ArrayList)rawResponse.get(deliveriesResource);
                    HashMap oldDelivs = new HashMap(this.deliveriesInfo);
                    this.deliveriesInfo.clear();
                    for (Object rawDelivery : deliveriesList) {
                        HashMap deliveryMap = (HashMap)rawDelivery;
                        IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo = new IDeliveryRepositoryPlugin.DeliveryInfo();
                        String deliveryProject = deliveryMap.getOrDefault(projectAttr, null);
                        String deliveryPackage = deliveryMap.getOrDefault(packageAttr, null);
                        String deliveryName = deliveryMap.getOrDefault(nameAttr, null);
                        String deliveryFullName = String.join((CharSequence)"/", deliveryProject, deliveryPackage, deliveryName);
                        deliveryInfo.setName(deliveryFullName);
                        String deliveryId = deliveryMap.getOrDefault(idAttr, null);
                        deliveryInfo.setId(deliveryId);
                        IDeliveryRepositoryPlugin.DeliveryInfo oldDeliv = (IDeliveryRepositoryPlugin.DeliveryInfo)oldDelivs.get(deliveryFullName);
                        if (oldDeliv != null && oldDeliv.getId().equals(deliveryId) && oldDeliv.getFile() != null) {
                            deliveryInfo.setFile(oldDeliv.getFile());
                        }
                        this.deliveriesInfo.put(deliveryFullName, deliveryInfo);
                    }
                }
            }
            return new HashMap<String, IDeliveryRepositoryPlugin.DeliveryInfo>(this.deliveriesInfo);
        }
    }

    public IDeliveryRepositoryPlugin.DeliveryInfo getDeliveryInfo(String deliveryName) throws Exception {
        this.getDeliveriesInfo(true);
        String fullDeliveryname = this.doGetFullDeliveryName(deliveryName);
        return (IDeliveryRepositoryPlugin.DeliveryInfo)this.deliveriesInfo.get(fullDeliveryname);
    }

    @Override
    protected final String getDeliveryContentQuery(IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo) {
        String deliveryId = deliveryInfo.getId();
        return String.join((CharSequence)"/", deliveryResource, deliveryId, contentResource);
    }

    private String doGetFullDeliveryName(String deliveryName) {
        String defaultDelivPath;
        if (deliveryName.split("/").length != 3 && (defaultDelivPath = ((HttpRepositoryStore)this.getInfos()).getDefaultDeliveryPath()) != null && !defaultDelivPath.isEmpty()) {
            return defaultDelivPath + "/" + deliveryName;
        }
        return deliveryName;
    }
}

