/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main.repository.internal;

import com.indy.engine.Global;
import com.indy.engine.core.module.classloader.ClassLoaderServiceProvider;
import com.indy.engine.core.repository.IDeliveryRepositoryPlugin;
import com.indy.engine.main.repository.IDeliveryRepository;
import com.indy.engine.main.repository.internal.DeliveryRepository;
import com.indy.engine.main.repository.internal.Messages;
import com.indy.engine.shared.configuration.repository.RepositoryConfigurationProvider;
import com.indy.engine.shared.plugin.IPluginFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RepositoryManager {
    private List<IDeliveryRepository> repositories;

    public RepositoryManager() throws Exception {
        block16: {
            this.repositories = new ArrayList<IDeliveryRepository>();
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (FileInputStream is = new FileInputStream(new File(Global.XML_ENGINE_REPOSITORY));){
                    Thread.currentThread().setContextClassLoader(ClassLoaderServiceProvider.instance().getClassLoader("internal"));
                    RepositoryConfigurationProvider provider = RepositoryConfigurationProvider.load((InputStream)is);
                    if (provider == null || provider.getConfigurations() == null) break block16;
                    for (IPluginFactory.IPluginConfiguration cnf : provider.getConfigurations()) {
                        String memCache = cnf.getProperty("enableMemoryCache");
                        boolean enableMemCache = false;
                        if (memCache != null) {
                            try {
                                enableMemCache = Boolean.valueOf(memCache);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        this.createRepository(cnf.getModuleProvider(), cnf.getPluginFactoryClassName(), cnf.getProperty("cacheFolder"), enableMemCache, cnf);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(ccl);
            }
        }
    }

    public Iterator<IDeliveryRepository> getRepositories() {
        return this.repositories.iterator();
    }

    protected IPluginFactory.IRelativePathResolver getRelativePathResolver() {
        return null;
    }

    private void createRepository(String moduleProvider, String pluginFactoryClass, String cacheFoler, boolean enableMemoryCache, IPluginFactory.IPluginConfiguration conf) throws Exception {
        if (moduleProvider == null) {
            moduleProvider = "internal";
        }
        if (pluginFactoryClass == null) {
            throw new Exception(String.format(Messages.getString("RepositoryManager.0"), "class", conf.getProperty("name")));
        }
        ClassLoader classLoader = ClassLoaderServiceProvider.instance().getClassLoader(moduleProvider);
        Class<?> clzz = null;
        try {
            clzz = classLoader.loadClass(pluginFactoryClass);
        }
        catch (ClassNotFoundException ex) {
            throw new Exception(String.format(Messages.getString("RepositoryManager.1"), moduleProvider, pluginFactoryClass, conf.getProperty("name")), ex);
        }
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            IPluginFactory factory = (IPluginFactory)clzz.newInstance();
            IDeliveryRepositoryPlugin plugin = (IDeliveryRepositoryPlugin)factory.createPlugin(conf, this.getRelativePathResolver());
            if (this.getRelativePathResolver() != null) {
                cacheFoler = this.getRelativePathResolver().resolve(cacheFoler);
            }
            DeliveryRepository repo = new DeliveryRepository(cacheFoler, enableMemoryCache, plugin);
            this.repositories.add(repo);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }
}

