/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.manager;

import com.indy.engine.Global;
import com.indy.engine.core.IActionBind;
import com.indy.engine.main.ActionGraphLinkI;
import com.indy.engine.main.MainEngineI;
import com.indy.engine.main.action.IAction;
import com.indy.engine.main.action.statics.ActionStatic;
import com.indy.engine.main.action.statics.ActionStaticProcess;
import com.indy.engine.manager.Action;
import com.indy.engine.manager.ActionCode;
import com.indy.engine.manager.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ActionProcess
extends Action {
    private Map<String, Action> children2;
    boolean reinit = true;
    Set<Action> runningAction = new HashSet<Action>();
    Set<Action> errorAction = new HashSet<Action>();
    Action causeErrorAction;
    Set<Action> killAction = new HashSet<Action>();
    private Vector<String> lstChildLinks = new Vector();
    boolean hasChange = false;

    public ActionProcess(ActionStatic store, MainEngineI mainEngine) throws EngineExceptionI {
        super(store, mainEngine);
    }

    public Map<String, Action> getChildren() {
        if (this.children2 == null) {
            this.children2 = new HashMap<String, Action>();
        }
        for (ActionStatic _action : ((ActionStaticProcess)this.store).getChildren()) {
            this.children2.put(_action.getActionName(), this.getMainEngine().getActionInstance(_action));
        }
        return this.children2;
    }

    @Override
    public Thread runAction() throws EngineExceptionI {
        this.initStart();
        this.reset();
        if ((!this.hasRestartPoint() || this.isDone()) && this.getParentAction() != null) {
            for (Action action : this.getChildren().values()) {
                action.resetForReexecute();
            }
        } else {
            this.setRestartPoint();
        }
        this.setIsRestartPoint(0);
        this.setActionState(2);
        this.getMainEngine().uLog.addAction(this, this.getMainEngine().incrNumAction());
        this.computeBeginNodes();
        return null;
    }

    public void computeBeginNodes() throws EngineExceptionI {
        for (Action agn : this.getChildren().values()) {
            if (this.lstChildLinks.contains(agn.getActionName())) continue;
            Global.dLog.write(this.getMainEngine().getSessionName(), "ActionGraph=>flagLstBeginNode", agn.getActionName() + Messages.getString("ActionProcess.0") + agn.getActionName(), 2, agn.getActionStatic().getActionLevel(), "DEBUG");
            agn.setBeginAction(true);
        }
        Iterator<Action> it = null;
    }

    public boolean hasOnlySrcBindedAction() {
        if (this.runningAction.size() == 0) {
            return false;
        }
        for (Action action : this.runningAction) {
            if (action instanceof ActionCode && action.isBindedAndRunning()) continue;
            return false;
        }
        return true;
    }

    public void endAllOnlySrcBindedAction() {
        for (Action action : this.runningAction) {
            if (!(action instanceof ActionCode)) continue;
            ((ActionCode)action).stopBindedActionProperly();
        }
    }

    @Override
    public void resetForReexecute() {
        super.resetForReexecute();
        for (Action action : this.getChildren().values()) {
            action.resetForReexecute();
        }
    }

    public void end() throws EngineExceptionI {
        try {
            try {
                this.debug(Messages.getString("ActionProcess.1"), null);
                if (this.hasErrorAction()) {
                    this.setActionState(-1);
                    if (this.raiseErrorIfFailed()) {
                        if (this.causeErrorAction != null) {
                            this.getParentAction().setCauseErrorAction(this.causeErrorAction);
                        }
                        this.getParentAction().addErrorAction(this);
                    }
                } else if (this.getActionState() == -3) {
                    this.setActionState(-2);
                    if (this.getParentAction() != null) {
                        this.getParentAction().addKillAction(this);
                    }
                } else {
                    this.setActionState(1);
                }
                if (this.isDone()) {
                    this.incrNbExecution();
                }
                this.writeEndVariable();
                this.updateActionAndLinkGraph();
                this.debug(Messages.getString("ActionProcess.2"), null);
            }
            catch (Throwable t) {
                this.setToError(Messages.getString("ActionProcess.3"), t);
                this.writeEndVariable();
                if (this.getParentAction() != null) {
                    this.getParentAction().addErrorAction(this);
                } else {
                    this.addErrorAction(this);
                }
                if (this.hasFather()) {
                    this.getParentAction().setHasChange();
                }
                if (this.getParentAction() != null) {
                    this.getParentAction().removeRunningAction(this);
                }
                if (this.hasFather()) {
                    this.CopyContextToULog();
                    this.getMainEngine().uLog.finalizeAction(this, this.getMainEngine().incrNumAction());
                }
            }
        }
        finally {
            if (this.hasFather()) {
                this.getParentAction().setHasChange();
            }
            if (this.getParentAction() != null) {
                this.getParentAction().removeRunningAction(this);
            }
            if (this.hasFather()) {
                this.CopyContextToULog();
                this.getMainEngine().uLog.finalizeAction(this, this.getMainEngine().incrNumAction());
            }
        }
    }

    @Override
    public boolean isProcess() {
        return true;
    }

    @Override
    public boolean hasFather() {
        return this.getActionName().contains("/");
    }

    public boolean hasRunningAction() {
        return this.runningAction.size() > 0;
    }

    @Override
    public void stopAction() {
        if (!this.isEnded()) {
            for (Action action : this.runningAction) {
                this.debug(Messages.getString("ActionProcess.4") + action.getActionName(), null);
                action.stopAction();
            }
        }
    }

    public void addRunningAction(Action action) {
        this.runningAction.add(action);
    }

    public void removeRunningAction(Action action) {
        this.runningAction.remove(action);
    }

    public Set<Action> getErrorAction() {
        return this.errorAction;
    }

    public void setCauseErrorAction(Action action) {
        if (this.causeErrorAction == null) {
            this.causeErrorAction = action;
        }
    }

    public Action getCauseErrorAction() {
        return this.causeErrorAction;
    }

    public void addErrorAction(Action action) {
        this.errorAction.add(action);
    }

    public boolean hasErrorAction() {
        return this.errorAction.size() > 0;
    }

    public Set<Action> getKillAction() {
        return this.killAction;
    }

    public void addKillAction(Action action) {
        this.killAction.add(action);
    }

    public boolean hasKillAction() {
        return this.killAction.size() > 0;
    }

    @Override
    public void reset() {
        this.errorAction.clear();
        this.causeErrorAction = null;
        this.killAction.clear();
        this.runningAction.clear();
        super.reset();
    }

    public void addActionLinkName(String actionName) {
        this.lstChildLinks.add(actionName);
    }

    public List getLstChildIds() {
        ArrayList<String> tm = null;
        tm = new ArrayList<String>();
        for (Action agn : this.getChildren().values()) {
            tm.add(agn.getActionStatic().getActionId());
        }
        return tm;
    }

    public boolean hasChange() {
        return this.hasChange;
    }

    public void setHasChange() {
        this.hasChange = true;
    }

    public void unSetHasChange() {
        this.hasChange = false;
    }

    @Override
    public void clear() throws Exception {
        this.lstChildLinks.clear();
        this.lstChildLinks = null;
        this.errorAction.clear();
        this.errorAction = null;
        this.causeErrorAction = null;
        this.killAction.clear();
        this.killAction = null;
        this.runningAction.clear();
        this.runningAction = null;
        for (Action action : this.children2.values()) {
            action.clear();
        }
        this.children2.clear();
        this.children2 = null;
        super.clear();
    }

    /*
     * WARNING - void declaration
     */
    private void setRestartPoint() {
        HashSet<IAction> actionsToRestart = new HashSet<IAction>();
        for (IAction iAction : this.getChildren().values()) {
            boolean restartPoint = false;
            boolean restartPoint2 = false;
            if (iAction.getActionState() == -2 || iAction.getActionState() == -3) {
                restartPoint = true;
            } else if (iAction.getActionState() == -1 && !iAction.getActionStatic().getToleratedError()) {
                if (iAction.hasFather()) {
                    boolean tolerated = false;
                    Enumeration e4 = iAction.getActionChildGraphLink();
                    while (e4.hasMoreElements()) {
                        ActionGraphLinkI agl = (ActionGraphLinkI)e4.nextElement();
                        if (!agl.getLinkStatic().isAnyOrKo() || !agl.hasActived()) continue;
                        tolerated = true;
                    }
                    restartPoint = !tolerated;
                } else {
                    restartPoint = true;
                }
            }
            if (!restartPoint && iAction.hasFather()) {
                restartPoint2 = iAction.hasActiveLink();
            }
            if (restartPoint2) {
                actionsToRestart.add(iAction);
                continue;
            }
            if (restartPoint) {
                iAction.setIsRestartPoint(1);
                this.debug(Messages.getString("ActionProcess.5") + iAction.getActionStatic().getActionName() + Messages.getString("ActionProcess.6"), null);
                Global.dLog.write(this.getSessionName(), Messages.getString("ActionProcess.7"), iAction.getActionStatic().getActionName(), 0, 1, "INFO");
                actionsToRestart.add(iAction);
                continue;
            }
            iAction.setIsRestartPoint(0);
        }
        try {
            HashSet<IAction> hashSet;
            HashSet<IAction> hashSet2 = actionsToRestart;
            do {
                void var2_5;
                actionsToRestart = var2_5;
                hashSet = new HashSet<IAction>();
                for (IAction action : actionsToRestart) {
                    this.debug(Messages.getString("ActionProcess.8") + action.getActionName(), null);
                    HashSet<IAction> actions = new HashSet<IAction>();
                    this.actionToRestart(action, actions, hashSet, false);
                    actions.clear();
                }
                for (IAction action : hashSet) {
                    action.setIsRestartPoint(2);
                }
            } while (!hashSet.equals(actionsToRestart));
            for (IAction action : hashSet) {
                this.debug(Messages.getString("ActionProcess.9") + action.getActionName(), null);
            }
            if (hashSet != null) {
                hashSet.clear();
            }
            if (actionsToRestart != null) {
                actionsToRestart.clear();
            }
        }
        catch (Exception exception) {
            logger.debug("unexpected", (Throwable)exception);
        }
    }

    private boolean actionToRestart(IAction action, Set<IAction> actions, Set<IAction> actionsToRestart, boolean override) {
        if (actions.contains(action)) {
            return false;
        }
        actions.add(action);
        boolean _ret = false;
        boolean bl = override = ((Action)action).hasForceRestartPoint() ? true : override;
        if (action.getActionStatic().isRestartOpenMode() && !override) {
            this.debug(Messages.getString("ActionProcess.10") + action.getActionName() + Messages.getString("ActionProcess.11"), null);
            action.setIsRestartPoint(1);
            _ret = true;
        } else if (!action.hasRestartPoint() && action.getActionStatic().isRestartCloseMode()) {
            _ret = false;
        } else {
            boolean hasRestartPoint = false;
            Set<IAction> precs = ((Action)action).getPrecedentActions();
            HashSet<IAction> precsNotRestart = new HashSet<IAction>();
            HashSet<IAction> precsRestart = new HashSet<IAction>();
            if (precs != null && precs.size() > 0) {
                for (IAction prec : precs) {
                    HashSet<IAction> _actions;
                    if (this.actionToRestart(prec, _actions = new HashSet<IAction>(actions), actionsToRestart, override)) {
                        hasRestartPoint = true;
                        precsRestart.add(prec);
                    } else {
                        precsNotRestart.add(prec);
                    }
                    _actions.clear();
                    _actions = null;
                }
            }
            if (hasRestartPoint && action.hasRestartPoint()) {
                this.debug(Messages.getString("ActionProcess.12") + action.getActionName() + Messages.getString("ActionProcess.13"), null);
                ((Action)action).updatePreviousLinks(precsNotRestart, precsRestart);
                action.setIsRestartPoint(0);
            }
            if (action.hasRestartPoint() && action.getActionStatic().isTrgBindedAction()) {
                action.setIsRestartPoint(0);
                this.debug(Messages.getString("ActionProcess.14") + action.getActionName() + Messages.getString("ActionProcess.15"), null);
            }
            if (!hasRestartPoint && action.hasRestartPoint() && (hasRestartPoint = !override ? true : ((Action)action).hasForceRestartPoint()) && !((Action)action).hasForceRestartPoint()) {
                ((Action)action).setIsRestartPoint(1);
            }
            _ret = hasRestartPoint;
        }
        if (action.hasRestartPoint() || _ret) {
            action.disableActiveLink();
        }
        if (action.hasRestartPoint()) {
            if (!override) {
                actionsToRestart.add(action);
            } else if (((Action)action).hasForceRestartPoint()) {
                actionsToRestart.add(action);
            }
        }
        return _ret;
    }

    public Hashtable<String, Action> getLstActivableActions() throws EngineExceptionI {
        Hashtable<String, Action> activableAct = new Hashtable<String, Action>();
        for (Action action : this.getChildren().values()) {
            ActionGraphLinkI lnk;
            if (action.getBeginAction() && action.isNeverExecuted() || action.hasForceRestartPoint()) {
                this.debug(action.getActionName() + Messages.getString("ActionProcess.16") + action.getBeginAction() + Messages.getString("ActionProcess.17") + action.isNeverExecuted() + Messages.getString("ActionProcess.18") + action.hasForceRestartPoint() + "]", null);
                if (action.getActionName().equals("Alim All Hotel Datamart/82. Alim FACT_BILLING")) {
                    action.getActionId();
                }
                activableAct.put(action.getActionName(), action);
                continue;
            }
            if (!action.isNeverExecuted() && !action.isEnded()) continue;
            int mandatFatherNb = 0;
            int mandatActivFatherNb = 0;
            int notMandatActivFatherNb = 0;
            int inhibActivFatherNb = 0;
            Enumeration<ActionGraphLinkI> l = action.lstFatherLinks.elements();
            while (l.hasMoreElements()) {
                lnk = l.nextElement();
                Action src = lnk.getActionSource();
                if (lnk.getLinkStatic().getMandatory() == 1) {
                    ++mandatFatherNb;
                    if (!lnk.isActive()) continue;
                    ++mandatActivFatherNb;
                    continue;
                }
                if (lnk.getLinkStatic().getMandatory() == -1) {
                    if (!lnk.isActive()) continue;
                    ++inhibActivFatherNb;
                    continue;
                }
                if (!lnk.isActive()) continue;
                ++notMandatActivFatherNb;
            }
            if ((mandatFatherNb != mandatActivFatherNb || mandatFatherNb == 0 || inhibActivFatherNb != 0) && (mandatFatherNb != 0 || notMandatActivFatherNb <= 0 || inhibActivFatherNb != 0)) continue;
            Integer nbAllowExecution = 0;
            nbAllowExecution = action.getActionStatic().getNbCycles();
            if (action.getNbExecution() >= nbAllowExecution && nbAllowExecution != -1) continue;
            activableAct.put(action.getActionName(), action);
            if (!action.getActionName().equals("Alim All Hotel Datamart/82. Alim FACT_BILLING")) continue;
            action.getActionId();
            Enumeration<ActionGraphLinkI> l2 = action.lstFatherLinks.elements();
            while (l2.hasMoreElements()) {
                lnk = l2.nextElement();
                Action src = lnk.getActionSource();
                if (lnk.getLinkStatic().getMandatory() == 1) {
                    ++mandatFatherNb;
                    if (!lnk.isActive()) continue;
                    ++mandatActivFatherNb;
                    continue;
                }
                if (lnk.getLinkStatic().getMandatory() == -1) {
                    if (!lnk.isActive()) continue;
                    ++inhibActivFatherNb;
                    continue;
                }
                if (!lnk.isActive()) continue;
                ++notMandatActivFatherNb;
            }
        }
        Iterator<Action> it = null;
        return activableAct;
    }

    public void updateActionAndLinkState(Action act) throws EngineExceptionI {
        ActionGraphLinkI agl;
        Date endDate = act.getEndDate();
        if (endDate == null) {
            endDate = new Date();
        }
        boolean cleanFatherLinks = false;
        Action parent = act;
        if (parent.isDone() || parent.isBindedAndRunning()) {
            Enumeration<ActionGraphLinkI> e2 = parent.lstChildLinks.elements();
            while (e2.hasMoreElements()) {
                agl = e2.nextElement();
                Action child = agl.getActionTarget();
                if (!agl.getLinkStatic().isAnyOrOk()) continue;
                if (parent.isDone()) {
                    if (child.hasSrcBind(parent).booleanValue()) continue;
                    agl.maj();
                    if (!agl.sCondition.bValue) continue;
                    agl.incrementIter();
                    agl.setState(20);
                    continue;
                }
                if (!agl.getLinkStatic().getTarget().isTrgBindedAction()) continue;
                agl.maj();
                if (agl.sCondition.bValue) {
                    agl.incrementIter();
                    agl.setState(1);
                    agl.setDate(endDate);
                    this.getMainEngine().uLog.reportLinkChanges(agl, new Boolean(true), endDate);
                    continue;
                }
                IActionBind ab = agl.getActionTarget().getActionContext().getSrcBind(parent.getActionName());
                ab.modifyConsummation(child.getActionName(), -1);
            }
            if (!(parent.isBindedAndRunning() || parent.isOnError() || parent.isOnWarning())) {
                parent.setActionState(1);
            }
            if (!parent.isBindedAndRunning()) {
                cleanFatherLinks = true;
            }
        } else if (parent.isOnError()) {
            Enumeration<ActionGraphLinkI> e3 = parent.lstChildLinks.elements();
            while (e3.hasMoreElements()) {
                agl = e3.nextElement();
                if (!agl.getLinkStatic().isAnyOrKo()) continue;
                agl.maj();
                if (!agl.sCondition.bValue) continue;
                agl.incrementIter();
                agl.setState(20);
                parent.setIsRedirectedKO(true);
            }
            cleanFatherLinks = true;
        }
        int oldState = -1;
        Enumeration<ActionGraphLinkI> e4 = parent.lstChildLinks.elements();
        while (e4.hasMoreElements()) {
            agl = e4.nextElement();
            if (!agl.getLinkStatic().isAll() || agl.getState() != 20) continue;
            agl.setState(1);
            agl.setDate(endDate);
            if (!agl.sCondition.sOriginScript.isEmpty()) {
                this.getMainEngine().uLog.reportLinkChanges(agl, new Boolean(true), endDate);
                continue;
            }
            this.getMainEngine().uLog.reportLinkChanges(agl, new Boolean(false), endDate);
        }
    }
}

