/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.service;

import com.indy.engine.service.Messages;
import com.indy.engine.service.ServiceState;

public abstract class Service {
    ServiceState state = ServiceState.Stopped;
    long startAt;
    long endAt;

    protected abstract void doStart() throws Exception;

    protected abstract void doStop() throws Exception;

    public void stop() throws Exception {
        if (!this.canBeStopped()) {
            throw new Exception(Messages.getString("Service.0"));
        }
        this._stop();
    }

    public void _stop() throws Exception {
        if (this.state == ServiceState.Stopped) {
            throw new Exception(Messages.getString("Service.1"));
        }
        this.doStop();
        this.state = ServiceState.Stopped;
        this.endAt = System.currentTimeMillis();
        this.handleStopped();
    }

    private void _start() throws Exception {
        if (this.state == ServiceState.Running) {
            throw new Exception(Messages.getString("Service.2"));
        }
        this.doStart();
        this.state = ServiceState.Running;
        this.endAt = 0L;
        this.startAt = System.currentTimeMillis();
        this.handleStarted();
    }

    public void start() throws Exception {
        if (!this.canBeStarted()) {
            throw new Exception(Messages.getString("Service.3"));
        }
        this._start();
    }

    public void restart() throws Exception {
        if (!this.canBeRestarted()) {
            throw new Exception(Messages.getString("Service.4"));
        }
        this._stop();
        this._start();
    }

    public long getDuration() {
        if (this.startAt > 0L) {
            if (this.endAt > 0L) {
                return this.endAt - this.startAt;
            }
            return System.currentTimeMillis() - this.startAt;
        }
        return 0L;
    }

    public String getFormattedDuration() {
        long s = this.getDuration();
        long h = s / 3600000L;
        long m = (s - h * 3600000L) / 60000L;
        long ss = (s - h * 3600000L - m * 60000L) / 1000L;
        long ms = s - h * 3600000L - m * 60000L - ss * 1000L;
        return String.format("%d:%02d:%02d.%02d", h, m, ss, ms);
    }

    public void handleStarted() {
    }

    public void handleStopped() {
    }

    public ServiceState getState() {
        return this.state;
    }

    public abstract String getName();

    public boolean canBeStopped() {
        return this.getState() == ServiceState.Running;
    }

    public boolean canBeStarted() {
        return this.getState() == ServiceState.Stopped;
    }

    public boolean canBeRestarted() {
        return this.getState() == ServiceState.Running;
    }
}

