/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.service;

import com.indy.engine.main.listener.ListenerService;
import com.indy.engine.scheduler.EngineSchedulerI;
import com.indy.engine.service.Messages;
import com.indy.engine.service.Service;
import com.indy.engine.service.ServiceState;
import com.indy.engine.wsdl.SoapService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;

public class ServiceManager {
    public static ServiceManager INSTANCE;
    public static final String schedulerServiceId = "scheduler";
    public static final String httpServiceId = "http";
    public static final String sessionExecutionServiceId = "execution";
    public static final String listenerServiceId = "listener";
    Map<String, Service> map = Collections.synchronizedMap(new HashMap());

    static {
        try {
            INSTANCE = new ServiceManager();
            INSTANCE.registerService(schedulerServiceId, new EngineSchedulerI());
            INSTANCE.registerService(httpServiceId, new SoapService());
            INSTANCE.registerService(listenerServiceId, new ListenerService());
            INSTANCE.registerService(sessionExecutionServiceId, new Service(){

                @Override
                protected void doStart() throws Exception {
                }

                @Override
                protected void doStop() throws Exception {
                }

                @Override
                public String getName() {
                    return ServiceManager.sessionExecutionServiceId;
                }
            });
        }
        catch (Exception e) {
            LogManager.getLogger(ServiceManager.class).warn("Error while initializing service manager", (Throwable)e);
        }
    }

    public Service startService(String id) throws Exception {
        Service service = this.map.get(id);
        if (service == null) {
            throw new Exception(Messages.getString("ServiceManager.0") + id + Messages.getString("ServiceManager.1"));
        }
        service.start();
        return service;
    }

    public List<Service> getServices() {
        return new ArrayList<Service>(this.map.values());
    }

    public void stopService(String id) throws Exception {
        Service service = this.map.get(id);
        if (service == null) {
            throw new Exception(Messages.getString("ServiceManager.2") + id + Messages.getString("ServiceManager.3"));
        }
        service.stop();
    }

    public ServiceState getState(String id) throws Exception {
        Service service = this.map.get(id);
        if (service == null) {
            throw new Exception(Messages.getString("ServiceManager.4") + id + Messages.getString("ServiceManager.5"));
        }
        return service.getState();
    }

    public void registerService(String id, Service service) throws Exception {
        if (this.map.get(id) != null) {
            throw new Exception(Messages.getString("ServiceManager.6"));
        }
        this.map.put(id, service);
    }

    public Service getService(String id) {
        return this.map.get(id);
    }
}

