/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.wsdl;

import com.indy.engine.wsdl.OpenAPI303;
import com.indy.engine.wsdl.Swagger20;
import com.indy.engine.wsdl.WsdlAPI;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class DeliveryRestAPIHelper {
    final Map<String, Catalog> catalogs = Collections.synchronizedMap(new HashMap());

    public Catalog getCatalog(String catalogName) {
        return this.catalogs.get(catalogName);
    }

    public static Catalog initCatalog(CatalogConfiguration configuration) throws Exception {
        String catalogName;
        Catalog catalog = new Catalog();
        catalog.name = catalogName = configuration.properties.get(CatalogConfiguration.CATALOG_NAME);
        Swagger20 swagger = new Swagger20(catalogName, configuration.properties.get(CatalogConfiguration.SWAGGER2_FILE_PATH), configuration.properties.get(CatalogConfiguration.SWAGGER2_BASE_PATH));
        catalog.openAPISpecs.put(Spec.SWAGGER20, swagger);
        OpenAPI303 openAPI = new OpenAPI303(catalogName, configuration.properties.get(CatalogConfiguration.OPENAPI3_FILE_PATH), configuration.properties.get(CatalogConfiguration.OPENAPI3_URL));
        catalog.openAPISpecs.put(Spec.OPENAPI303, openAPI);
        return catalog;
    }

    public void addCatalog(Catalog catalog) {
        this.catalogs.put(catalog.name, catalog);
    }

    public static class Catalog {
        List<WsdlAPI.DeliveryInfo> deliv = Collections.synchronizedList(new ArrayList());
        Map<Spec, IOpenAPISpec> openAPISpecs = new HashMap<Spec, IOpenAPISpec>();
        public String name;

        public void add(WsdlAPI.DeliveryInfo deliveryInfo, Map<String, String> jsonSchemas) {
            this.deliv.add(deliveryInfo);
            this.openAPISpecs.get((Object)Spec.SWAGGER20).addDelivery(deliveryInfo, jsonSchemas);
            this.openAPISpecs.get((Object)Spec.OPENAPI303).addDelivery(deliveryInfo, jsonSchemas);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<WsdlAPI.DeliveryInfo> getDeliveryInfo() {
            ArrayList<WsdlAPI.DeliveryInfo> l = null;
            List<WsdlAPI.DeliveryInfo> list = this.deliv;
            synchronized (list) {
                l = new ArrayList<WsdlAPI.DeliveryInfo>(this.deliv);
            }
            return l;
        }

        public void serializeFile() throws Exception {
            for (Spec spec : this.openAPISpecs.keySet()) {
                this.openAPISpecs.get((Object)spec).serializeFile();
            }
        }

        public IOpenAPISpec getOpenAPISpec(Spec spec) {
            return this.openAPISpecs.get((Object)spec);
        }
    }

    static class CatalogConfiguration {
        static String CATALOG_NAME = "catalogName";
        static String SWAGGER2_FILE_PATH = "swagger2.filePath";
        static String SWAGGER2_BASE_PATH = "swagger2.basePath";
        static String OPENAPI3_FILE_PATH = "openApi3.filePath";
        static String OPENAPI3_URL = "openApi3.url";
        private HashMap<String, String> properties = new HashMap();

        public CatalogConfiguration(String catalogName) {
            this.setProperty(CATALOG_NAME, catalogName);
        }

        public void setProperty(String propertyName, String value) {
            this.properties.put(propertyName, value);
        }
    }

    public static interface IOpenAPISpec {
        public Object getDefinition();

        public String getFileName();

        public void addDelivery(WsdlAPI.DeliveryInfo var1, Map<String, String> var2);

        public void serializeFile() throws IllegalArgumentException, FileNotFoundException, IllegalAccessException, XMLStreamException;
    }

    public static enum Spec {
        SWAGGER20,
        OPENAPI303;

    }
}

