/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.wsdl;

import com.indy.engine.Global;
import com.indy.engine.common.swagger2.IOpenAPI;
import com.indy.engine.common.swagger2.OpenAPIDefinition303;
import com.indy.engine.delivery.Delivery;
import com.indy.engine.wsdl.DeliveryRestAPIHelper;
import com.indy.engine.wsdl.WsdlAPI;
import com.indy.runtime.wsdl.HttpRestDeliveryProperties;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenAPI303
implements DeliveryRestAPIHelper.IOpenAPISpec {
    private final Logger logger = LogManager.getLogger(OpenAPI303.class);
    OpenAPIDefinition303 openAPIDef;
    String filePath;
    Map<String, WsdlAPI.DeliveryInfo> list = new HashMap<String, WsdlAPI.DeliveryInfo>();

    OpenAPI303(String catalogName, String filePath, String url) {
        this.openAPIDef = new OpenAPIDefinition303(url, Global.hasUser());
        this.filePath = filePath;
        OpenAPIDefinition303.Info info = this.openAPIDef.getInfo();
        info.description = "description";
        info.title = catalogName;
        info.version = "version";
    }

    @Override
    public void addDelivery(WsdlAPI.DeliveryInfo deliv, Map<String, String> jsonSchemas) {
        try {
            this.list.put(deliv.deliv.getName(), deliv);
            ArrayList<String> methods = new ArrayList<String>();
            HashSet tags = new HashSet();
            Object _path = "/" + deliv.name;
            boolean form = false;
            String rct = null;
            if (deliv.deliv.getHttpRestDeliveryProperties() != null) {
                rct = deliv.deliv.getHttpRestDeliveryProperties().getRequestContentType();
                if (rct != null && rct.equals("application/x-www-form-urlencoded")) {
                    form = true;
                }
                methods.addAll(deliv.deliv.getHttpRestDeliveryProperties().getMethods());
                if (deliv.deliv.getHttpRestDeliveryProperties().getPathTemplate() != null && !((String)(_path = deliv.deliv.getHttpRestDeliveryProperties().getPathTemplate())).startsWith("/")) {
                    _path = "/" + (String)_path;
                }
                tags.addAll(deliv.deliv.getHttpRestDeliveryProperties().getTags());
            }
            if (methods.isEmpty()) {
                if (deliv.deliv.getInputType() != Delivery.InOutType.nothing || form) {
                    methods.add("post");
                } else {
                    methods.add("get");
                }
            }
            OpenAPIDefinition303.Path path = this.openAPIDef.newPath((String)_path);
            for (String meth : methods) {
                OpenAPIDefinition303.Method method = path.newMethod(meth);
                if (methods.size() > 1) {
                    method.setOperationId(IOpenAPI.computeName((String)(deliv.name + "_" + meth)));
                } else {
                    method.setOperationId(IOpenAPI.computeName((String)deliv.name));
                }
                method.addTags(tags);
                if (deliv.deliv.isExternalized()) {
                    OpenAPIDefinition303.Parameter param = method.newParameter("X-Delivery-Configuration-Name");
                    if (deliv.deliv.getConfigurationCode() != null) {
                        param.setEnumValues(Arrays.asList(deliv.deliv.getConfigurationCode().split(" ")));
                    }
                    param.setType("string");
                    param.setIn("header");
                    param.required = true;
                }
                for (Map.Entry<String, Delivery.Parameter> entry : deliv.deliv.getParameters().entrySet()) {
                    if (entry.getValue().isInput()) {
                        HttpRestDeliveryProperties.ParameterReplacement pr;
                        String in = "query";
                        boolean required = false;
                        String name = entry.getKey();
                        HttpRestDeliveryProperties.ParameterReplacement parameterReplacement = pr = deliv.deliv.getHttpRestDeliveryProperties() != null ? deliv.deliv.getHttpRestDeliveryProperties().getParameterReplacement(name) : null;
                        if (pr != null) {
                            in = "path";
                            required = true;
                        } else {
                            HttpRestDeliveryProperties.RequestParameterHeader rrh;
                            HttpRestDeliveryProperties.RequestParameterHeader requestParameterHeader = rrh = deliv.deliv.getHttpRestDeliveryProperties() != null ? deliv.deliv.getHttpRestDeliveryProperties().getInputHeaderParameterName(name) : null;
                            if (rrh != null) {
                                name = rrh.getHeaderName();
                                in = "header";
                            } else if (form) {
                                in = "formData";
                            }
                        }
                        OpenAPIDefinition303.Parameter param = method.newParameter(name);
                        param.setType(entry.getValue().getType().toLowerCase());
                        param.setIn(in);
                        param.required = required;
                        continue;
                    }
                    entry.getValue().isOutput();
                }
                boolean bResponse = false;
                for (Delivery.Route route : deliv.deliv.getRoutes()) {
                    Delivery.Parameter p;
                    String name;
                    OpenAPIDefinition303.Response response;
                    String jsonSchema = jsonSchemas.get(route.getCheckSum());
                    if (route.isInput()) {
                        String mediaType = rct;
                        if (mediaType == null) {
                            switch (deliv.deliv.getInputType()) {
                                case json: 
                                case other: 
                                case mix: {
                                    mediaType = "application/json";
                                    break;
                                }
                                case xsd: {
                                    mediaType = "text/xml";
                                    break;
                                }
                            }
                        }
                        if (jsonSchema != null) {
                            String name2 = this.openAPIDef.newRawDefinition((String)route.getElementName(), (String)route.getCheckSum(), (String)jsonSchema).name;
                            method.getRequest().addMediaType(mediaType, name2);
                        } else {
                            method.getRequest().addMediaType(mediaType);
                        }
                    }
                    List outputHeaders = null;
                    if (deliv.deliv.getHttpRestDeliveryProperties() != null) {
                        outputHeaders = deliv.deliv.getHttpRestDeliveryProperties().getOutputHeaderMapper();
                    }
                    if (route.isOutput()) {
                        response = method.newResponse("200");
                        response.description = "200 response";
                        bResponse = true;
                        if (jsonSchema != null) {
                            name = this.openAPIDef.newRawDefinition((String)route.getElementName(), (String)route.getCheckSum(), (String)jsonSchema).name;
                            response.newSchemaRef("application/json", name);
                        } else {
                            response.newSchema(route.getInternetMediaType());
                        }
                        if ((route.isOutput() || route.isFault()) && outputHeaders != null) {
                            for (HttpRestDeliveryProperties.ResponseParameterHeader h : deliv.deliv.getHttpRestDeliveryProperties().getOutputHeaderMapper()) {
                                p = deliv.deliv.getParameters().get(h.getParameterName());
                                response.addHeader(h.getHeaderName(), p == null ? null : p.getType());
                            }
                        }
                    }
                    if (!route.isFault()) continue;
                    response = method.newResponse("default");
                    response.description = "default response";
                    bResponse = true;
                    if (jsonSchema != null) {
                        name = this.openAPIDef.newRawDefinition((String)route.getElementName(), (String)route.getCheckSum(), (String)jsonSchema).name;
                        response.newSchemaRef("application/json", name);
                    } else {
                        response.newSchema(route.getInternetMediaType());
                    }
                    if (!route.isOutput() && !route.isFault() || outputHeaders == null) continue;
                    for (HttpRestDeliveryProperties.ResponseParameterHeader h : deliv.deliv.getHttpRestDeliveryProperties().getOutputHeaderMapper()) {
                        p = deliv.deliv.getParameters().get(h.getParameterName());
                        response.addHeader(h.getHeaderName(), p == null ? null : p.getType());
                    }
                }
                if (bResponse) continue;
                OpenAPIDefinition303.Response response = method.newResponse("default");
                response.description = "default response";
            }
        }
        catch (Exception e) {
            this.logger.warn("Error while generating swagger 2.0 definition", (Throwable)e);
        }
    }

    @Override
    public void serializeFile() throws IllegalArgumentException, FileNotFoundException, IllegalAccessException, XMLStreamException {
        this.openAPIDef.writeFile(this.filePath);
    }

    @Override
    public Object getDefinition() {
        return this.openAPIDef;
    }

    @Override
    public String getFileName() {
        return new File(this.filePath).getName();
    }
}

