/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.httpserver;

import com.indy.engine.core.common.CommonUtils;
import com.indy.engine.delivery.Delivery;
import com.indy.engine.wsdl.InvocationRest;
import com.indy.engine.wsdl.Messages;
import com.indy.runtime.wsdl.HttpRestDeliveryProperties;
import com.semarchy.xdi.runtime.httpserver.DeliveryRestServlet2;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;

public class RestInvocationHandler {
    private Logger logger = LogManager.getLogger(RestInvocationHandler.class);
    private HttpServletRequest req;
    protected HttpServletResponse resp;
    private List<String> parts;
    private boolean urlEncoded;
    private String[] outputInternetMediaType = new String[1];

    RestInvocationHandler(HttpServletRequest req, HttpServletResponse resp, List<String> parts, boolean urlEncoded) {
        this.req = req;
        this.resp = resp;
        this.parts = parts;
        this.urlEncoded = urlEncoded;
    }

    public void handleDone(InvocationRest invocation) throws IOException {
        if (!invocation.isAsynchronous()) {
            this.doHandleDone(invocation);
        } else {
            this.doHandleDoneAsync();
        }
    }

    void doHandleDoneAsync() {
        this.resp.setStatus(HttpStatus.OK.value());
    }

    void doHandleDone(InvocationRest invocation) throws IOException {
        String str = DeliveryRestServlet2.encode(invocation.getParametersValues(), "UTF-8");
        if (this.outputInternetMediaType[0] != null) {
            this.resp.setHeader("Content-Type", this.outputInternetMediaType[0]);
        }
        if (invocation.getOutputHeaderValues() != null) {
            for (Map.Entry<String, String> entry : invocation.getOutputHeaderValues().entrySet()) {
                this.resp.setHeader(entry.getKey(), entry.getValue());
            }
        }
        if (invocation.getResponseCode() != null) {
            this.resp.setStatus(invocation.getResponseCode().intValue());
        } else if (invocation.getSessionStatus() == 1) {
            this.resp.setStatus(HttpStatus.OK.value());
        } else {
            this.resp.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        }
        if (str != null) {
            this.resp.getOutputStream().write(str.getBytes());
        }
        if (invocation.getResponseBodyValue() != null) {
            this.resp.getOutputStream().write(invocation.getResponseBodyValue());
        }
    }

    public void handleDeliveryFound(Delivery delivery, Map<String, String> handleUrlReplacementParams) throws IOException {
        HttpRestDeliveryProperties hrdp = delivery.getHttpRestDeliveryProperties();
        if (hrdp != null && hrdp.extractRequestInf()) {
            this.extractRequestInformation(handleUrlReplacementParams);
        }
        if (hrdp != null && hrdp.getRequestBodyMapper() != null) {
            this.handleBodyMapper(handleUrlReplacementParams, hrdp);
        }
        this.handleUrlParts(handleUrlReplacementParams, hrdp);
        HashSet<String> touch = new HashSet<String>();
        if (hrdp != null && hrdp.getInputHeaderMapper() != null) {
            this.replaceHeaders(handleUrlReplacementParams, hrdp, touch);
        }
        if (this.req.getHeaderNames() != null && hrdp != null && hrdp.extractRequestInf()) {
            this.addHeaderVariables(handleUrlReplacementParams, touch);
        }
        this.outputInternetMediaType[0] = delivery.getFirstOutputInternetMediaType();
        int inputNb = this.countInputs(delivery);
        int outputNb = this.countResourceOutputs(delivery);
        int outputNb2 = this.countParamOutputs(delivery);
        if (outputNb > 1) {
            throw new IOException(Messages.getString("HttpRestEndpoint02.5") + delivery.getName() + Messages.getString("HttpRestEndpoint02.6"));
        }
        if (inputNb > 1) {
            throw new IOException(Messages.getString("HttpRestEndpoint02.7") + delivery.getName() + Messages.getString("HttpRestEndpoint02.8"));
        }
        if (outputNb > 0 && outputNb2 > 0) {
            throw new IOException(Messages.getString("HttpRestEndpoint02.9") + delivery.getName() + Messages.getString("HttpRestEndpoint02.10"));
        }
        if (this.urlEncoded && inputNb > 0) {
            throw new IOException(Messages.getString("HttpRestEndpoint02.11") + delivery.getName() + Messages.getString("HttpRestEndpoint02.12"));
        }
    }

    private int countParamOutputs(Delivery delivery) {
        int outputNb2 = 0;
        for (Delivery.Parameter param : delivery.getParameters().values()) {
            if (!param.isOutput()) continue;
            ++outputNb2;
        }
        return outputNb2;
    }

    private int countResourceOutputs(Delivery delivery) {
        int outputNb = 0;
        for (Delivery.Route rt : delivery.getRoutes()) {
            if (!rt.isOutput()) continue;
            ++outputNb;
        }
        return outputNb;
    }

    private int countInputs(Delivery delivery) {
        int inputNb = 0;
        for (Delivery.Route rt : delivery.getRoutes()) {
            if (!rt.isInput()) continue;
            ++inputNb;
        }
        return inputNb;
    }

    private void addHeaderVariables(Map<String, String> handleUrlReplacementParams, Set<String> touch) {
        for (String s : Collections.list(this.req.getHeaderNames())) {
            ArrayList l;
            if (this.req.getHeaders(s) == null || touch.contains(s) || this.req.getHeaders(s) == null || (l = Collections.list(this.req.getHeaders(s))).isEmpty()) continue;
            handleUrlReplacementParams.put("~/CORE_HTTP_REQUEST_HEADER_" + s.toUpperCase(), (String)l.get(0));
        }
    }

    private void replaceHeaders(Map<String, String> handleUrlReplacementParams, HttpRestDeliveryProperties hrdp, Set<String> touch) {
        HashMap requestHeaders = new HashMap();
        Enumeration headerNames = this.req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            requestHeaders.put(name.toUpperCase(), Collections.list(this.req.getHeaders(name)));
        }
        for (HttpRestDeliveryProperties.RequestParameterHeader param : hrdp.getInputHeaderMapper()) {
            List values = (List)requestHeaders.get(param.getHeaderName().toUpperCase());
            if (values != null && !values.isEmpty()) {
                touch.add(param.getHeaderName());
                handleUrlReplacementParams.put("~/" + param.getParameterName(), (String)values.get(0));
                continue;
            }
            if (param.getValue() == null) continue;
            handleUrlReplacementParams.put("~/" + param.getParameterName(), param.getValue());
        }
    }

    private void handleUrlParts(Map<String, String> handleUrlReplacementParams, HttpRestDeliveryProperties hrdp) {
        HashSet<Integer> touch1 = new HashSet<Integer>();
        if (this.parts.size() > 1) {
            if (hrdp != null && hrdp.getParameterReplacement() != null) {
                this.replaceUrlParts(handleUrlReplacementParams, hrdp, touch1);
            }
            int i = 0;
            while (i < this.parts.size()) {
                if (!touch1.contains(i)) {
                    handleUrlReplacementParams.put(String.format("~/CORE_HTTP_REQUEST_URL_PART_%s", i + 1), this.parts.get(i));
                }
                ++i;
            }
        }
    }

    private void replaceUrlParts(Map<String, String> handleUrlReplacementParams, HttpRestDeliveryProperties hrdp, Set<Integer> touch1) {
        for (HttpRestDeliveryProperties.ParameterReplacement pr : hrdp.getParameterReplacement()) {
            int index = pr.getPosition();
            String replacement = pr.getName();
            String str = null;
            str = this.parts.size() > index ? this.parts.get(index) : pr.getValue();
            if (replacement == null || str == null) continue;
            touch1.add(index);
            handleUrlReplacementParams.put("~/" + replacement, str);
        }
    }

    private void handleBodyMapper(Map<String, String> handleUrlReplacementParams, HttpRestDeliveryProperties hrdp) throws IOException {
        HttpRestDeliveryProperties.BodyMapper bm = hrdp.getRequestBodyMapper();
        if (bm != null) {
            String inputStr = CommonUtils.inputStreamToString((InputStream)this.req.getInputStream(), (String)bm.getCharset());
            if (inputStr == null || inputStr.isEmpty()) {
                inputStr = bm.getValue();
            }
            if (inputStr != null) {
                handleUrlReplacementParams.put("~/" + bm.getParameterName(), inputStr);
            }
        }
    }

    private void extractRequestInformation(Map<String, String> handleUrlReplacementParams) {
        handleUrlReplacementParams.put("~/CORE_HTTP_REQUEST_URL", this.req.getContextPath() + this.req.getServletPath() + this.req.getPathInfo());
        try {
            handleUrlReplacementParams.put("~/CORE_HTTP_REMOTE_HOST_NAME", this.req.getRemoteHost());
            handleUrlReplacementParams.put("~/CORE_HTTP_REMOTE_HOST_ADDRESS", this.req.getRemoteAddr());
            if (this.req.getUserPrincipal() != null) {
                handleUrlReplacementParams.put("~/CORE_HTTP_USER_NAME", this.req.getUserPrincipal().getName());
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to replace CORE_HTTP_ parameter", (Throwable)e);
        }
    }
}

