/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.httpserver.api.v1.delivery;

import com.indy.engine.Global;
import com.indy.engine.core.repository.IDeliveryRepositoryPlugin;
import com.indy.engine.delivery.Delivery;
import com.indy.engine.main.repository.IDeliveryRepository;
import com.semarchy.xdi.runtime.httpserver.HttpErrorHandler;
import com.semarchy.xdi.runtime.httpserver.api.v1.delivery.Messages;
import com.semarchy.xdi.runtime.httpserver.api.v1.exception.ResourceAlreadyExistException;
import com.semarchy.xdi.runtime.httpserver.api.v1.exception.ResourceNotFoundException;
import com.semarchy.xdi.runtime.httpserver.api.v1.utils.StringSanitizer;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/1/deliveries"})
public class DeliveryController {
    private static final String EMPTY_STRING = "";
    private static final HttpErrorHandler errorHandler = new HttpErrorHandler();
    private static final String TECHNICAL_ERROR_MESSAGE = "DeliveryController_Technical_Error";
    private static final String DELIVERY_NOT_FOUND_ERROR_MESSAGE = "DeliveryController_Delivery_Not_Found";
    private static final String PATH_SEPARATOR = "/";

    @GetMapping
    public DeliveriesAPI getDeliveries(@Nullable @RequestParam String repository, HttpServletResponse response) {
        try {
            ArrayList<Delivery> deliveryList = new ArrayList<Delivery>();
            IDeliveryRepository deliveryRepository = this.getRepositoryByName(repository);
            List<String> deliveryNameList = deliveryRepository.getLstDeliveries(null);
            for (String deliveryName : deliveryNameList) {
                deliveryList.add(deliveryRepository.getDelivery(deliveryName, true));
            }
            return new DeliveriesAPI(Messages.getString("DeliveryController_Description"), deliveryRepository.getName(), this.adapt(deliveryList));
        }
        catch (ResourceNotFoundException e) {
            this.handleError(HttpStatus.NOT_FOUND.value(), EMPTY_STRING, e, response);
        }
        catch (Exception e) {
            this.handleError(HttpStatus.INTERNAL_SERVER_ERROR.value(), Messages.getString(TECHNICAL_ERROR_MESSAGE), e, response);
        }
        return null;
    }

    @GetMapping(value={"/{name}"})
    public DeliveriesAPI getDeliveryByName(@PathVariable(value="name") String name, @Nullable @RequestParam String repository, @Nullable @RequestParam String path, HttpServletResponse response) {
        try {
            StringSanitizer.normalizeAndSanitize(name);
            StringSanitizer.normalizeAndSanitize(repository);
            StringSanitizer.normalizeAndSanitize(path);
            ArrayList<Delivery> deliveryList = new ArrayList<Delivery>();
            IDeliveryRepository deliveryRepository = this.getRepositoryByName(repository);
            String deliveryPath = this.handlePath(path);
            String fullDeliveryPath = deliveryPath + name;
            if (deliveryRepository.exists(deliveryPath + name)) {
                deliveryList.add(deliveryRepository.getDelivery(fullDeliveryPath, true));
            } else {
                this.handleError(HttpStatus.NOT_FOUND.value(), EMPTY_STRING, new ResourceNotFoundException(String.format(Messages.getString(DELIVERY_NOT_FOUND_ERROR_MESSAGE), fullDeliveryPath)), response);
            }
            return new DeliveriesAPI(Messages.getString("DeliveryController_Description"), deliveryRepository.getName(), this.adapt(deliveryList));
        }
        catch (ResourceNotFoundException e) {
            this.handleError(HttpStatus.NOT_FOUND.value(), e.getMessage(), e, response);
        }
        catch (Exception e) {
            this.handleError(HttpStatus.INTERNAL_SERVER_ERROR.value(), Messages.getString(TECHNICAL_ERROR_MESSAGE), e, response);
        }
        return null;
    }

    @PostMapping(value={"/{name}"}, consumes={"application/octet-stream"})
    public DeliveryInfoAPI postNewDelivery(@PathVariable(value="name") String name, @Nullable @RequestParam String path, @RequestBody byte[] deliveryData, @Nullable @RequestParam String repository, @Nullable @RequestParam Boolean overwrite, HttpServletResponse response) {
        try {
            StringSanitizer.normalizeAndSanitize(name);
            StringSanitizer.normalizeAndSanitize(repository);
            StringSanitizer.normalizeAndSanitize(path);
            IDeliveryRepository deliveryRepository = this.getRepositoryByName(repository);
            String deliveryPath = this.handlePath(path);
            String fullDeliveryPath = deliveryPath + name;
            if (!deliveryRepository.exists(fullDeliveryPath) || Boolean.TRUE.equals(overwrite)) {
                Throwable throwable = null;
                Object var11_14 = null;
                try (ByteArrayInputStream is = new ByteArrayInputStream(deliveryData);){
                    IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo = deliveryRepository.putDelivery(is, fullDeliveryPath);
                    return new DeliveryInfoAPI(deliveryInfo.getName(), deliveryInfo.getVersion(), deliveryInfo.getId(), deliveryInfo.getLastModified());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.handleError(HttpStatus.CONFLICT.value(), EMPTY_STRING, new ResourceAlreadyExistException(String.format(Messages.getString("DeliveryController_Delivery_Already_Exist"), fullDeliveryPath)), response);
        }
        catch (ResourceNotFoundException e) {
            this.handleError(HttpStatus.NOT_FOUND.value(), EMPTY_STRING, e, response);
        }
        catch (Exception e) {
            this.handleError(HttpStatus.INTERNAL_SERVER_ERROR.value(), Messages.getString(TECHNICAL_ERROR_MESSAGE), e, response);
        }
        return null;
    }

    @PutMapping(value={"/{name}"}, consumes={"application/octet-stream"})
    public DeliveryInfoAPI updateDelivery(@PathVariable(value="name") String name, @RequestBody byte[] deliveryData, @Nullable @RequestParam String repository, @Nullable @RequestParam String path, HttpServletResponse response) {
        try {
            StringSanitizer.normalizeAndSanitize(name);
            StringSanitizer.normalizeAndSanitize(repository);
            StringSanitizer.normalizeAndSanitize(path);
            IDeliveryRepository deliveryRepository = this.getRepositoryByName(repository);
            String deliveryPath = this.handlePath(path);
            String fullDeliveryPath = deliveryPath + name;
            if (deliveryRepository.exists(fullDeliveryPath)) {
                Throwable throwable = null;
                Object var10_13 = null;
                try (ByteArrayInputStream is = new ByteArrayInputStream(deliveryData);){
                    IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo = deliveryRepository.putDelivery(is, fullDeliveryPath);
                    return new DeliveryInfoAPI(deliveryInfo.getName(), deliveryInfo.getVersion(), deliveryInfo.getId(), deliveryInfo.getLastModified());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.handleError(HttpStatus.NOT_FOUND.value(), EMPTY_STRING, new ResourceNotFoundException(String.format(Messages.getString(DELIVERY_NOT_FOUND_ERROR_MESSAGE), fullDeliveryPath)), response);
        }
        catch (ResourceNotFoundException e) {
            this.handleError(HttpStatus.NOT_FOUND.value(), EMPTY_STRING, e, response);
        }
        catch (Exception e) {
            this.handleError(HttpStatus.INTERNAL_SERVER_ERROR.value(), Messages.getString(TECHNICAL_ERROR_MESSAGE), e, response);
        }
        return null;
    }

    @DeleteMapping(value={"/{name}"})
    public void deleteDelivy(@PathVariable(value="name") String name, @Nullable @RequestParam String repository, @Nullable @RequestParam String path, HttpServletResponse response) {
        try {
            StringSanitizer.normalizeAndSanitize(name);
            StringSanitizer.normalizeAndSanitize(repository);
            StringSanitizer.normalizeAndSanitize(path);
            IDeliveryRepository deliveryRepository = this.getRepositoryByName(repository);
            String deliveryPath = this.handlePath(path);
            String fullDeliveryPath = deliveryPath + name;
            if (deliveryRepository.exists(fullDeliveryPath)) {
                deliveryRepository.removeDelivery(fullDeliveryPath);
            } else {
                this.handleError(HttpStatus.NOT_FOUND.value(), EMPTY_STRING, new ResourceNotFoundException(String.format(Messages.getString(DELIVERY_NOT_FOUND_ERROR_MESSAGE), name)), response);
            }
        }
        catch (ResourceNotFoundException e) {
            this.handleError(HttpStatus.NOT_FOUND.value(), e.getMessage(), e, response);
        }
        catch (Exception e) {
            this.handleError(HttpStatus.INTERNAL_SERVER_ERROR.value(), Messages.getString(TECHNICAL_ERROR_MESSAGE), e, response);
        }
    }

    protected void handleError(int httpErrorCode, String message, Exception t, HttpServletResponse response) {
        Consumer<String> errorConsumer = errorMessage -> {
            try {
                response.sendError(httpErrorCode, errorMessage);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        errorHandler.handleError(message, t, errorConsumer);
    }

    private IDeliveryRepository getRepositoryByName(String repositoryName) throws ResourceNotFoundException {
        IDeliveryRepository repository;
        try {
            repository = Global.getRepository(repositoryName);
        }
        catch (Exception e) {
            throw new ResourceNotFoundException(String.format(Messages.getString("DeliveryController_Repository_Not_Found"), repositoryName));
        }
        return repository;
    }

    private String handlePath(String path) {
        Object deliveryPath;
        if (path != null) {
            deliveryPath = path;
            if (((String)deliveryPath).startsWith(PATH_SEPARATOR)) {
                deliveryPath = path.substring(1);
            }
            if (!((String)deliveryPath).endsWith(PATH_SEPARATOR)) {
                deliveryPath = (String)deliveryPath + PATH_SEPARATOR;
            }
        } else {
            deliveryPath = EMPTY_STRING;
        }
        return deliveryPath;
    }

    private List<DeliveryAPI> adapt(List<Delivery> deliveryList) {
        ArrayList<DeliveryAPI> deliveryAPIList = new ArrayList<DeliveryAPI>();
        for (Delivery delivery : deliveryList) {
            DeliveryAPI deliveryAPI = new DeliveryAPI();
            deliveryAPI.setIdentifier(delivery.getId());
            deliveryAPI.setName(delivery.getName());
            deliveryAPI.setBuildDate(delivery.getBuildDate());
            deliveryAPI.setBuildUser(delivery.getBuildUser());
            deliveryAPI.setConfigurationCode(delivery.getConfigurationCode());
            deliveryAPIList.add(deliveryAPI);
        }
        return deliveryAPIList;
    }

    public record DeliveriesAPI(String description, String repository, List<DeliveryAPI> deliveries) {
    }

    public class DeliveryAPI {
        private String identifier;
        private String name;
        private String buildUser;
        private Date buildDate;
        private String configurationCode;

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public String getBuildUser() {
            return this.buildUser;
        }

        public void setBuildUser(String buildUser) {
            this.buildUser = buildUser;
        }

        public Date getBuildDate() {
            return this.buildDate;
        }

        public void setBuildDate(Date buildDate) {
            this.buildDate = buildDate;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getConfigurationCode() {
            return this.configurationCode;
        }

        public void setConfigurationCode(String configurationCode) {
            this.configurationCode = configurationCode;
        }
    }

    public record DeliveryAttributeAPI(String value) {
    }

    public record DeliveryInfoAPI(String name, String version, String id, long lastModified) {
    }
}

