/*
 * Decompiled with CFR 0.152.
 */
package com.indy.a.encryptors;

import com.semarchy.xdi.engine.common.exceptions.OtherExceptionI;
import jakarta.xml.bind.DatatypeConverter;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CipherEncryptor {
    private final Logger logger = LogManager.getLogger(this.getClass());
    public static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public void crypt(InputStream in, OutputStream out, Cipher cipher) throws OtherExceptionI {
        try {
            int blockSize = cipher.getBlockSize();
            int outputSize = cipher.getOutputSize(blockSize);
            byte[] inBytes = new byte[blockSize];
            byte[] outBytes = new byte[outputSize];
            int inLength = 0;
            boolean done = false;
            while (!done) {
                inLength = in.read(inBytes);
                if (inLength == blockSize) {
                    try {
                        int outLength = cipher.update(inBytes, 0, blockSize, outBytes);
                        out.write(outBytes, 0, outLength);
                    }
                    catch (ShortBufferException e) {
                        this.logger.warn("unexpected", (Throwable)e);
                    }
                    continue;
                }
                done = true;
            }
            try {
                outBytes = inLength > 0 ? cipher.doFinal(inBytes, 0, inLength) : cipher.doFinal();
                out.write(outBytes);
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                throw new OtherExceptionI((Throwable)e);
            }
        }
        catch (Exception e) {
            throw new OtherExceptionI((Throwable)e);
        }
    }

    public String arrayByteToHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        int i = 0;
        while (i < b.length) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
            ++i;
        }
        return sb.toString();
    }

    public byte[] hexStringToArrayByte(String hexStr) {
        return DatatypeConverter.parseHexBinary((String)hexStr);
    }

    public String cryptedBytesToString(byte[] hash) throws OtherExceptionI {
        try {
            StringBuilder hashString = new StringBuilder();
            int i = 0;
            while (i < hash.length) {
                String hex = Integer.toHexString(hash[i]);
                if (hex.length() == 1) {
                    hashString.append('0');
                    hashString.append(hex.charAt(hex.length() - 1));
                } else {
                    hashString.append(hex.substring(hex.length() - 2));
                }
                ++i;
            }
            return hashString.toString();
        }
        catch (Exception e) {
            throw new OtherExceptionI((Throwable)e);
        }
    }

    public byte[] cryptedStringToBytes(String hash) {
        BigInteger bi = new BigInteger(hash, 16);
        return bi.toByteArray();
    }
}

