/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.jvm;

import com.semarchy.xdi.engine.common.CommonUtils;
import jakarta.xml.bind.JAXB;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@XmlRootElement(name="javaProperties")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JavaConfiguration {
    private static Logger logger = LogManager.getLogger(JavaConfiguration.class);
    @XmlElement(name="property")
    private List<JvmProperty> properties;
    boolean already = false;

    public static JavaConfiguration getJavaConfiguration(File file) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        try (FileInputStream is = null;){
            is = new FileInputStream(file);
            JavaConfiguration javaConfiguration = JavaConfiguration.getJavaConfiguration(is);
            return javaConfiguration;
        }
    }

    public static JavaConfiguration getJavaConfiguration(InputStream is) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        return (JavaConfiguration)JAXB.unmarshal((InputStream)is, JavaConfiguration.class);
    }

    public static JavaConfiguration getJavaConfiguration(Node node) throws TransformerFactoryConfigurationError, TransformerException, IOException {
        Transformer transformer = CommonUtils.getSafeTransformer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, Charset.defaultCharset());
        transformer.transform(new DOMSource(node), new StreamResult(osw));
        osw.close();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        InputStreamReader isr = new InputStreamReader((InputStream)bais, Charset.defaultCharset());
        return (JavaConfiguration)JAXB.unmarshal((Reader)isr, JavaConfiguration.class);
    }

    public void configure() {
        if (!this.already) {
            this.already = true;
            if (this.properties != null) {
                for (JvmProperty prop : this.properties) {
                    if (prop.name == null || prop.value == null) continue;
                    System.setProperty(prop.name, prop.value);
                }
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class JvmProperty {
        @XmlAttribute(name="name", required=true)
        private String name;
        @XmlAttribute(name="value", required=false)
        private String value;
    }
}

