/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.keystore;

import com.semarchy.xdi.engine.common.CommonUtils;
import jakarta.xml.bind.JAXB;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@XmlRootElement(name="sslContext")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SslContextConfiguration {
    private static Logger logger = LogManager.getLogger(SslContextConfiguration.class);
    @XmlElement(name="truststore")
    public Truststore truststore;
    @XmlElement(name="keystore")
    public Keystore keystore;
    boolean init = false;

    public static SslContextConfiguration getSslContextConfiguration(Node node) throws TransformerFactoryConfigurationError, TransformerException, IOException {
        Transformer transformer = CommonUtils.getSafeTransformer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, Charset.defaultCharset());
        transformer.transform(new DOMSource(node), new StreamResult(osw));
        osw.close();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        InputStreamReader isr = new InputStreamReader((InputStream)bais, Charset.defaultCharset());
        return (SslContextConfiguration)JAXB.unmarshal((Reader)isr, SslContextConfiguration.class);
    }

    public static SslContextConfiguration getSslContextConfiguration(File file) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        try (FileInputStream is = null;){
            is = new FileInputStream(file);
            SslContextConfiguration sslContextConfiguration = SslContextConfiguration.getSslContextConfiguration(is);
            return sslContextConfiguration;
        }
    }

    public static SslContextConfiguration getSslContextConfiguration(InputStream is) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        return (SslContextConfiguration)JAXB.unmarshal((InputStream)is, SslContextConfiguration.class);
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Keystore {
        @XmlAttribute(name="path", required=true)
        private String path;
        @XmlAttribute(name="uncryptedPassword", required=false)
        private String uncryptedPassword;

        public String getPassword() {
            return this.uncryptedPassword;
        }

        public String getPath() {
            return this.path;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Truststore {
        @XmlAttribute(name="path", required=true)
        private String path;
        @XmlAttribute(name="uncryptedPassword", required=false)
        private String uncryptedPassword;

        public String getPassword() {
            return this.uncryptedPassword;
        }

        public String getPath() {
            return this.path;
        }
    }
}

