/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.queue.impl;

import com.indy.engine.common.queue.impl.Messages;
import com.indy.engine.core.queue.IQueueConsumer;
import com.indy.engine.core.queue.IQueueProducer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class FileQueue<E>
implements IQueueProducer<E> {
    File folder;
    long size = 0L;
    List<E> buffer = Collections.synchronizedList(new ArrayList());
    int bufferSize = 1000;
    long lastMinOffset = 0L;
    boolean end;
    List<Consumer> consumers = new ArrayList<Consumer>();
    long endOffset;

    public FileQueue(File parent, String queueName) {
        this.folder = new File(parent, queueName);
        this.folder.mkdirs();
        this.folder.deleteOnExit();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void serialize(Object elt) throws IOException {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                FileOutputStream fout = new FileOutputStream(new File(this.folder, String.valueOf(this.size + 1L)));
                try {
                    try (ObjectOutputStream oos = new ObjectOutputStream(fout);){
                        oos.writeObject(elt);
                    }
                    if (fout == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fout == null) throw throwable;
                    fout.close();
                    throw throwable;
                }
                fout.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        finally {
            ++this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized void put(E elt) throws IOException {
        try {
            if (this.size < (long)this.bufferSize) {
                this.buffer.add(elt);
                ++this.size;
            }
            this.serialize(elt);
        }
        finally {
            var4_4 = this.consumers.iterator();
            ** while (var4_4.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            var5_8 = consumer = var4_4.next();
            synchronized (var5_8) {
                consumer.notifyAll();
                continue;
            }
        }
lbl19:
        // 1 sources

    }

    private synchronized void deleteFiles() {
        long minOffset = Long.MAX_VALUE;
        for (Consumer consumer : this.consumers) {
            if (consumer.offset >= minOffset) continue;
            minOffset = consumer.offset;
        }
        if (minOffset != Long.MAX_VALUE && minOffset != this.lastMinOffset) {
            long l = this.lastMinOffset + 1L;
            while (l <= minOffset) {
                File file = new File(this.folder, "" + l);
                file.delete();
                ++l;
            }
            this.lastMinOffset = minOffset;
        }
    }

    public Consumer<E> createConsumer() {
        Consumer cons = new Consumer();
        this.consumers.add(cons);
        return cons;
    }

    /*
     * Loose catch block
     */
    private Object get(long position) throws IOException, ClassNotFoundException {
        if (position <= (long)this.buffer.size()) {
            return this.buffer.get((int)position - 1);
        }
        File file = new File(this.folder, String.valueOf(position));
        Throwable throwable = null;
        Object var5_5 = null;
        try {
            Object object;
            ObjectInputStream oos;
            FileInputStream fin;
            block17: {
                block16: {
                    fin = new FileInputStream(file);
                    oos = new ObjectInputStream(fin);
                    object = oos.readObject();
                    if (oos == null) break block16;
                    oos.close();
                }
                if (fin == null) break block17;
                fin.close();
            }
            return object;
            {
                catch (Throwable throwable2) {
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (fin != null) {
                            fin.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public synchronized void close() throws IOException {
        this.deleteFiles();
        if (!this.folder.delete()) {
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized void putAll(Collection<E> t) throws InterruptedException, IOException {
        if (t.isEmpty()) {
            throw new IOException(Messages.getString("FileQueue.1"));
        }
        try {
            if (this.size < (long)this.bufferSize) {
                for (E e : t) {
                    this.put(e);
                }
            }
            this.serialize(new ArrayList<E>(t));
        }
        finally {
            var6_6 = this.consumers.iterator();
            ** while (var6_6.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            var7_10 = consumer = var6_6.next();
            synchronized (var7_10) {
                consumer.notifyAll();
                continue;
            }
        }
lbl21:
        // 1 sources

    }

    public synchronized void end() throws IOException, InterruptedException {
        this.endOffset = this.size + 1L;
        ++this.size;
    }

    public class Consumer<E>
    implements IQueueConsumer<E> {
        long offset = 0L;
        boolean end;
        List<E> currentList;
        int currentPosition = -1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public E take() throws InterruptedException, IOException {
            if (this.currentList != null) {
                e = this.currentList.get(++this.currentPosition);
                if (this.currentPosition + 1 == this.currentList.size()) {
                    this.currentList = null;
                    this.currentPosition = -1;
                }
                return e;
            }
            if (!this.end) ** GOTO lbl16
            return null;
lbl-1000:
            // 1 sources

            {
                e = this;
                synchronized (e) {
                    this.wait(100L);
                    continue;
                }
lbl16:
                // 2 sources

                ** while (FileQueue.this.size <= this.offset)
            }
lbl17:
            // 1 sources

            if (this.offset + 1L == FileQueue.this.endOffset) {
                this.end = true;
                return null;
            }
            try {
                o = FileQueue.this.get(this.offset + 1L);
                if (o instanceof List) {
                    this.currentList = (List)o;
                    e = this.currentList.get(++this.currentPosition);
                    if (this.currentPosition + 1 == this.currentList.size()) {
                        this.currentList = null;
                        this.currentPosition = -1;
                    }
                } else {
                    e = o;
                }
            }
            catch (ClassNotFoundException e1) {
                throw new IOException(e1);
            }
            ++this.offset;
            FileQueue.this.deleteFiles();
            return (E)e;
        }
    }
}

