/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.xml;

import com.ctc.wstx.stax.WstxInputFactory;
import com.indy.engine.common.xml.Messages;
import com.indy.engine.common.xml.XMLSerializer;
import com.indy.engine.core.IDatatypeConverter;
import com.indy.engine.core.IXmlUtils;
import com.indy.engine.core.module.classloader.ClassLoaderServiceProvider;
import com.indy.runtime.xml.internal.XmlStreamWriter2XmlEventWriter;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XmlUtils
implements IXmlUtils {
    private static final Logger LOGGER = LogManager.getLogger(XmlUtils.class);
    IDatatypeConverter wrapped = null;
    Object lockDatatypeConverter = new Object();

    public XMLStreamWriter xmlStreamWriterToXmlEventWriter(XMLEventWriter writer) {
        return new XmlStreamWriter2XmlEventWriter(writer);
    }

    public void xmlReaderToContentHandler(XMLEventReader reader, ContentHandler handler) throws XMLStreamException, SAXException {
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            switch (event.getEventType()) {
                case 4: 
                case 12: {
                    Characters cha = event.asCharacters();
                    if (cha.getData().length() <= 0) break;
                    handler.characters(cha.getData().toCharArray(), 0, cha.getData().length());
                    break;
                }
                case 7: {
                    handler.startDocument();
                    break;
                }
                case 8: {
                    handler.endDocument();
                    break;
                }
                case 10: {
                    break;
                }
                case 13: {
                    break;
                }
                case 1: {
                    StartElement se = event.asStartElement();
                    QName name = se.getName();
                    _Attributes attrs = new _Attributes(se.getAttributes());
                    handler.startElement(name.getNamespaceURI(), name.getLocalPart(), name.toString(), attrs);
                    break;
                }
                case 2: {
                    EndElement ee = event.asEndElement();
                    QName name = ee.getName();
                    handler.endElement(name.getNamespaceURI(), name.getLocalPart(), name.toString());
                    break;
                }
                case 15: {
                    break;
                }
                case 9: {
                    break;
                }
                case 14: {
                    break;
                }
                case 3: {
                    break;
                }
                case 6: {
                    break;
                }
                case 11: {
                    break;
                }
            }
        }
    }

    public static void writeXMLEventToXMLStreamWriter(XMLEvent event, XMLStreamWriter writer) throws XMLStreamException {
        switch (event.getEventType()) {
            case 4: 
            case 12: {
                Characters cha = event.asCharacters();
                if (cha.getData().length() <= 0) break;
                writer.writeCharacters(cha.getData());
                break;
            }
            case 7: {
                writer.writeStartDocument();
                break;
            }
            case 8: {
                writer.writeEndDocument();
                break;
            }
            case 10: {
                break;
            }
            case 13: {
                break;
            }
            case 1: {
                StartElement se = event.asStartElement();
                QName name = se.getName();
                _Attributes attrs = new _Attributes(se.getAttributes());
                if (name.getNamespaceURI() != null) {
                    if (name.getPrefix() != null) {
                        writer.writeStartElement(name.getPrefix(), name.getLocalPart(), name.getNamespaceURI());
                    } else {
                        writer.writeStartElement(name.getNamespaceURI(), name.getLocalPart());
                    }
                } else {
                    writer.writeStartElement(name.getLocalPart());
                }
                int i = 0;
                while (i < attrs.getLength()) {
                    writer.writeAttribute(attrs.getURI(i), attrs.getLocalName(i), attrs.getValue(i));
                    ++i;
                }
                break;
            }
            case 2: {
                writer.writeEndElement();
                break;
            }
            case 15: {
                break;
            }
            case 9: {
                break;
            }
            case 14: {
                break;
            }
            case 3: {
                break;
            }
            case 6: {
                break;
            }
            case 11: {
                break;
            }
            case 5: {
                break;
            }
            case 99: {
                if (!(writer instanceof XmlStreamWriter2XmlEventWriter)) break;
                ((XmlStreamWriter2XmlEventWriter)writer).writeNewLineCharacter();
            }
        }
    }

    public Document stringToDOMDocument(String xmlDef) throws EngineExceptionI {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            return docBuilder.parse(new ByteArrayInputStream(xmlDef.getBytes()));
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    public static String getTextualXml(InputStream is, Collection<String> paramFilter, AttributeListener listener) throws XMLStreamException {
        try (XMLEventReader reader = null;){
            Node root;
            HashSet<String> filter = new HashSet<String>();
            for (String f : paramFilter) {
                filter.add(f);
            }
            WstxInputFactory xif = null;
            try {
                xif = new WstxInputFactory();
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.getString("XmlUtils.0") + String.valueOf(Thread.currentThread().getContextClassLoader()), e);
            }
            reader = xif.createXMLEventReader(is, "UTF-8");
            ArrayList<Node> allNodes = new ArrayList<Node>();
            Node current = root = new Node();
            while (reader.hasNext()) {
                Characters chars;
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement()) {
                    StartElement se = event.asStartElement();
                    Node parent = current;
                    current = new Node();
                    current.parent = parent;
                    current.setName(se.getName().getLocalPart());
                    if (filter.contains(current.path)) continue;
                    allNodes.add(current);
                    Iterator<Attribute> it = se.getAttributes();
                    while (it.hasNext()) {
                        Attribute attr = it.next();
                        String path = current.path + "/@" + attr.getName().getLocalPart();
                        if (!filter.contains(path)) {
                            String str = "@" + attr.getName().getLocalPart() + "=" + attr.getValue();
                            current.attributes.add(str);
                        }
                        listener.attribute(path, attr.getValue());
                    }
                    continue;
                }
                if (event.isEndElement()) {
                    current = current.parent;
                    continue;
                }
                if (!event.isCharacters() || !(chars = event.asCharacters()).isCData() && (chars.getData() == null || chars.getData().trim().isEmpty())) continue;
                current.text = chars.getData();
            }
            Collections.sort(allNodes);
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (Node node : allNodes) {
                if (i > 0) {
                    sb.append("\n");
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(node.getRowId());
                }
                sb.append(node.getRowId());
                if (node.text != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(node.text);
                    }
                    sb.append("\n");
                    sb.append(node.text);
                }
                ++i;
            }
            String string = sb.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDatatypeConverter getDatatypeConverter() throws Exception {
        Object object = this.lockDatatypeConverter;
        synchronized (object) {
            if (this.wrapped == null) {
                ClassLoader cl = ClassLoaderServiceProvider.instance().getClassLoader("internal");
                ServiceLoader<IDatatypeConverter> serviceLoader = ServiceLoader.load(IDatatypeConverter.class, cl);
                Iterator<IDatatypeConverter> it = serviceLoader.iterator();
                if (it.hasNext()) {
                    this.wrapped = it.next();
                } else {
                    throw new RuntimeException(Messages.getString("XmlUtils.1"));
                }
            }
        }
        return this.wrapped;
    }

    public String escapeXML(String value) {
        return StringEscapeUtils.escapeXml11((String)value);
    }

    public String unescapeXML(String string) {
        return StringEscapeUtils.unescapeXml((String)string);
    }

    public void serializeFromJavaObject(Object o, OutputStream os, String attributePrefix, String nillablePrefix, String rootNodeName) throws XMLStreamException {
        XMLOutputFactory output = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = output.createXMLStreamWriter(os);
        XMLSerializer serializer = new XMLSerializer(writer, attributePrefix, nillablePrefix);
        serializer.serialize(o, rootNodeName);
        writer.close();
    }

    public static interface AttributeListener {
        public void attribute(String var1, String var2);
    }

    static class Node
    implements Comparable<Node> {
        String name;
        List<Node> list = new ArrayList<Node>();
        List<String> attributes = new ArrayList<String>();
        String text;
        public Node parent;
        private String path;

        Node() {
        }

        void setName(String name) {
            this.name = name;
            Node current = this;
            StringBuilder sb = new StringBuilder();
            while (current != null && current.name != null) {
                if (sb.length() == 0) {
                    sb.insert(0, current.name);
                } else {
                    sb.insert(0, current.name + "/");
                }
                current = current.parent;
            }
            this.path = sb.toString();
        }

        String getRowId() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.path);
            if (!this.attributes.isEmpty()) {
                Collections.sort(this.attributes);
                for (String str : this.attributes) {
                    sb.append(" ");
                    sb.append(str);
                }
            }
            return sb.toString();
        }

        @Override
        public int compareTo(Node paramT) {
            return this.getRowId().compareTo(paramT.getRowId());
        }
    }

    public static class _Attributes
    implements Attributes {
        Map<QName, Integer> index = new HashMap<QName, Integer>();
        List<Attribute> list = new LinkedList<Attribute>();

        public _Attributes(Iterator<Attribute> attributes) {
            int i = 0;
            if (attributes != null) {
                while (attributes.hasNext()) {
                    Attribute currentAttr = attributes.next();
                    this.list.add(currentAttr);
                    this.index.put(currentAttr.getName(), i++);
                }
            }
        }

        @Override
        public int getLength() {
            return this.list.size();
        }

        @Override
        public String getURI(int paramInt) {
            return this.list.get(paramInt).getName().getNamespaceURI();
        }

        @Override
        public String getLocalName(int paramInt) {
            return this.list.get(paramInt).getName().getLocalPart();
        }

        @Override
        public String getQName(int paramInt) {
            return this.list.get(paramInt).getName().toString();
        }

        @Override
        public String getType(int paramInt) {
            return this.list.get(paramInt).getDTDType();
        }

        @Override
        public String getValue(int paramInt) {
            return this.list.get(paramInt).getValue();
        }

        @Override
        public int getIndex(String paramString1, String paramString2) {
            return this.getIndex(new QName(paramString1, paramString2));
        }

        public int getIndex(QName name) {
            Integer localIndex = this.index.get(name);
            if (localIndex == null) {
                return -1;
            }
            return localIndex;
        }

        @Override
        public int getIndex(String paramString) {
            return this.getIndex(new QName(paramString));
        }

        @Override
        public String getType(String paramString1, String paramString2) {
            return this.getType(this.getIndex(paramString1, paramString2));
        }

        @Override
        public String getType(String paramString) {
            return this.getType(this.getIndex(paramString));
        }

        @Override
        public String getValue(String paramString1, String paramString2) {
            return this.getValue(this.getIndex(paramString1, paramString2));
        }

        @Override
        public String getValue(String paramString) {
            return this.getValue(this.getIndex(paramString));
        }
    }
}

