/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.api.impl.jdbc;

import com.indy.engine.common.queue.impl.FileQueue;
import com.indy.engine.common.queue.impl.MemoryBlockingQueue;
import com.indy.engine.core.common.objects.NotFetchedResultSetBindI;
import com.indy.engine.core.jdbc.IPreparedStatementToResultSet;
import com.indy.engine.core.module.configuration.RuntimeConfiguration;
import com.indy.engine.core.queue.IQueueProducer;
import com.indy.runtime.api.impl.jdbc.fifo.BlockingQueueWithWait;
import com.indy.runtime.api.impl.jdbc.fifo.ColumnMetadata;
import com.indy.runtime.api.impl.jdbc.fifo.FifoResultSet;
import com.indy.runtime.api.impl.jdbc.fifo.FifoRow;
import com.indy.runtime.api.impl.jdbc.fifo.Messages;
import com.indy.runtime.api.impl.jdbc.fifo.PreparedStatementImpl;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.function.Function;

public class JdbcPreparedStatementToResultSet
extends PreparedStatementImpl
implements IPreparedStatementToResultSet {
    ColumnMetadata cm;
    private Map<String, BlockingQueueWithWait<FifoRow>> queues = new ConcurrentHashMap<String, BlockingQueueWithWait<FifoRow>>();
    public static final FifoRow stopRow = new FifoRow(0);
    public static final FifoRow endMessage = new FifoRow(0);
    Semaphore sem;
    boolean mono;
    ResultSet source;
    IQueueProducer<FifoRow> producer;
    public static final String monoResultSet = "mono";
    boolean lastRowIsSend = false;
    private final Map<String, Integer> index = new HashMap<String, Integer>();
    private Function<String, Integer> columnIndexFunction = null;
    FifoRow currentRow;
    List<FifoRow> batch = new ArrayList<FifoRow>();
    int closeState = 0;
    Map<String, FifoResultSet> resultSets = new ConcurrentHashMap<String, FifoResultSet>();

    public void start() {
        if (this.sem != null) {
            this.sem.release();
            this.sem = null;
        }
    }

    void waitForStart() throws SQLException {
        if (this.sem != null) {
            try {
                this.sem.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SQLException(e);
            }
        }
    }

    private ColumnMetadata getCM() throws SQLException {
        if (this.closeState == 2) {
            throw new SQLException(Messages.getString("JdbcPreparedStatementToResultSet.0"));
        }
        if (this.cm == null) {
            throw new SQLException(Messages.getString("JdbcPreparedStatementToResultSet.4"));
        }
        return this.cm;
    }

    public void setInputResultSet(ResultSet rsm) throws SQLException {
        if (this.cm.getColumnCount() > 0) {
            throw new SQLException(Messages.getString("JdbcPreparedStatementToResultSet.3"));
        }
        this.cm = null;
        this.source = rsm;
    }

    public void fill() throws SQLException {
        if (this.source != null) {
            while (this.source.next()) {
                FifoRow fr = new FifoRow(this.getMetaData().getColumnCount());
                int i = 1;
                while (i <= this.getMetaData().getColumnCount()) {
                    fr.setObject(i, this.source.getObject(i));
                    ++i;
                }
                this.add(fr);
            }
            this.end();
        }
    }

    public synchronized void setConsumers(boolean fileQueue, String ... names) throws SQLException {
        if (this.producer != null) {
            throw new SQLException(Messages.getString("JdbcPreparedStatementToResultSet.1"));
        }
        this.producer = fileQueue ? new FileQueue<FifoRow>(new File(RuntimeConfiguration.getInstance().temporaryFolder() + File.pathSeparator + "filequeue"), UUID.randomUUID().toString()) : new MemoryBlockingQueue<FifoRow>(new FifoRow(0));
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.addConsumer(name);
            ++n2;
        }
    }

    private void addConsumer(final String name) throws SQLException {
        BlockingQueueWithWait queue;
        this.mono = this.queues.size() == 0 && name.equals(monoResultSet);
        try {
            queue = new BlockingQueueWithWait(this.producer.createConsumer());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException(e);
        }
        this.queues.put(name, queue);
        FifoResultSet rs = new FifoResultSet(queue){

            @Override
            public void close() throws SQLException {
                JdbcPreparedStatementToResultSet.this.resultSets.remove(name);
                BlockingQueueWithWait<FifoRow> bqww = JdbcPreparedStatementToResultSet.this.queues.get(name);
                if (bqww != null) {
                    bqww.close();
                    JdbcPreparedStatementToResultSet.this.queues.remove(name);
                }
                super.close();
            }

            @Override
            public ResultSetMetaData getMetaData() throws SQLException {
                return JdbcPreparedStatementToResultSet.this.getMetaData();
            }
        };
        this.resultSets.put(name, rs);
    }

    public JdbcPreparedStatementToResultSet() throws SQLException {
        this.cm = new ColumnMetadata();
    }

    public void handleBeforeAdd() throws SQLException {
    }

    private void add(FifoRow row) throws SQLException {
        this.waitForStart();
        this.handleBeforeAdd();
        try {
            if (row == stopRow) {
                this.producer.end();
            } else {
                this.producer.put((Object)row);
            }
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    private void waitAck() throws SQLException {
        this.waitForStart();
        ArrayList<BlockingQueueWithWait<FifoRow>> list = new ArrayList<BlockingQueueWithWait<FifoRow>>();
        list.addAll(this.queues.values());
        for (BlockingQueueWithWait blockingQueueWithWait : list) {
            try {
                blockingQueueWithWait.internalWaitForEnd();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SQLException(e);
            }
        }
    }

    private void addAll(List<FifoRow> rows) throws SQLException {
        this.waitForStart();
        this.handleBeforeAdd();
        try {
            this.producer.putAll(rows);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public void end() throws SQLException {
        if (!this.lastRowIsSend) {
            this.lastRowIsSend = true;
            this.add(stopRow);
            this.waitAck();
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batch.clear();
        this.clearParameters();
    }

    private Function<String, Integer> getColumnIndexFunction() throws SQLException {
        if (this.columnIndexFunction == null) {
            this.columnIndexFunction = new ColumnIndexFunction(this.getMetaData());
        }
        return this.columnIndexFunction;
    }

    private int findColumn(String columnLabel) throws SQLException {
        try {
            return this.index.computeIfAbsent(columnLabel, this.getColumnIndexFunction());
        }
        catch (IllegalArgumentException e) {
            throw new SQLDataException(Messages.getString("FifoResultSet.0") + columnLabel + Messages.getString("FifoResultSet.1"));
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw new SQLException(e);
        }
    }

    @Override
    public void setString(int paramInt, String paramString) throws SQLException {
        this.setObject(paramInt, (Object)paramString);
    }

    public void setString(String columnLabel, String paramString) throws SQLException {
        this.setString(this.findColumn(columnLabel), paramString);
    }

    @Override
    public void setBoolean(int paramInt, boolean paramBoolean) throws SQLException {
        this.setObject(paramInt, (Object)paramBoolean);
    }

    public void setBoolean(String columnLabel, boolean paramBoolean) throws SQLException {
        this.setBoolean(this.findColumn(columnLabel), paramBoolean);
    }

    @Override
    public void setDouble(int paramInt, double paramDouble) throws SQLException {
        this.setObject(paramInt, (Object)paramDouble);
    }

    public void setDouble(String columnLabel, double paramDouble) throws SQLException {
        this.setDouble(this.findColumn(columnLabel), paramDouble);
    }

    @Override
    public void setDate(int paramInt, Date paramDate) throws SQLException {
        if (paramDate == null) {
            this.setNull(paramInt, 91);
        } else {
            this.setObject(paramInt, (Object)paramDate.toLocalDate());
        }
    }

    public void setDate(String columnLabel, Date paramDate) throws SQLException {
        this.setDate(this.findColumn(columnLabel), paramDate);
    }

    @Override
    public void setTime(int paramInt, Time paramTime) throws SQLException {
        if (paramTime == null) {
            this.setNull(paramInt, 92);
        } else {
            this.setObject(paramInt, (Object)paramTime.toLocalTime());
        }
    }

    public void setTime(String columnLabel, Time paramTime) throws SQLException {
        this.setTime(this.findColumn(columnLabel), paramTime);
    }

    @Override
    public void setTimestamp(int paramInt, Timestamp paramTimestamp) throws SQLException {
        if (paramTimestamp == null) {
            this.setNull(paramInt, 93);
        } else {
            this.setObject(paramInt, (Object)paramTimestamp.toLocalDateTime());
        }
    }

    public void setTimestamp(String columnName, Timestamp paramTimestamp) throws SQLException {
        this.setTimestamp(this.findColumn(columnName), paramTimestamp);
    }

    @Override
    public void setBigDecimal(int paramInt, BigDecimal paramBigDecimal) throws SQLException {
        this.setObject(paramInt, (Object)paramBigDecimal);
    }

    public void setBigDecimal(String columnLabel, BigDecimal paramBigDecimal) throws SQLException {
        this.setBigDecimal(this.findColumn(columnLabel), paramBigDecimal);
    }

    @Override
    public void setBytes(int paramInt, byte[] parambyte) throws SQLException {
        this.setObject(paramInt, (Object)parambyte);
    }

    public void setBytes(String columnLabel, byte[] parambyte) throws SQLException {
        this.setBytes(this.findColumn(columnLabel), parambyte);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.currentRow = new FifoRow(this.getCM().getColumnCount());
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkCurrentRow();
        this.batch.add(this.currentRow);
        this.clearParameters();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.cm;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.closeState == 2) {
            throw new SQLException(Messages.getString("JdbcPreparedStatementToResultSet.2"));
        }
        if (this.cm == null) {
            if (this.source != null) {
                return this.source.getMetaData();
            }
            throw new SQLException(Messages.getString("JdbcPreparedStatementToResultSet.5"));
        }
        return this.getCM();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closeState == 2;
    }

    @Override
    public void close() throws SQLException {
        if (this.closeState == 0) {
            this.closeState = 1;
            this.end();
            this.currentRow = null;
            if (this.batch != null) {
                this.batch.clear();
            }
            this.batch = null;
            this.cm = null;
            this.source = null;
            try {
                this.producer.close();
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
            this.producer = null;
            this.closeState = 2;
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkCurrentRow();
        this.add(this.currentRow);
        this.clearParameters();
        return 1;
    }

    public ResultSet getResultSet(String id) throws SQLException {
        ResultSet rs;
        ResultSet resultSet = rs = this.mono ? (ResultSet)this.resultSets.get(monoResultSet) : (ResultSet)this.resultSets.get(id);
        if (rs != null) {
            return rs;
        }
        throw new SQLException("resultSet:" + id + "doesn't exists");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int i = this.batch.size();
        this.addAll(this.batch);
        this.clearBatch();
        int[] ret = new int[i];
        int j = 0;
        while (j < ret.length) {
            ret[j] = 1;
            ++j;
        }
        return ret;
    }

    public void setColumn(int paramInt, String columnName, boolean caseSensitive) throws SQLException {
        this.setColumn(paramInt, columnName, "VARCHAR", caseSensitive);
    }

    public void setColumn(int paramInt, String columnName, String dataType, boolean caseSensitive) throws SQLException {
        this.getCM().setColumnName(paramInt, columnName, caseSensitive);
        this.getCM().setColumnType(paramInt, dataType);
    }

    public void setColumn(int paramInt, String columnName, int jdbcType, boolean caseSensitive) throws SQLException {
        this.getCM().setColumnName(paramInt, columnName, caseSensitive);
        this.getCM().setColumnType(paramInt, jdbcType);
    }

    public void setColumn(int paramInt, String columnName, String dataType, int precision, boolean caseSensitive) throws SQLException {
        this.setColumn(paramInt, columnName, dataType, caseSensitive);
        this.getCM().setColumnPrecision(paramInt, precision);
    }

    public void setColumn(int paramInt, String columnName, int jdbcType, int precision, boolean caseSensitive) throws SQLException {
        this.setColumn(paramInt, columnName, jdbcType, caseSensitive);
        this.getCM().setColumnPrecision(paramInt, precision);
    }

    public void setColumn(int paramInt, String columnName, String dataType, int precision, int scale, boolean caseSensitive) throws SQLException {
        this.setColumn(paramInt, columnName, dataType, precision, caseSensitive);
    }

    public void setColumn(int paramInt, String columnName, int jdbcType, int precision, int scale, boolean caseSensitive) throws SQLException {
        this.setColumn(paramInt, columnName, jdbcType, precision, caseSensitive);
    }

    public void setColumnName(int paramInt, String columnName, boolean caseSensitive) throws SQLException {
        this.getCM().setColumnName(paramInt, columnName, caseSensitive);
    }

    public void setColumnPrecision(int paramInt, int precision) throws SQLException {
        this.getCM().setColumnPrecision(paramInt, precision);
    }

    @Deprecated
    public void setColumnsName(String string, String separator) throws SQLException {
        String[] strs = string.split(separator);
        int i = 0;
        while (i < strs.length) {
            this.setColumnName(i + 1, strs[i].trim());
            ++i;
        }
    }

    @Deprecated
    public void setColumnsPrecision(String string, String separator) throws NumberFormatException, SQLException {
        String[] strs = string.split(separator);
        int i = 0;
        while (i < strs.length) {
            this.setColumnPrecision(i + 1, Integer.valueOf(strs[i].trim()));
            ++i;
        }
    }

    void checkCurrentRow() throws SQLException {
        if (this.currentRow == null) {
            this.clearParameters();
        }
    }

    @Override
    public void setInt(int paramInt1, int paramInt2) throws SQLException {
        this.setObject(paramInt1, (Object)paramInt2);
    }

    public void setInt(String columnLabel, int paramInt2) throws SQLException {
        this.setInt(this.findColumn(columnLabel), paramInt2);
    }

    @Override
    public void setNull(int paramInt1, int paramInt2) throws SQLException {
        this.setObject(paramInt1, null);
    }

    public void setNull(String columnLabel, int paramInt2) throws SQLException {
        this.setNull(this.findColumn(columnLabel), paramInt2);
    }

    @Override
    public void setLong(int paramInt1, long paramInt2) throws SQLException {
        this.setObject(paramInt1, (Object)paramInt2);
    }

    public void setLong(String columnName, long paramInt2) throws SQLException {
        this.setLong(this.findColumn(columnName), paramInt2);
    }

    public void setColumnType(int paramInt, String type) throws SQLException {
        this.getCM().setColumnType(paramInt, type);
    }

    public void setColumnType(int paramInt, int type) throws SQLException {
        this.getCM().setColumnType(paramInt, type);
    }

    @Override
    public void setObject(int index, Object o) throws SQLException {
        this.checkCurrentRow();
        this.currentRow.setObject(index, o);
    }

    @Override
    public void setObject(int index, Object o, int jdbcType) throws SQLException {
        this.setObject(index, o);
    }

    public void setObject(String columnLabel, Object o) throws SQLException {
        this.setObject(this.findColumn(columnLabel), o);
    }

    public NotFetchedResultSetBindI getNotFetchedResultSetBindI() {
        return new NotFetchedResultSetBindI(){

            public ResultSet initResultSet(String id) throws SQLException {
                return JdbcPreparedStatementToResultSet.this.getResultSet(id);
            }

            public ResultSet getResultSet(String id) throws SQLException {
                return JdbcPreparedStatementToResultSet.this.getResultSet(id);
            }

            public void closeResultSet(String id) throws SQLException {
                ResultSet rs = JdbcPreparedStatementToResultSet.this.getResultSet(id);
                if (rs != null) {
                    rs.close();
                }
            }
        };
    }

    @Override
    public void setBinaryStream(int paramInt, InputStream paramInputStream) throws SQLException {
        this.setObject(paramInt, (Object)paramInputStream);
    }

    public void setBinaryStream(String columnLabel, InputStream paramInputStream) throws SQLException {
        this.setBinaryStream(this.findColumn(columnLabel), paramInputStream);
    }

    @Override
    public void setDate(int paramInt, Date paramDate, Calendar paramCalendar) throws SQLException {
        this.setDate(paramInt, paramDate);
    }

    @Override
    public void setTime(int paramInt, Time paramTime, Calendar paramCalendar) throws SQLException {
        if (paramCalendar == null || paramTime == null) {
            this.setTime(paramInt, paramTime);
        } else {
            this.setObject(paramInt, (Object)paramTime.toLocalTime().atOffset(paramCalendar.getTimeZone().toZoneId().getRules().getOffset(Instant.now())));
        }
    }

    public void setTime(String columnLabel, Time paramTime, Calendar paramCalendar) throws SQLException {
        this.setTime(this.findColumn(columnLabel), paramTime, paramCalendar);
    }

    @Override
    public void setTimestamp(int paramInt, Timestamp paramTimestamp, Calendar paramCalendar) throws SQLException {
        if (paramCalendar == null || paramTimestamp == null) {
            this.setTimestamp(paramInt, paramTimestamp);
        } else {
            this.setObject(paramInt, (Object)paramTimestamp.toLocalDateTime().atZone(paramCalendar.getTimeZone().toZoneId()));
        }
    }

    public void setTimestamp(String columnLabel, Timestamp paramTimestamp, Calendar paramCalendar) throws SQLException {
        this.setTimestamp(this.findColumn(columnLabel), paramTimestamp, paramCalendar);
    }

    @Override
    public void setAsciiStream(int paramInt, InputStream paramInputStream) throws SQLException {
        this.setObject(paramInt, (Object)paramInputStream);
    }

    public void setAsciiStream(String columnLabel, InputStream paramInputStream) throws SQLException {
        this.setAsciiStream(this.findColumn(columnLabel), paramInputStream);
    }

    @Override
    public void setBlob(int paramInt, Blob paramBlob) throws SQLException {
        this.setObject(paramInt, (Object)paramBlob);
    }

    public void setBlob(String columnLabel, Blob paramBlob) throws SQLException {
        this.setBlob(this.findColumn(columnLabel), paramBlob);
    }

    @Override
    public void setClob(int paramInt, Clob paramClob) throws SQLException {
        this.setObject(paramInt, (Object)paramClob);
    }

    public void setClob(String columnLabel, Clob paramClob) throws SQLException {
        this.setClob(this.findColumn(columnLabel), paramClob);
    }

    @Override
    public void setCharacterStream(int paramInt, Reader paramReader) throws SQLException {
        this.setObject(paramInt, (Object)paramReader);
    }

    public void setCharacterStream(String columnLabel, Reader paramReader) throws SQLException {
        this.setCharacterStream(this.findColumn(columnLabel), paramReader);
    }

    @Override
    public void setShort(int paramInt, short paramShort) throws SQLException {
        this.setObject(paramInt, (Object)paramShort);
    }

    public void setShort(String columnLabel, short paramShort) throws SQLException {
        this.setShort(this.findColumn(columnLabel), paramShort);
    }

    @Override
    public void setByte(int paramInt, byte paramByte) throws SQLException {
        this.setObject(paramInt, (Object)paramByte);
    }

    public void setByte(String columnLabel, byte paramByte) throws SQLException {
        this.setByte(this.findColumn(columnLabel), paramByte);
    }

    @Override
    public void setFloat(int paramInt, float paramFloat) throws SQLException {
        this.setObject(paramInt, (Object)Float.valueOf(paramFloat));
    }

    public void setFloat(String columnLabel, float paramFloat) throws SQLException {
        this.setFloat(this.findColumn(columnLabel), paramFloat);
    }

    public static class ColumnIndexFunction
    implements Function<String, Integer> {
        private final ResultSetMetaData columnMetadata;

        public ColumnIndexFunction(ResultSetMetaData columnMetadata) {
            this.columnMetadata = columnMetadata;
        }

        @Override
        public Integer apply(String columnLabel) {
            try {
                int i = 1;
                while (i <= this.columnMetadata.getColumnCount()) {
                    String str = this.columnMetadata.getColumnLabel(i);
                    if (this.columnMetadata.isCaseSensitive(i) ? str.equals(columnLabel) : str.equalsIgnoreCase(columnLabel)) {
                        return i;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            throw new IllegalArgumentException(columnLabel);
        }
    }
}

