/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.api.impl.jdbc.fifo;

import com.indy.runtime.api.impl.jdbc.fifo.Messages;
import java.sql.ParameterMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.List;

public class ColumnMetadata
implements ResultSetMetaData,
ParameterMetaData {
    final List<MetadataColumn> md = new ArrayList<MetadataColumn>();

    private MetadataColumn getColumn(int position) {
        return this.md.get(position - 1);
    }

    @Override
    public boolean isWrapperFor(Class<?> paramClass) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> paramClass) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.md.size();
    }

    @Override
    public boolean isAutoIncrement(int paramInt) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int paramInt) throws SQLException {
        return this.getColumn((int)paramInt).caseSensitive;
    }

    @Override
    public boolean isSearchable(int paramInt) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int paramInt) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int paramInt) throws SQLException {
        return 1;
    }

    @Override
    public boolean isSigned(int paramInt) throws SQLException {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int paramInt) throws SQLException {
        return this.getColumn(paramInt).getColumnDisplaySize();
    }

    @Override
    public String getColumnLabel(int paramInt) throws SQLException {
        return this.getColumn(paramInt).getColumnLabel();
    }

    @Override
    public String getColumnName(int paramInt) throws SQLException {
        return this.getColumn(paramInt).getColumnName();
    }

    @Override
    public String getSchemaName(int paramInt) throws SQLException {
        return null;
    }

    @Override
    public int getPrecision(int paramInt) throws SQLException {
        return this.getColumn(paramInt).getPrecision();
    }

    @Override
    public int getScale(int paramInt) throws SQLException {
        return 0;
    }

    @Override
    public String getTableName(int paramInt) throws SQLException {
        return null;
    }

    @Override
    public String getCatalogName(int paramInt) throws SQLException {
        return null;
    }

    @Override
    public int getColumnType(int paramInt) throws SQLException {
        return this.getColumn(paramInt).getColumnType();
    }

    @Override
    public String getColumnTypeName(int paramInt) throws SQLException {
        return this.getColumn(paramInt).getColumnTypeName();
    }

    @Override
    public boolean isReadOnly(int paramInt) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int paramInt) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int paramInt) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int paramInt) throws SQLException {
        return String.class.getName();
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.getColumnCount();
    }

    @Override
    public int getParameterType(int paramInt) throws SQLException {
        return this.getColumnType(paramInt);
    }

    @Override
    public String getParameterTypeName(int paramInt) throws SQLException {
        return this.getColumnTypeName(paramInt);
    }

    @Override
    public String getParameterClassName(int paramInt) throws SQLException {
        return this.getColumnClassName(paramInt);
    }

    @Override
    public int getParameterMode(int paramInt) throws SQLException {
        return 2;
    }

    private void computeMdSize(int index) {
        if (index > this.md.size()) {
            this.md.add(new MetadataColumn());
        }
    }

    public void setColumnName(int paramInt, String columnName, boolean caseSensitive) {
        this.computeMdSize(paramInt);
        this.getColumn((int)paramInt).name = columnName;
        this.getColumn((int)paramInt).caseSensitive = caseSensitive;
    }

    public void setColumnPrecision(int paramInt, int precision) {
        this.computeMdSize(paramInt);
        this.getColumn((int)paramInt).precision = precision;
    }

    private static int convertStringTypeToInt(String type) throws SQLFeatureNotSupportedException {
        if (type.equals("ARRAY")) {
            return 2003;
        }
        if (type.equals("BIGINT")) {
            return -5;
        }
        if (type.equals("BINARY")) {
            return -2;
        }
        if (type.equals("BIT")) {
            return -7;
        }
        if (type.equals("BLOB")) {
            return 2004;
        }
        if (type.equals("BOOLEAN")) {
            return 16;
        }
        if (type.equals("CHAR")) {
            return 1;
        }
        if (type.equals("CLOB")) {
            return 2005;
        }
        if (type.equals("DATALINK")) {
            return 70;
        }
        if (type.equals("DATE")) {
            return 91;
        }
        if (type.equals("DECIMAL")) {
            return 3;
        }
        if (type.equals("DISTINCT")) {
            return 2001;
        }
        if (type.equals("DOUBLE")) {
            return 8;
        }
        if (type.equals("FLOAT")) {
            return 6;
        }
        if (type.equals("INTEGER")) {
            return 4;
        }
        if (type.equals("JAVA_OBJECT")) {
            return 2000;
        }
        if (type.equals("LONGNVARCHAR")) {
            return -16;
        }
        if (type.equals("LONGVARCHAR")) {
            return -1;
        }
        if (type.equals("LONGVARBINARY")) {
            return -4;
        }
        if (type.equals("NCHAR")) {
            return -15;
        }
        if (type.equals("NCLOB")) {
            return 2011;
        }
        if (type.equals("NULL")) {
            return 0;
        }
        if (type.equals("NUMERIC")) {
            return 2;
        }
        if (type.equals("NVARCHAR")) {
            return -9;
        }
        if (type.equals("OTHER")) {
            return 1111;
        }
        if (type.equals("REAL")) {
            return 7;
        }
        if (type.equals("REF")) {
            return 2006;
        }
        if (type.equals("ROWID")) {
            return -8;
        }
        if (type.equals("SMALLINT")) {
            return 5;
        }
        if (type.equals("SQLXML")) {
            return 2009;
        }
        if (type.equals("STRUCT")) {
            return 2002;
        }
        if (type.equals("TIME")) {
            return 92;
        }
        if (type.equals("TIMESTAMP")) {
            return 93;
        }
        if (type.equals("TINYINT")) {
            return -6;
        }
        if (type.equals("VARBINARY")) {
            return -3;
        }
        if (type.equals("VARCHAR")) {
            return 12;
        }
        throw new SQLFeatureNotSupportedException(Messages.getString("ColumnMetadata.0") + type + Messages.getString("ColumnMetadata.1"));
    }

    public void setColumnType(int paramInt, int type) throws SQLFeatureNotSupportedException {
        switch (type) {
            case -8: 
            case 0: 
            case 70: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2009: {
                throw new SQLFeatureNotSupportedException(Messages.getString("ColumnMetadata.2") + type + Messages.getString("ColumnMetadata.3"));
            }
            case -16: 
            case -15: 
            case -9: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: 
            case 2000: 
            case 2004: 
            case 2005: 
            case 2011: {
                this.getColumn((int)paramInt).type = type;
                break;
            }
            default: {
                throw new SQLFeatureNotSupportedException(Messages.getString("ColumnMetadata.4") + type + Messages.getString("ColumnMetadata.5"));
            }
        }
    }

    public void setColumnType(int paramInt, String type) throws SQLFeatureNotSupportedException {
        this.computeMdSize(paramInt);
        this.setColumnType(paramInt, ColumnMetadata.convertStringTypeToInt(type));
    }

    private class MetadataColumn {
        String name;
        int precision;
        public int type = 12;
        private boolean caseSensitive;

        private MetadataColumn() {
        }

        public String getColumnLabel() {
            return this.name;
        }

        public String getColumnName() {
            return this.name;
        }

        public int getColumnType() {
            return this.type;
        }

        public String getColumnTypeName() {
            if (this.type == -5) {
                return "BIGINT";
            }
            if (this.type == 4) {
                return "INTEGER";
            }
            if (this.type == 12) {
                return "VARCHAR";
            }
            return "UNKNOW";
        }

        public int getColumnDisplaySize() {
            return this.getPrecision();
        }

        public int getPrecision() {
            return this.precision;
        }
    }
}

