/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.actionCodes.AMQPBaseAction;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.amqp.AMQPMessageSender;
import com.indy.engine.actionCodes.amqp.AMQPUtils;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class AMQPSendMessageActionCodeI
extends AMQPBaseAction {
    protected AMQPMessageSender jfs;
    long messageNumber = 0L;
    String strFinalActionCode;
    private String encoding;
    boolean askToClose = false;

    public AMQPSendMessageActionCodeI() {
        super("AMQPSendActionCodeI", true);
    }

    @Override
    public void _execute() throws Throwable {
        if (this.amqpExchangeName != null && this.amqpQueueName != null) {
            throw new RuntimeException(Messages.getString("AMQP.ERROR_011"));
        }
        if (this.amqpRoutingKey != null && this.amqpQueueName != null) {
            throw new RuntimeException(Messages.getString("AMQP.ERROR_012"));
        }
        this.jfs.setQueueName(this.amqpQueueName);
        this.jfs.setRoutingKey(this.amqpRoutingKey);
        this.jfs.setExchangeName(this.amqpExchangeName);
        this.send();
        this.publishVariable("MQ_MESSAGE_SENT", ++this.messageNumber);
    }

    protected void initSender(ResultSet rSet) throws EngineExceptionI {
        this.jfs = new AMQPMessageSender();
        this.strFinalActionCode = rSet != null ? this.getFinalBindedCode(rSet, this.actionTxtCode) : this.actionTxtCode;
        if (this.strFinalActionCode == null || this.strFinalActionCode.isEmpty()) {
            throw new EngineExceptionI(Messages.getString("AMQP.ERROR_013"));
        }
        this.jfs = new AMQPMessageSender();
    }

    protected void send() throws UnsupportedEncodingException, IOException, TimeoutException, InterruptedException {
        if (this.encoding != null) {
            this.jfs.send(this.amqpConnection, this.strFinalActionCode.getBytes(this.encoding));
        } else {
            this.jfs.send(this.amqpConnection, this.strFinalActionCode.getBytes());
        }
        this.commit();
    }

    @Override
    public void prepare(ResultSet rSet) throws EngineExceptionI {
        super.prepare(rSet);
        this.initSender(rSet);
        this.jfs.setConfirms(this.getLocalBooleanBindedParameter(rSet, "AMQP_WAIT_CONFIRMATION", false));
        this.jfs.setChannelName(this.amqpChannelName);
        this.jfs.setAppId(this.getLocalStringBindedParameter(rSet, AMQPUtils.AMQPProperty.AMQP_APP_ID.name(), null));
        this.jfs.setContentEncoding(this.encoding);
        this.jfs.setContentType(this.getLocalStringBindedParameter(rSet, AMQPUtils.AMQPProperty.AMQP_CONTENT_TYPE.name(), null));
        this.jfs.setExpirationPeriod(this.getLocalStringBindedParameter(rSet, AMQPUtils.AMQPProperty.AMQP_EXPIRATION.name(), null));
        this.jfs.setMessageId(this.getLocalStringBindedParameter(rSet, AMQPUtils.AMQPProperty.AMQP_MESSAGE_ID.name(), null));
        this.jfs.setReplyTo(this.getLocalStringBindedParameter(rSet, AMQPUtils.AMQPProperty.AMQP_REPLY_TO.name(), null));
        this.jfs.setPriority(this.getLocalIntegerBindedParameter(rSet, AMQPUtils.AMQPProperty.AMQP_PRIORITY.name(), null));
        try {
            Map headers = this.getAllBindedParameter(rSet, "AMQP_HEADER_[A-Za-z0-9_]+");
            for (String key : headers.keySet()) {
                Object o = headers.get(key);
                if (o instanceof String) {
                    this.jfs.setHeader(key.substring("AMQP_HEADER_".length()), o);
                    continue;
                }
                throw new EngineExceptionI(String.format(Messages.getString(Messages.getString("AMQP.ERROR_006")), o.getClass().getName()));
            }
        }
        catch (SQLException e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    @Override
    public void stopAction(Thread th) {
        super.stopAction(th);
        if (!this.askToClose) {
            this.askToClose = true;
        }
    }
}

