/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.action.common.BindExpressionReplacer;
import com.indy.engine.actionCodes.jdbc.SimpleJdbcActionCodeTypeI;
import com.indy.engine.actionCodes.loader.JdbcBinder;
import com.indy.engine.actionCodes.utils.Constant;
import com.indy.engine.actionCodes.utils.IndyContentHandler;
import com.indy.engine.common.actioncodes.connection.JdbcConnectionManager;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.stambia.jdbc.driver.file.FileDriverStatement;
import com.stambia.jdbc.driver.file.resultset.FileDriverMultiResultSet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class FileToJdbcActionCodeI
extends SimpleJdbcActionCodeTypeI {
    private InputStream isDescriptor;
    private JdbcConnectionManager sourceConnection;
    private JdbcConnectionManager targetConnection;
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    String metadata;
    List<SelectInsert> list = new ArrayList<SelectInsert>();
    private Map<String, SelectInsert> map = new HashMap<String, SelectInsert>();
    int sqlNbRows = 0;
    boolean handleStatisticAndLog = true;

    public FileToJdbcActionCodeI() {
        super("FileToJdbcActionCodeI");
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    public int prepare(ResultSet sourceRSet) throws EngineExceptionI {
        int ret = 0;
        this.isDescriptor = new ByteArrayInputStream(this.actionTxtCode.getBytes(StandardCharsets.UTF_8));
        String tempFolder = this.getStringParameter(this.runtimeContext.VAR_PREFIXE + Constant.VAR_CORE_TEMPORARY_FOLDER);
        File temporaryFolder = new File(tempFolder + "/FileToXmlActionCodeLog");
        if (!temporaryFolder.exists()) {
            temporaryFolder.mkdirs();
        }
        this.targetConnection = new JdbcConnectionManager("INSERT", "SQL_", this.getActionContext(), this.getActionCodeLogger(), false);
        this.targetConnection.prepareConnection(sourceRSet, (ActionCodeTypeI)this);
        this.sourceConnection = new JdbcConnectionManager("SELECT", "SOURCE_SQL_", this.getActionContext(), this.getActionCodeLogger(), true);
        this.sourceConnection.prepareConnection(sourceRSet, (ActionCodeTypeI)this);
        return ret;
    }

    public int finalizeDirectBindedFetch(int numRecord) throws EngineExceptionI {
        this.finalizeExecuteCode();
        return super.finalizeDirectBindedFetch(numRecord);
    }

    @Override
    public int finalizeExecuteCode() throws EngineExceptionI {
        block21: {
            try {
                try {
                    for (SelectInsert si : this.map.values()) {
                        if (si.currentBatchSize <= 0) continue;
                        si.ps.executeBatch();
                    }
                    this.targetConnection.commit();
                    break block21;
                }
                catch (SQLException e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                try {
                    for (SelectInsert si : this.map.values()) {
                        if (si.binder != null) {
                            si.binder.clear();
                            si.binder = null;
                        }
                        if (si.ps != null) {
                            si.ps.close();
                        }
                        si.ps = null;
                    }
                }
                catch (Exception e1) {
                    this.logger.warn("unexpected", (Throwable)e1);
                }
            }
            this.handleStatistics(true);
            try {
                this.sourceConnection.close();
            }
            finally {
                this.targetConnection.close();
            }
            throw throwable;
        }
        try {
            for (SelectInsert si : this.map.values()) {
                if (si.binder != null) {
                    si.binder.clear();
                    si.binder = null;
                }
                if (si.ps != null) {
                    si.ps.close();
                }
                si.ps = null;
            }
        }
        catch (Exception e1) {
            this.logger.warn("unexpected", (Throwable)e1);
        }
        this.handleStatistics(true);
        try {
            this.sourceConnection.close();
        }
        finally {
            this.targetConnection.close();
        }
        return 0;
    }

    public void handleStatistics(boolean force) {
        this.handleStatisticAndLog = true;
        if (force) {
            this.publishVariable("SQL_NB_ROWS", this.sqlNbRows);
        }
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws EngineExceptionI {
        this.prepare(sourceRSet);
        this.execute();
        return 0;
    }

    public int executeSimpleCode() throws EngineExceptionI {
        this.execute();
        return 0;
    }

    public void execute() throws EngineExceptionI {
        IndyContentHandler ich = new IndyContentHandler(){
            SelectInsert current;
            String currentString;
            boolean isMetadataOpen = false;

            public void characters(char[] ch, int start, int end) throws SAXException {
                if (this.currentString != null) {
                    this.currentString = String.valueOf(this.currentString) + new String(ch, start, end);
                }
            }

            public void endElement(String nameSpaceURI, String localName, String rawName) throws SAXException {
                if (this.isMetadataOpen) {
                    this.isMetadataOpen = false;
                    FileToJdbcActionCodeI.this.metadata = this.currentString;
                }
                if (localName.equals("selectInsert")) {
                    FileToJdbcActionCodeI.this.list.add(this.current);
                }
                if (localName.equals("select")) {
                    this.current.select = this.currentString;
                }
                if (localName.equals("insert")) {
                    this.current.insert = this.currentString;
                }
                this.currentString = null;
            }

            public void startElement(String nameSpaceURI, String localName, String rawName, Attributes attributs) throws SAXException {
                if (localName.equals("metadata")) {
                    this.isMetadataOpen = true;
                    this.currentString = "";
                }
                if (localName.equals("selectInsert")) {
                    this.current = new SelectInsert();
                }
                if (localName.equals("select") || localName.equals("insert")) {
                    this.currentString = "";
                }
            }
        };
        try {
            try {
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                parserFactory.setNamespaceAware(true);
                SAXParser parser = parserFactory.newSAXParser();
                XMLReader saxReader = parser.getXMLReader();
                saxReader.setContentHandler((ContentHandler)ich);
                saxReader.parse(new InputSource(this.isDescriptor));
                this.sourceConnection.setConnection();
                Connection conn = this.sourceConnection.getJdbcConnection();
                Throwable throwable = null;
                Object var7_9 = null;
                try (Statement st = conn.createStatement();){
                    st.setFetchSize(1);
                    Throwable throwable2 = null;
                    Object var10_14 = null;
                    try (FileDriverMultiResultSet mRs = new FileDriverMultiResultSet(st);){
                        FileDriverStatement st2 = mRs.getFileDriverStatement();
                        st2.setMetadata(this.metadata);
                        Handler handler = new Handler();
                        for (SelectInsert lst : this.list) {
                            String name = mRs.addQuery(lst.select, (FileDriverMultiResultSet.IResultSetHandler)handler);
                            this.map.put(name, lst);
                        }
                        this.targetConnection.setConnection();
                        while (mRs.next()) {
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        finally {
            if (this.isDescriptor != null) {
                try {
                    this.isDescriptor.close();
                }
                catch (IOException e) {
                    this.logger.warn("unexpected", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void handleBatch() {
    }

    class Handler
    implements FileDriverMultiResultSet.IResultSetHandler {
        int count = 0;
        String name;

        Handler() {
        }

        public void handleResultSet(String name, ResultSet current) throws SQLException {
            if (Thread.interrupted()) {
                throw new SQLException(new InterruptedException());
            }
            SelectInsert si = FileToJdbcActionCodeI.this.map.get(name);
            if (si != null) {
                if (si.ps == null) {
                    List list = BindExpressionReplacer.getLstTxtCodeBindedParameters((String)si.insert, (String)":{", (String)"}:");
                    BindExpressionReplacer.BindedExpressionPlaceHolder expr = BindExpressionReplacer.replaceBindedExpressions((String)si.insert);
                    if (expr.hasSessionVariablesToResolve()) {
                        throw new SQLException("This action does support to resolve variables on bind expressions");
                    }
                    si.insert2 = expr.getBindedExpression();
                    si.ps = FileToJdbcActionCodeI.this.targetConnection.getJdbcConnection().prepareStatement(si.insert2);
                    si.positions = new int[list.size()];
                    ResultSetMetaData rsmd = current.getMetaData();
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    int i = 1;
                    while (i <= rsmd.getColumnCount()) {
                        map.put(rsmd.getColumnLabel(i), i);
                        ++i;
                    }
                    i = 0;
                    for (String str : list) {
                        si.positions[i++] = (Integer)map.get(str);
                    }
                    si.binder = new JdbcBinder(FileToJdbcActionCodeI.this);
                    si.binder.setSetDateAsTimestamp(FileToJdbcActionCodeI.this.targetConnection.isSetDateAsTimestamp());
                    si.binder.setSetNVarcharAsNVarchar(FileToJdbcActionCodeI.this.targetConnection.isSetNVarcharAsVarchar());
                    si.binder.setDisableImplicitConversion(FileToJdbcActionCodeI.this.targetConnection.hasDisableImplicitConversion());
                }
                int i = 1;
                while (i <= si.positions.length) {
                    int j = si.positions[i - 1];
                    try {
                        si.binder.write(j, current, i, si.ps, null, null);
                    }
                    catch (Exception e) {
                        if (!(e instanceof SQLException)) {
                            throw new SQLException(e);
                        }
                        throw (SQLException)e;
                    }
                    ++i;
                }
                si.ps.addBatch();
                ++si.currentBatchSize;
                ++si.batchSize;
                ++FileToJdbcActionCodeI.this.sqlNbRows;
                if (si.batchSize % FileToJdbcActionCodeI.this.targetConnection.getSqlServerBatchSize() == 0) {
                    si.ps.executeBatch();
                    si.currentBatchSize = 0;
                    FileToJdbcActionCodeI.this.handleStatistics(false);
                }
                FileToJdbcActionCodeI.this.targetConnection.commit(FileToJdbcActionCodeI.this.sqlNbRows);
            }
        }
    }

    class SelectInsert {
        String name;
        String select;
        String insert;
        JdbcBinder binder;
        int[] positions;
        public String insert2;
        public PreparedStatement ps;
        public int batchSize;
        public int currentBatchSize = 0;

        SelectInsert() {
        }
    }
}

