/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.ftp.FtpActionCodeI;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretStatement;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.stambia.ftp.FtpSession;
import com.stambia.ftp.utils.FtpStatisticListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FtpExecActionCodeCommandI
extends FtpActionCodeI {
    String ftpRemotePath;
    private String command;
    private Boolean multiCommand;
    private String ftpInputFile;
    private String ftpOutputFile;
    Boolean FTPOutputFileAppend = false;
    private Logger logger = null;

    public FtpExecActionCodeCommandI() {
        this.actionCodeName = "Ftp Get Class";
        this.actionClassName = "FtpGetActionCodeI";
        this.bNullCodeAllowed = true;
    }

    @Override
    public int prepare(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        this.logger = LogManager.getLogger((String)this.runtimeContext.comIndyEngineActionCodes);
        this.multiCommand = this.getLocalBooleanBindedParameter(rSet, "MULTI_COMMANDS", true);
        if (this.actionTxtCode != null && !this.actionTxtCode.equals("")) {
            if (rSet != null) {
                try {
                    this.command = this.getFinalBindedCode(rSet, this.actionTxtCode);
                }
                catch (Exception e) {
                    this.debugLog("prepare", "Exception : " + e.getMessage(), 1, "ERROR");
                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), "Exception : " + e.getMessage(), "String", false);
                    throw new EngineExceptionI((Throwable)e);
                }
            } else {
                this.command = this.actionTxtCode;
            }
        }
        this.debugLog("prepare", Messages.getString("FtpExecActionCodeCommandI.0"), 3, "DEBUG");
        this.ftpHostname = this.getLocalSecretBindedParameter(rSet, "FTP_HOSTNAME", null);
        this.ftpUser = this.getLocalSecretBindedParameter(rSet, "FTP_USER", null);
        if (this.ftpHostname == null || this.ftpUser == null) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), Messages.getString("FtpExecActionCodeCommandI.1"), "String", false);
            throw new EngineExceptionI(Messages.getString("FtpExecActionCodeCommandI.2"));
        }
        this.ftpPassword = this.getLocalSecretBindedParameter(rSet, "FTP_PASSWORD", this.getLocalStringBindedParameter(rSet, "FTP_UNCRYPTED_PASSWORD", ""));
        this.ftpsProtocol = this.getLocalStringBindedParameter(rSet, "FTP_SECURE_PROTOCOL", "NONE");
        this.implicitFTPS = this.getLocalBooleanBindedParameter(rSet, "FTP_IMPLICIT_FTPS", true);
        this.ftpPort = this.getLocalSecretBindedParameter(rSet, "FTP_PORT", null);
        if (this.ftpPort.isNull()) {
            int defauktFtpPort = -1;
            defauktFtpPort = this.ftpsProtocol.equals("NONE") ? 21 : (this.implicitFTPS ? 990 : 21);
            this.ftpPort = this.getLocalSecretBindedParameter(rSet, "FTP_PORT", "" + defauktFtpPort);
            this.secret(new ISecretStatement(){

                public Object execute(ISecretContext context) throws Throwable {
                    FtpExecActionCodeCommandI.this.publishVariable("FTP_PORT", String.valueOf(FtpExecActionCodeCommandI.this.ftpPort.getInteger(context)), "Integer", false);
                    return null;
                }
            });
        }
        this.ftpMode = this.getLocalStringBindedParameter(rSet, "FTP_FILE_MODE", null);
        if (this.ftpMode != null) {
            this.ftpMode = this.ftpMode.toLowerCase(Locale.getDefault());
        }
        this.ftpPassiveMode = this.getLocalBooleanBindedParameter(rSet, "FTP_PASSIVE_MODE", true);
        this.ftpRemotePath = this.getLocalStringBindedParameter(rSet, "FTP_REMOTE_PATH", "");
        this.ftpInputFile = this.getLocalStringBindedParameter(rSet, "FTP_INPUT_FILE", null);
        this.ftpOutputFile = this.getLocalStringBindedParameter(rSet, "FTP_OUTPUT_FILE", null);
        this.FTPOutputFileAppend = this.getLocalBooleanBindedParameter(rSet, "FTP_APPEND_OUTPUT_FILE", false);
        super.prepare(rSet);
        this.debugLog("prepare", this.actionName + Messages.getString("FtpExecActionCodeCommandI.3"), 3, "DEBUG");
        return ret;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    boolean acceptFilter(String filter, String attribute) throws EngineExceptionI {
        Boolean bFinded;
        block6: {
            block5: {
                bFinded = false;
                if (filter != null) break block5;
                return true;
            }
            if (!filter.equals("")) break block6;
            return true;
        }
        try {
            Pattern pDeb = Pattern.compile(filter);
            Matcher mDeb = pDeb.matcher(attribute);
            bFinded = mDeb.matches();
        }
        catch (PatternSyntaxException e) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("FtpExecActionCodeCommandI.4"), "String", false);
            throw new EngineExceptionI(this.actionClassName + Messages.getString("FtpExecActionCodeCommandI.5"));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return bFinded;
    }

    public static void main(String[] args) {
    }

    public int executeSimpleCode() throws EngineExceptionI {
        int ret = 0;
        FtpSession ftpSess = null;
        InputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        PrintWriter out = null;
        try {
            try {
                this.setProxySocketFactory();
                this.connect();
                if (this.ftpPassiveMode) {
                    this.ftp.enterLocalPassiveMode();
                }
                new Date().getTime();
                Boolean changeDirOk = true;
                if (!this.ftpRemotePath.equals("")) {
                    changeDirOk = this.ftp.changeWorkingDirectory(this.ftpRemotePath);
                }
                if (!changeDirOk.booleanValue()) {
                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("FtpExecActionCodeCommandI.6") + this.ftpRemotePath, "String", false);
                    throw new EngineExceptionI(this.actionClassName + Messages.getString("FtpExecActionCodeCommandI.7") + this.ftpRemotePath);
                }
                Object inputFilePath = this.ftpInputFile;
                if (this.ftpInputFile != null && !new File(this.ftpInputFile).isFile()) {
                    String filePath = System.getProperty("user.dir") + File.separator;
                    inputFilePath = filePath + this.ftpInputFile;
                }
                if (this.ftpInputFile != null && new File((String)inputFilePath).isFile()) {
                    String line;
                    this.command = "";
                    fis = new FileInputStream((String)inputFilePath);
                    isr = new InputStreamReader(fis, Charset.forName("UTF-8"));
                    br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        this.command = String.valueOf(this.command) + line + "\n";
                    }
                    this.publishVariable("FILE_COMMAND", this.command, "String");
                }
                if (this.command != null && !this.command.isEmpty()) {
                    ArrayList<String> _cmds = new ArrayList<String>();
                    if (this.multiCommand.booleanValue()) {
                        String[] stringArray = this.command.split("\n");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String _cmd = stringArray[n2];
                            _cmds.add(_cmd);
                            ++n2;
                        }
                    } else {
                        _cmds.add(this.command);
                    }
                    StringBuilder msg = new StringBuilder("");
                    ftpSess = new FtpSession(this.ftp);
                    final HashMap statistics = new HashMap();
                    ftpSess.addListener(new FtpStatisticListener(){

                        public void statisticEvent(FtpStatisticListener.Statistic statistic, long value) {
                            String name = statistic.name();
                            long newValue = value;
                            if (statistics.containsKey(name)) {
                                newValue = (Long)statistics.get(name) + value;
                            }
                            statistics.put(name, newValue);
                        }
                    });
                    ftpSess.setRaiseException(true);
                    int commandSize = _cmds.size();
                    int lastCommandIndex = commandSize - 1;
                    int commandIndex = 0;
                    while (commandIndex < commandSize) {
                        String _command = (String)_cmds.get(commandIndex);
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        String message = ftpSess.executeCommand(_command);
                        msg.append(message);
                        if (commandIndex < lastCommandIndex && !message.endsWith(System.lineSeparator())) {
                            msg.append(System.lineSeparator());
                        }
                        ++commandIndex;
                    }
                    this.publishVariable("RET_MESS", msg, "String");
                    if (this.ftpOutputFile != null) {
                        out = new PrintWriter(new BufferedWriter(new FileWriter(this.ftpOutputFile, (boolean)this.FTPOutputFileAppend)));
                        if (this.FTPOutputFileAppend.booleanValue()) {
                            out.append(msg);
                            this.logger.info(Messages.getString("FtpExecActionCodeCommandI.8") + this.ftpOutputFile);
                        } else {
                            out.println(msg);
                        }
                    }
                    if (statistics != null) {
                        for (Map.Entry statistic : statistics.entrySet()) {
                            String name = (String)statistic.getKey();
                            long value = (Long)statistic.getValue();
                            this.publishCumulativeVariable(name, value, "Integer", false);
                        }
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + "=>executeSimpleCode : " + e.getMessage(), "String", false);
                throw new EngineExceptionI((Throwable)e);
            }
        }
        finally {
            block56: {
                try {
                    try {
                        if (out != null) {
                            out.close();
                        }
                        if (br != null) {
                            br.close();
                        }
                        if (isr != null) {
                            isr.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        try {
                            if (ftpSess != null) {
                                ftpSess.dispose();
                            }
                            if (this.ftp != null && this.ftp.isConnected()) {
                                this.ftp.logout();
                            }
                            break block56;
                        }
                        catch (IOException e2) {
                            this.logger.error(e2.getMessage(), (Throwable)e2);
                        }
                        break block56;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (ftpSess != null) {
                            ftpSess.dispose();
                        }
                        if (this.ftp != null && this.ftp.isConnected()) {
                            this.ftp.logout();
                        }
                    }
                    catch (IOException e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    if (ftpSess != null) {
                        ftpSess.dispose();
                    }
                    if (this.ftp != null && this.ftp.isConnected()) {
                        this.ftp.logout();
                    }
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return ret;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws EngineExceptionI {
        int ret = 0;
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return ret;
    }
}

