/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.utils.BidiMap;
import com.indy.engine.actionCodes.utils.Constant;
import com.indy.engine.actionCodes.utils.IndyContentHandler;
import com.indy.engine.actionCodes.utils.XmlDataTypeProvider;
import com.indy.engine.actionCodes.xml.unload.AbstractXmlWriterAPI;
import com.indy.engine.actionCodes.xml.unload.XmlWriterAPI;
import com.indy.engine.common.tools.OutputStreamTransformer;
import com.indy.engine.common.tools.impl.JavaObjectHandler;
import com.indy.engine.common.tools.impl.JavaRealObjectHandler;
import com.indy.engine.common.tools.internal.JavaGenericOperation;
import com.indy.engine.common.tools.internal.JavaGenericOutputStreamTransformer;
import com.indy.engine.core.IScriptingEngineProvider;
import com.indy.engine.core.ISessionContext;
import com.indy.engine.core.actionCodes.convert.AbstractDataTypeConverter;
import com.indy.engine.core.module.classloader.ClassLoaderServiceProvider;
import com.indy.runtime.json.JsonUtils;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JdbcToXmlActionCodeI
extends ActionCodeTypeI {
    private boolean forceWritemode = false;
    private int flushFrequency = 100000;
    private int statisticFrequency = 100000;
    protected boolean handleStatisticAndLog = true;
    private int totalElements;
    private int totalAttributes;
    private int totalLines;
    private long totalQueryTime;
    private long totalGenarationTime;
    private TreeMap<String, IndyResultSet> resultSets;
    private IndyElement root;
    private InputStream is;
    BidiMap<String, String> namespaces = new BidiMap();
    private String targetNamespace;
    private boolean prefixForElement;
    private boolean prefixForAttribute;
    private File temporaryFolder;
    Map<String, IndyItem> tags = new HashMap<String, IndyItem>();
    private String fileMask;
    private String superRoot;
    private long totalSize;
    private boolean writeXmlDescriptor;
    private Integer fetchSize;
    protected boolean commit;
    private AbstractXmlWriterAPI xwa;
    private boolean writeMetaDataAttribut;
    private boolean useDoubleQuotesInXmlDeclaration;
    private String elementToKeep;
    private boolean writeKeyValue;
    private String disableBranchs;
    private int nbexecutedQuerys;
    private String outFileNameVar;
    private boolean nillableIsForce;
    private String xsiPrefix;
    private boolean defaultNillable;
    AbstractDataTypeConverter dataTypeProvider;
    private Boolean forceUsedCData = false;
    AbstractXmlWriterAPI.NoDataBehaviour noDataBehaviour = AbstractXmlWriterAPI.NoDataBehaviour.deleteExistingFile;
    AbstractXmlWriterAPI.FileAlreadyExistsBehaviour fileAlreadyExistsBehaviour = AbstractXmlWriterAPI.FileAlreadyExistsBehaviour.replace;
    private boolean isWriteNullJsonNode = false;
    private boolean isWriteEmptyJsonNode = false;
    private boolean isJsonLinesFormat = false;
    boolean defaultWriteXsiType = false;
    private String emptyValueKeyWord;
    private String attributeNullValueReplacement;
    private boolean useJsonWriter = false;
    private OutputStreamTransformerInitalizer osti;
    static final int FORCE_NILLABLE_TO_TRUE = 1;
    static final int FORCE_NILLABLE_TO_FALSE = 2;
    static final int NILLABLE_TO_TRUE = 4;
    static final int NILLABLE_TO_DEFAULT = 0;
    static Templates templates;
    private static final Object templatesLock;
    public static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String JSON_URI = "http://www.stambia.com/2014/json";
    private String jsonPrefix = null;
    private boolean writeJsonAttributes = false;
    Map<String, Long> previousStat = new HashMap<String, Long>();
    boolean opening = false;
    int nbFiles;
    int previousNbFiles = 0;
    IndyElement jsonRootElement;
    List<Object> eltsToOpen = new ArrayList<Object>();
    List<IndyElement> eltsToClose = new ArrayList<IndyElement>();
    boolean hasXsiAttribute = false;
    boolean hasRawData;

    static {
        templatesLock = new Object();
    }

    public JdbcToXmlActionCodeI() {
        super("Java Jdbc to Xml Class", false);
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return 0;
    }

    protected int prepare(ResultSet rs) throws EngineExceptionI {
        String jsonEscapeSlashCharacter;
        int ret = 0;
        String overload = this.getLocalStringBindedParameter(rs, "OVERRIDE_ACTION_PARAMETERS", null);
        if (overload != null) {
            Properties prop = new Properties();
            try {
                prop.load(new ByteArrayInputStream(overload.getBytes()));
                this.fillOverLoadParameters(prop);
            }
            catch (IOException e) {
                this.logger.error("Error during loading overload parameters", (Throwable)e);
            }
        }
        this.outFileNameVar = this.getLocalStringBindedParameter(rs, "OUT_FILE_NAME_VAR", null);
        this.connectionName = this.getLocalStringBindedParameter(rs, "SQL_CONNECTION", "");
        this.sqlTransName = this.getLocalStringBindedParameter(rs, "SQL_TRANSACTION_NAME", "T1");
        this.setTransactionAndCommit(this.getLocalStringBindedParameter(rs, "SQL_TRANSACTION_TYPE", null), true);
        this.is = new ByteArrayInputStream(this.actionTxtCode.getBytes(StandardCharsets.UTF_8));
        this.writeXmlDescriptor = this.getLocalBooleanBindedParameter(rs, "WRITE_XML_DESCRIPTOR", false);
        String tempFolder = this.getStringParameter(this.runtimeContext.VAR_PREFIXE + Constant.VAR_CORE_TEMPORARY_FOLDER);
        this.temporaryFolder = Path.of(tempFolder, "JdbcToXmlActionCodeLog").toFile();
        if (!this.temporaryFolder.exists()) {
            this.temporaryFolder.mkdirs();
        }
        this.fileMask = this.getLocalStringBindedParameter(rs, "OUT_FILE_MASK", null);
        this.superRoot = this.getLocalStringBindedParameter(rs, "SUPER_ROOT_NAME", null);
        if (this.superRoot != null && this.superRoot.equals("<disable>")) {
            this.superRoot = null;
        }
        this.fetchSize = this.getLocalIntegerBindedParameter(rs, "SQL_FETCH_SIZE", this.runtimeContext.DEFAULT_FETCH_SIZE);
        this.writeMetaDataAttribut = this.getLocalBooleanBindedParameter(rs, "WRITE_METADATA_ATTRIBUTS", false);
        this.useDoubleQuotesInXmlDeclaration = this.getLocalBooleanBindedParameter(rs, "USE_DOUBLE_QUOTES_IN_XML_DECLARATION", false);
        this.commit = this.getLocalBooleanBindedParameter(rs, "XML_COMMIT", true);
        String xmlVersion = this.getLocalStringBindedParameter(rs, "WRITE_XML_VERSION", "1.0");
        String encoding = this.getLocalStringBindedParameter(rs, "OUT_FILE_ENCODING", null);
        this.elementToKeep = this.getLocalStringBindedParameter(rs, "KEEP_ELEMENTS", "").replace(" ", "");
        this.writeKeyValue = this.getLocalBooleanBindedParameter(rs, "WRITE_KEY_VALUES", false);
        this.isJsonLinesFormat = this.getLocalBooleanBindedParameter(rs, "JSON_LINES_FORMAT", false);
        if (encoding != null && encoding.isEmpty()) {
            encoding = null;
        }
        boolean writeXmlDeclaration = this.getLocalBooleanBindedParameter(rs, "WRITE_XML_DECLARATION", true);
        Object inputFile = this.getLocalStringBindedParameter(rs, "OUT_FILE_NAME");
        if (inputFile != null && ((String)inputFile).startsWith("<tempDir>")) {
            File localTempFolder = new File(tempFolder);
            if (!localTempFolder.exists()) {
                localTempFolder.mkdirs();
            }
            inputFile = String.valueOf(localTempFolder) + File.separator + ((String)inputFile).substring(9);
        }
        File outFile = new File((String)inputFile);
        String xmlOutPutFactoryClassName = this.getLocalStringBindedParameter(rs, "XML_OUTPUT_FACTORY", null);
        String xmlOutPutFactoryModule = this.getLocalStringBindedParameter(rs, "XML_OUTPUT_FACTORY_MODULE", null);
        if (xmlOutPutFactoryClassName == null) {
            xmlOutPutFactoryClassName = this.getLocalStringBindedParameter(rs, "XML_FACTORY_CLASS_NAME", null);
        }
        if (xmlOutPutFactoryClassName != null && xmlOutPutFactoryClassName.contains("Json")) {
            this.useJsonWriter = true;
        }
        if (xmlOutPutFactoryClassName != null && xmlOutPutFactoryClassName.matches("Bson")) {
            this.useJsonWriter = true;
        }
        this.handleStatisticAndLog = true;
        this.noDataBehaviour = AbstractXmlWriterAPI.NoDataBehaviour.valueOf(this.getLocalStringBindedParameter(rs, "NO_DATA_BEHAVIOUR", AbstractXmlWriterAPI.NoDataBehaviour.deleteExistingFile.name()));
        this.fileAlreadyExistsBehaviour = AbstractXmlWriterAPI.FileAlreadyExistsBehaviour.valueOf(this.getLocalStringBindedParameter(rs, "FILE_EXISTS_BEHAVIOUR", AbstractXmlWriterAPI.FileAlreadyExistsBehaviour.replace.name()));
        String streamHookOne = this.getLocalStringBindedParameter(rs, "STREAM_HOOK_01", null);
        if (streamHookOne != null) {
            this.osti = new OutputStreamTransformerInitalizer();
            this.osti.init(streamHookOne, this, this.engineContext, this.useJsonWriter, this::handleStatistic, (Map)this.namespaces);
        } else {
            this.osti = null;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String json = this.getLocalStringBindedParameter(rs, "XML_OUTPUT_FACTORY.property.AVRO_SCHEMA", null);
        if (json != null) {
            properties.put("AVRO_SCHEMA", json);
        }
        if ("Disable".equals(jsonEscapeSlashCharacter = this.getLocalStringBindedParameter(rs, "JSON_ESCAPE_SLASH_CHARACTER", "Enable"))) {
            properties.put("JSON_ESCAPE_SLASH_CHARACTER", jsonEscapeSlashCharacter);
        }
        if (this.useDoubleQuotesInXmlDeclaration) {
            properties.put("com.ctc.wstx.useDoubleQuotesInXmlDecl", this.useDoubleQuotesInXmlDeclaration);
        }
        this.xwa = this.createWriter(encoding, writeXmlDeclaration, xmlVersion, xmlOutPutFactoryModule, xmlOutPutFactoryClassName, outFile, properties, this.isJsonLinesFormat);
        this.disableBranchs = this.getLocalStringBindedParameter(rs, "DISABLE_BRANCHS", "");
        String localNillable = this.getLocalStringBindedParameter(rs, "NIL_BEHAVIOUR", "FalseIfNotDefined");
        this.defaultNillable = false;
        if (localNillable.equals("TrueIfNotDefined") || localNillable.equals("ForceToTrue")) {
            this.defaultNillable = true;
        }
        if (localNillable.equals("ForceToFalse") || localNillable.equals("ForceToTrue")) {
            this.nillableIsForce = true;
        }
        String jsonNodeNullBehaviour = this.getLocalStringBindedParameter(rs, "JSON_NODE_NULL_BEHAVIOUR", "Do Not Write Node");
        this.isWriteNullJsonNode = jsonNodeNullBehaviour.equals("Write Null Node");
        this.isWriteEmptyJsonNode = jsonNodeNullBehaviour.equals("Write Empty Node");
        this.defaultWriteXsiType = this.getLocalBooleanBindedParameter(rs, "ADD_XSI_TYPE", false);
        this.forceUsedCData = this.getLocalBooleanBindedParameter(rs, "FORCE_USED_CDATA", false);
        String dataTypeProviderClassName = this.getLocalStringBindedParameter(rs, "DATA_TYPE_PROVIDER", null);
        if (dataTypeProviderClassName != null) {
            try {
                String dataTypeProviderModule = this.getLocalStringBindedParameter(rs, "DATA_TYPE_PROVIDER_MODULE", null);
                ClassLoader cl = dataTypeProviderModule != null ? ClassLoaderServiceProvider.instance().getClassLoader(dataTypeProviderModule, dataTypeProviderClassName) : ((Object)((Object)this)).getClass().getClassLoader();
                Class<?> clazz = cl.loadClass(dataTypeProviderClassName);
                this.dataTypeProvider = (AbstractDataTypeConverter)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new EngineExceptionI(Messages.getString("JdbcToXmlActionCodeI.0") + dataTypeProviderClassName, (Throwable)e);
            }
        } else {
            this.dataTypeProvider = new XmlDataTypeProvider();
        }
        this.emptyValueKeyWord = this.getLocalStringBindedParameter(rs, "EMPTY_VALUE_KEYWORD", null);
        this.attributeNullValueReplacement = this.getLocalStringBindedParameter(rs, "ATTRIBUTE_NULL_VALUE_REPLACEMENT", null);
        this.clearOverLoadParameters();
        return ret;
    }

    public int finalizeExecuteCode() throws EngineExceptionI {
        int ret = 0;
        this.debugLog(Messages.getString("JdbcToXmlActionCodeI.1"), Messages.getString("JdbcToXmlActionCodeI.2") + this.totalLines, this.runtimeContext.LOG_LEVEL1, this.runtimeContext.LOG_INFO);
        this.debugLog(Messages.getString("JdbcToXmlActionCodeI.3"), Messages.getString("JdbcToXmlActionCodeI.4") + this.totalElements, this.runtimeContext.LOG_LEVEL1, this.runtimeContext.LOG_INFO);
        this.debugLog(Messages.getString("JdbcToXmlActionCodeI.5"), Messages.getString("JdbcToXmlActionCodeI.6") + this.totalAttributes, this.runtimeContext.LOG_LEVEL1, this.runtimeContext.LOG_INFO);
        this.debugLog(Messages.getString("JdbcToXmlActionCodeI.7"), Messages.getString("JdbcToXmlActionCodeI.8") + this.totalAttributes, this.runtimeContext.LOG_LEVEL1, this.runtimeContext.LOG_INFO);
        this.debugLog(Messages.getString("JdbcToXmlActionCodeI.9"), Messages.getString("JdbcToXmlActionCodeI.10") + this.totalQueryTime, this.runtimeContext.LOG_LEVEL1, this.runtimeContext.LOG_INFO);
        this.debugLog(Messages.getString("JdbcToXmlActionCodeI.11"), Messages.getString("JdbcToXmlActionCodeI.12") + this.totalGenarationTime, this.runtimeContext.LOG_LEVEL1, this.runtimeContext.LOG_INFO);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformSource3(InputStream inputStream, OutputStream os) throws EngineExceptionI {
        try {
            Object object = templatesLock;
            synchronized (object) {
                if (templates == null) {
                    InputStream xslID = JdbcToXmlActionCodeI.class.getClassLoader().getResourceAsStream("com/indy/engine/actionCodes/a/a.xsl");
                    TransformerFactory tfactory = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
                    tfactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                    tfactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                    tfactory.setURIResolver(new URIResolver(){

                        @Override
                        public Source resolve(String href, String base) throws TransformerException {
                            File file = new File("build/xsl/" + href);
                            if (file.exists()) {
                                try {
                                    return new SAXSource(new InputSource(new FileInputStream(file)));
                                }
                                catch (FileNotFoundException e) {
                                    throw new TransformerException(e);
                                }
                            }
                            return new SAXSource(new InputSource(JdbcToXmlActionCodeI.class.getClassLoader().getResourceAsStream("com/indy/engine/actionCodes/a/" + href)));
                        }
                    });
                    templates = tfactory.newTemplates(new StreamSource(xslID));
                }
            }
            Transformer transformer = templates.newTransformer();
            final ArrayList errors = new ArrayList();
            final ArrayList warnings = new ArrayList();
            transformer.setErrorListener(new ErrorListener(){

                @Override
                public void warning(TransformerException arg0) throws TransformerException {
                    warnings.add(arg0);
                }

                @Override
                public void fatalError(TransformerException arg0) throws TransformerException {
                    errors.add(arg0);
                }

                @Override
                public void error(TransformerException arg0) throws TransformerException {
                    errors.add(arg0);
                }
            });
            transformer.setParameter("elementsToKeep", this.elementToKeep);
            transformer.setParameter("branchsToDisable", this.disableBranchs);
            transformer.transform(new StreamSource(inputStream), new StreamResult(os));
            if (!errors.isEmpty()) {
                throw new EngineExceptionI((Throwable)errors.get(0));
            }
        }
        catch (TransformerException e1) {
            throw new EngineExceptionI((Throwable)e1);
        }
    }

    public void buildMemoryTree(InputStream is) throws EngineExceptionI {
        try {
            this.resultSets = new TreeMap();
            HashMap<String, IndyQuerySet> querySets = new HashMap<String, IndyQuerySet>();
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            parserFactory.setFeature("http://xml.org/sax/features/validation", false);
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader saxReader = parser.getXMLReader();
            SimpleContentHandler sch = new SimpleContentHandler(this.resultSets, querySets);
            saxReader.setContentHandler((ContentHandler)((Object)sch));
            saxReader.parse(new InputSource(is));
            this.root = sch.root;
            this.updateNamespace(this.root);
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    private void updateNamespace(IndyItem item) {
        if (!item.disablePrefix) {
            boolean enable;
            String namespace = item.namespace != null ? item.namespace : this.targetNamespace;
            boolean bl = enable = item == this.root || item.forcePrefix || this.prefixForElement && item instanceof IndyElement || this.prefixForAttribute && item instanceof IndyAttribute || namespace != null && this.targetNamespace == null || namespace != null && !namespace.equals(this.targetNamespace);
            if (namespace != null && enable) {
                item.namespace = namespace;
                item.prefix = (String)this.namespaces.getFrom((Object)namespace);
            }
        }
        if (item instanceof IndyElement) {
            ((IndyElement)item).elements.stream().forEach(this::updateNamespace);
            ((IndyElement)item).attributes.stream().forEach(this::updateNamespace);
        }
    }

    public void connection() {
        for (IndyResultSet rs : this.resultSets.values()) {
            rs.connection = this.jdbcConnection;
        }
    }

    public void handleDataStatistics(boolean last) {
        if (this.handleStatisticAndLog) {
            this.publishStatistic("SQL_NB_ROWS", this.totalLines, last);
            this.publishStatistic("XML_NB_ELEMENTS", this.totalElements, last);
            this.publishStatistic("XML_NB_ATTRIBUTES", this.totalAttributes, last);
        }
    }

    private void handleStatistic(String name, long value) {
        if (this.handleStatisticAndLog) {
            Long currentValue = this.previousStat.get(name);
            if (currentValue == null) {
                currentValue = value;
            } else {
                currentValue = currentValue + value;
                this.previousStat.put(name, currentValue);
            }
            this.publishCumulativeVariable(name, currentValue, "Long", false);
        }
    }

    public void handleFileStatistics(boolean last) {
        if (this.handleStatisticAndLog) {
            this.publishStatistic("OUT_FILE_SIZE", this.totalSize, last);
            this.publishStatistic("OUT_NB_FILES", this.nbFiles, last);
        }
    }

    public void handleQueryStatistics(boolean last) {
        if (this.handleStatisticAndLog) {
            this.publishStatistic("SQL_QUERYS_DURATION", this.totalQueryTime, last);
            this.publishStatistic("SQL_EXECUTED_QUERYS_NB", this.nbexecutedQuerys, last);
        }
    }

    public void startNewDocument() throws XMLStreamException, IOException {
        this.opening = this.xwa.startNewDocument(this.hasRawData);
        this.xwa.getXMLStreamWriter().setNamespaceContext(new NamespaceContext(){

            public Iterator getPrefixes(String namespaceURI) {
                return null;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return (String)JdbcToXmlActionCodeI.this.namespaces.getFrom((Object)namespaceURI);
            }

            @Override
            public String getNamespaceURI(String prefix) {
                return (String)JdbcToXmlActionCodeI.this.namespaces.getTo((Object)prefix);
            }
        });
    }

    public void endCurrentDocument(File file) throws Exception {
        boolean create = this.xwa.endCurrentDocument(file);
        if (create) {
            ++this.nbFiles;
            this.totalSize += file.length();
        }
        if (this.outFileNameVar != null) {
            this.engineContext.addVariable(this.outFileNameVar, this.actionContext.getActionName(), (Object)file.getAbsolutePath(), "string", false, false);
        }
        this.handleFileStatistics(false);
        this.handleDataStatistics(false);
        this.handleQueryStatistics(false);
    }

    public void write() throws EngineExceptionI {
        long start = System.currentTimeMillis();
        try {
            try {
                this.root.write();
            }
            catch (EngineExceptionI e) {
                throw e;
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        finally {
            try {
                this.xwa.close();
            }
            catch (Exception e) {
                this.getActionCodeLogger().warn(Messages.getString("JdbcToXmlActionCodeI.13"), (Throwable)e);
            }
            try {
                if (this.root != null) {
                    this.root.closeAllResultSet();
                }
            }
            catch (Exception e) {
                this.getActionCodeLogger().warn(Messages.getString("JdbcToXmlActionCodeI.14"), (Throwable)e);
            }
        }
        this.totalGenarationTime = System.currentTimeMillis() - start - this.totalQueryTime;
    }

    private void writeXmlDescritor(File file, InputStream inputStream) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));){
            byte[] buf = new byte[1024];
            int num = 0;
            while ((num = inputStream.read(buf)) != -1) {
                ((OutputStream)fos).write(buf, 0, num);
            }
            ((OutputStream)fos).write(10);
            ((OutputStream)fos).flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public int executeSimpleCode() throws EngineExceptionI {
        if (this.connectionName != null && !this.connectionName.equals("")) {
            this.write(this.sessionName, this.actionClassName + "=>executeSimpleCode", this.actionName + Messages.getString("JdbcToXmlActionCodeI.15") + this.connectionName, 3, this.actionLevel, "DEBUG");
            this.jdbcConnection = this.setConnection(this.connectionName, this.sqlTransName, this.sqlTransType);
            try {
                ActionCodeTypeI.setAutoCommit((Connection)this.jdbcConnection, (boolean)this.isAutoCommit());
            }
            catch (SQLException e) {
                this.logger.error("Failed to set autoCommit", (Throwable)e);
            }
            this.isRdbmsLinked = true;
        }
        this.dataTypeProvider.setGetDateHasTimestamp(this.getDateAsTimestamp);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String timeStamp = Long.toString(System.currentTimeMillis());
        if (this.writeXmlDescriptor) {
            try {
                this.writeXmlDescritor(Path.of(this.temporaryFolder.getAbsolutePath(), timeStamp + "_descriptor1.xml").toFile(), this.is);
                this.is.reset();
            }
            catch (IOException e) {
                this.logger.error("Failed to write xmlDescriptor1", (Throwable)e);
            }
        }
        this.transformSource3(this.is, out);
        if (this.writeXmlDescriptor) {
            try {
                this.writeXmlDescritor(Path.of(this.temporaryFolder.getAbsolutePath(), timeStamp + "_descriptor2.xml").toFile(), new ByteArrayInputStream(out.toByteArray()));
                this.is.reset();
            }
            catch (IOException e) {
                this.logger.error("Failed to write xmlDescriptor1", (Throwable)e);
            }
        }
        this.buildMemoryTree(new ByteArrayInputStream(out.toByteArray()));
        this.flushFrequency = 10000;
        this.connection();
        this.addAdditionnalNamespaces();
        ClassLoader cl2 = null;
        if (this.osti != null && this.osti.streamHookOneCL != null) {
            cl2 = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.osti.streamHookOneCL);
        }
        try {
            try {
                this.write();
            }
            catch (EngineExceptionI e) {
                if (this.xwa.getWrapperException() != null && e.getCause() instanceof IOException) {
                    throw new EngineExceptionI((Throwable)this.xwa.getWrapperException());
                }
                throw e;
            }
        }
        finally {
            if (cl2 != null) {
                Thread.currentThread().setContextClassLoader(cl2);
            }
        }
        if (this.xwa.getWrapperException() != null) {
            throw new EngineExceptionI((Throwable)this.xwa.getWrapperException());
        }
        this.handleDataStatistics(true);
        this.handleQueryStatistics(true);
        this.handleFileStatistics(true);
        return 0;
    }

    boolean openEltToOpen(XMLStreamWriter xmlw) throws Exception {
        boolean justOpen = false;
        int i = 0;
        while (i < this.eltsToOpen.size()) {
            Object item = this.eltsToOpen.get(i);
            if (item instanceof IndyElement) {
                IndyElement elt = (IndyElement)item;
                if (!elt.isRoot || this.opening) {
                    this.xwa.writeStartElement(elt);
                    if ((this.defaultWriteXsiType || elt.writeXsiType) && elt.type != null && !elt.type.isEmpty()) {
                        xmlw.writeAttribute(this.xsiPrefix, XSI_URI, "type", elt.type);
                    }
                    if (elt instanceof IndyElement && elt.isJsonArray) {
                        xmlw.writeAttribute(this.xsiPrefix, XSI_URI, "type", this.jsonPrefix + ":array");
                        if (this.jsonRootElement == null) {
                            this.jsonRootElement = elt;
                        }
                    }
                    if (elt instanceof IndyElement && elt.isJsonObject) {
                        xmlw.writeAttribute(this.xsiPrefix, XSI_URI, "type", this.jsonPrefix + ":object");
                        if (this.jsonRootElement == null) {
                            this.jsonRootElement = elt;
                        }
                    }
                    if (elt.isRoot && this.superRoot == null) {
                        for (String prefix : this.namespaces.keySet()) {
                            String nameSpaceUri = (String)this.namespaces.getTo((Object)prefix);
                            if (prefix != null) {
                                xmlw.writeNamespace(prefix, nameSpaceUri);
                                continue;
                            }
                            if (this.targetNamespace == null || !nameSpaceUri.equals(this.targetNamespace)) continue;
                            xmlw.writeDefaultNamespace(this.targetNamespace);
                        }
                    }
                    if (elt.isRoot && this.writeMetaDataAttribut) {
                        xmlw.writeNamespace("md", "http://www.stambia.com/md");
                    }
                    if (elt.staticStartItem != null && !elt.staticStartItem.isEmpty()) {
                        for (StaticItem _item : elt.staticStartItem) {
                            _item.write(this.xwa.getXMLStreamWriter());
                        }
                    }
                    if (i == this.eltsToOpen.size() - 1) {
                        justOpen = true;
                    } else if (elt.staticEndItem != null && !elt.staticEndItem.isEmpty()) {
                        for (StaticItem _item : elt.staticEndItem) {
                            _item.write(this.xwa.getXMLStreamWriter());
                        }
                    }
                }
                if (!elt.isRoot || !this.opening || this.commit) {
                    this.eltsToClose.add(elt);
                }
                ++this.totalElements;
            } else {
                Map staticAttribute = (Map)item;
                for (Map.Entry e : staticAttribute.entrySet()) {
                    if (((String)e.getKey()).startsWith("md:")) {
                        this.xwa.getXMLStreamWriter().writeAttribute((String)e.getKey(), (String)e.getValue());
                    } else {
                        this.xwa.getXMLStreamWriter().writeAttribute("md", "http://www.stambia.com/md", (String)e.getKey(), (String)e.getValue());
                    }
                    ++this.totalAttributes;
                }
            }
            if ((this.totalAttributes + this.totalElements) % this.flushFrequency == 0) {
                this.xwa.getXMLStreamWriter().flush();
            }
            if ((this.totalAttributes + this.totalElements + this.totalLines) % this.statisticFrequency == 0) {
                this.handleDataStatistics(false);
            }
            ++i;
        }
        this.eltsToOpen.clear();
        return justOpen;
    }

    static boolean equals(Object value1, Object value2) {
        if (value1 == null) {
            return value2 == null;
        }
        if (value2 == null) {
            return false;
        }
        String str1 = value1.toString();
        String str2 = value2.toString();
        return str1.equals(str2);
    }

    public void stopAction(Thread th) {
        this.setStoppingAction(true);
        if (this.root != null) {
            try {
                this.root.interrupAllResultSet();
            }
            catch (EngineExceptionI e) {
                this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", this.actionName + " : Exception\n" + e.getMessage(), 1, this.actionLevel, "ERROR");
            }
        }
        if (th != null) {
            if (this.xwa != null) {
                this.xwa.interrupt();
            }
            th.interrupt();
        }
    }

    protected AbstractXmlWriterAPI createWriter(String _encoding, boolean writeXmlDeclaration, String xmlVersion, String xmlOutPutFactoryModule, String xmlOutPutFactoryClassName, File outFile, Map<String, Object> properties) {
        return new XmlWriterAPI(this.commit, _encoding, writeXmlDeclaration, xmlVersion, xmlOutPutFactoryModule, xmlOutPutFactoryClassName, outFile, this, this.noDataBehaviour, this.fileAlreadyExistsBehaviour, this.osti != null ? this.osti.streamHookOne : null, properties){

            @Override
            public IndyElement getRoot() {
                return JdbcToXmlActionCodeI.this.root;
            }
        };
    }

    protected AbstractXmlWriterAPI createWriter(String _encoding, boolean writeXmlDeclaration, String xmlVersion, String xmlOutPutFactoryModule, String xmlOutPutFactoryClassName, File outFile, Map<String, Object> properties, boolean isJsonLinesFormat) {
        if (isJsonLinesFormat) {
            return new XmlWriterAPI(this.commit, _encoding, writeXmlDeclaration, xmlVersion, xmlOutPutFactoryModule, xmlOutPutFactoryClassName, outFile, this, this.noDataBehaviour, this.fileAlreadyExistsBehaviour, this.osti != null ? this.osti.streamHookOne : null, properties){

                @Override
                public IndyElement getRoot() {
                    return null;
                }
            };
        }
        return this.createWriter(_encoding, writeXmlDeclaration, xmlVersion, xmlOutPutFactoryModule, xmlOutPutFactoryClassName, outFile, properties);
    }

    void addAdditionnalNamespaces() {
        if (this.defaultWriteXsiType || this.hasXsiAttribute) {
            this.xsiPrefix = (String)this.namespaces.getFrom((Object)XSI_URI);
            if (this.xsiPrefix == null) {
                this.xsiPrefix = this.namespaces.getTo((Object)"xsi") != null ? "stbXsi" : "xsi";
                this.namespaces.put((Object)this.xsiPrefix, (Object)XSI_URI);
            }
        }
        if (this.writeJsonAttributes) {
            this.jsonPrefix = (String)this.namespaces.getFrom((Object)JSON_URI);
            if (this.jsonPrefix == null) {
                this.jsonPrefix = this.namespaces.getTo((Object)"json") != null ? "stbJson" : "json";
                this.namespaces.put((Object)this.jsonPrefix, (Object)JSON_URI);
            }
        }
    }

    public class IndyAttribute
    extends IndyItem {
        public String getValue() throws EngineExceptionI {
            if (this.resultSet != null) {
                return this.resultSet.getValue(this.getAlias());
            }
            return null;
        }

        public boolean write() throws XMLStreamException, EngineExceptionI {
            if (this.resultSet == null) {
                return false;
            }
            boolean justOpen = false;
            String value = this.resultSet.getValue(this.getAlias());
            if (value == null && JdbcToXmlActionCodeI.this.attributeNullValueReplacement != null) {
                value = JdbcToXmlActionCodeI.this.attributeNullValueReplacement;
            }
            if (value != null) {
                if (this.isTagged && this.valueTag == null) {
                    this.valueTag = value;
                }
                try {
                    justOpen = JdbcToXmlActionCodeI.this.openEltToOpen(JdbcToXmlActionCodeI.this.xwa.getXMLStreamWriter());
                    JdbcToXmlActionCodeI.this.xwa.writeAttribute(this, value, this.resultSet.currentValue, this.resultSet.currentType);
                }
                catch (Exception e) {
                    throw new EngineExceptionI(Messages.getString("JdbcToXmlActionCodeI.16") + this.name + Messages.getString("JdbcToXmlActionCodeI.17") + value + "\"", (Throwable)e);
                }
                ++JdbcToXmlActionCodeI.this.totalAttributes;
                if ((JdbcToXmlActionCodeI.this.totalAttributes + JdbcToXmlActionCodeI.this.totalElements) % JdbcToXmlActionCodeI.this.flushFrequency == 0) {
                    JdbcToXmlActionCodeI.this.xwa.getXMLStreamWriter().flush();
                }
                if ((JdbcToXmlActionCodeI.this.totalAttributes + JdbcToXmlActionCodeI.this.totalElements + JdbcToXmlActionCodeI.this.totalLines) % JdbcToXmlActionCodeI.this.statisticFrequency == 0) {
                    JdbcToXmlActionCodeI.this.handleDataStatistics(false);
                }
            }
            return justOpen;
        }
    }

    public class IndyElement
    extends IndyItem {
        boolean isKey;
        boolean isRoot;
        List<IndyAttribute> attributes;
        List<IndyAttribute> internalProperty;
        List<IndyElement> elements;
        boolean useCDATA;
        IndyQuerySet tmp;
        boolean isLast;
        boolean isNillable;
        List<StaticItem> staticStartItem;
        List<StaticItem> staticEndItem;
        boolean doNext;
        private int position;
        int hasNext;
        Collection<IndyResultSet> allResultSet;
        Map<String, String> staticAttributes;
        boolean isFirstElement;
        boolean isJsonArray;
        boolean isJsonObject;

        public IndyElement() {
            this.isKey = false;
            this.isRoot = false;
            this.attributes = new ArrayList<IndyAttribute>();
            this.internalProperty = new ArrayList<IndyAttribute>();
            this.elements = new ArrayList<IndyElement>();
            this.isNillable = false;
            this.staticStartItem = new ArrayList<StaticItem>();
            this.staticEndItem = new ArrayList<StaticItem>();
            this.doNext = false;
            this.position = -1;
            this.hasNext = -1;
            this.isJsonArray = false;
            this.isJsonObject = false;
        }

        private File getOutFile() {
            return JdbcToXmlActionCodeI.this.xwa.getOutFile();
        }

        public void setNillable(boolean isNillable) {
            this.isNillable = isNillable;
            if (isNillable && !JdbcToXmlActionCodeI.this.hasXsiAttribute) {
                JdbcToXmlActionCodeI.this.hasXsiAttribute = true;
            }
        }

        public Collection<IndyResultSet> getAllResultSets() {
            if (this.allResultSet != null) {
                return this.allResultSet;
            }
            this.allResultSet = new HashSet<IndyResultSet>();
            for (IndyElement elt : this.elements) {
                this.allResultSet.addAll(elt.getAllResultSets());
            }
            if (this.resultSet != null) {
                this.allResultSet.add(this.resultSet);
            }
            return this.allResultSet;
        }

        public boolean hasNext() {
            if (this.hasNext != -1) {
                return this.hasNext == 1;
            }
            if (this.doNext) {
                this.hasNext = 1;
                return true;
            }
            for (IndyElement elt : this.elements) {
                if (!elt.hasNext()) continue;
                this.hasNext = 1;
                return true;
            }
            this.hasNext = 0;
            return false;
        }

        public File defineNewFile() {
            String localFileMask = JdbcToXmlActionCodeI.this.fileMask;
            if (localFileMask == null && JdbcToXmlActionCodeI.this.superRoot == null && !JdbcToXmlActionCodeI.this.isJsonLinesFormat && (this.position > 0 || this.position == 0 && !this.resultSet.isEndeded())) {
                localFileMask = "[POSITION]-[FILE_NAME]";
            }
            if (localFileMask != null) {
                String filename = localFileMask;
                for (Map.Entry<String, IndyItem> entry : JdbcToXmlActionCodeI.this.tags.entrySet()) {
                    if (entry.getValue().valueTag == null) continue;
                    filename = filename.replace("[" + entry.getKey() + "]", entry.getValue().valueTag.replace("\\", "\\\\").replaceAll("[<>*\\?\\|\"]", "_").replaceAll(Pattern.quote("$"), Matcher.quoteReplacement("\\$")));
                }
                filename = filename.replace("[TIMESTAMP]", Long.toString(System.currentTimeMillis()));
                if (this.getOutFile().getName().lastIndexOf(".") > -1) {
                    String extension = this.getOutFile().getName().substring(this.getOutFile().getName().lastIndexOf(".") + 1);
                    String nameWithOutExtension = this.getOutFile().getName().substring(0, this.getOutFile().getName().lastIndexOf("."));
                    filename = filename.replace("[FILE_SHORT_NAME]", nameWithOutExtension);
                    filename = filename.replace("[FILE_EXTENSION]", extension);
                }
                filename = filename.replace("[POSITION]", Integer.toString(this.position));
                File file = new File(filename = filename.replace("[FILE_NAME]", this.getOutFile().getName()));
                if (!file.isAbsolute()) {
                    file = Path.of(this.getOutFile().getParent(), filename).toFile();
                }
                for (IndyItem item : JdbcToXmlActionCodeI.this.tags.values()) {
                    item.valueTag = null;
                }
                return file;
            }
            return this.getOutFile();
        }

        public void write() throws Exception {
            boolean isChangeJsonNodeBehaviour;
            JdbcToXmlActionCodeI.this.interruptedException();
            boolean stop = false;
            if (this.isRoot && (this.resultSet == null || JdbcToXmlActionCodeI.this.superRoot != null)) {
                JdbcToXmlActionCodeI.this.startNewDocument();
                if (JdbcToXmlActionCodeI.this.superRoot != null) {
                    JdbcToXmlActionCodeI.this.xwa.writeStartElement(JdbcToXmlActionCodeI.this.superRoot);
                    for (String prefix : JdbcToXmlActionCodeI.this.namespaces.keySet()) {
                        String nameSpaceUri = (String)JdbcToXmlActionCodeI.this.namespaces.getTo((Object)prefix);
                        if (prefix != null) {
                            JdbcToXmlActionCodeI.this.xwa.writeNamespace(prefix, nameSpaceUri);
                            continue;
                        }
                        if (JdbcToXmlActionCodeI.this.targetNamespace == null || !nameSpaceUri.equals(JdbcToXmlActionCodeI.this.targetNamespace)) continue;
                        JdbcToXmlActionCodeI.this.xwa.writeDefaultNamespace(JdbcToXmlActionCodeI.this.targetNamespace);
                    }
                    if (JdbcToXmlActionCodeI.this.writeJsonAttributes) {
                        JdbcToXmlActionCodeI.this.xwa.getXMLStreamWriter().writeAttribute(JdbcToXmlActionCodeI.this.xsiPrefix, JdbcToXmlActionCodeI.XSI_URI, "type", JdbcToXmlActionCodeI.this.jsonPrefix + ":array");
                    }
                }
            }
            if (JdbcToXmlActionCodeI.this.elementToKeep.contains(this.defType)) {
                JdbcToXmlActionCodeI.this.forceWritemode = true;
            }
            boolean bl = isChangeJsonNodeBehaviour = JdbcToXmlActionCodeI.this.isWriteNullJsonNode || JdbcToXmlActionCodeI.this.isWriteEmptyJsonNode;
            if (this.resultSet != null) {
                boolean justOnce = !this.hasNext() && this.resultSet.hasFollowingToRead;
                boolean isFirstCreatedDocument = false;
                while ((this.resultSet.evalFiltersOk() || justOnce) && !stop) {
                    Object curAttributeValue;
                    JdbcToXmlActionCodeI.this.interruptedException();
                    justOnce = false;
                    ++this.position;
                    if (this.isRoot && JdbcToXmlActionCodeI.this.superRoot == null && (!JdbcToXmlActionCodeI.this.isJsonLinesFormat || JdbcToXmlActionCodeI.this.isJsonLinesFormat && !isFirstCreatedDocument)) {
                        JdbcToXmlActionCodeI.this.startNewDocument();
                        isFirstCreatedDocument = true;
                    }
                    String data = null;
                    String val = this.resultSet.getValue(this.getAlias());
                    if (val == null) {
                        boolean shouldBreak = false;
                        if (this.hasNext()) {
                            String localAlias = this.isKey ? this.getAlias() : null;
                            for (IndyResultSet indyResultSet : this.getAllResultSets()) {
                                val = indyResultSet.goToNext(localAlias);
                                if (val != null) continue;
                                localAlias = null;
                            }
                            if (val == null || !this.resultSet.lastFiltersOk) {
                                shouldBreak = true;
                            }
                        } else {
                            shouldBreak = true;
                        }
                        if (shouldBreak) {
                            if (!this.isNillable || this.isKey) break;
                            JdbcToXmlActionCodeI.this.eltsToOpen.add(this);
                            for (IndyAttribute attribute : this.internalProperty) {
                                if (!attribute.name.equals("internalProperty:nodeName")) continue;
                                curAttributeValue = attribute.getValue();
                                if (curAttributeValue != null && ((String)curAttributeValue).contains(":")) {
                                    this.dynamicName = ((String)curAttributeValue).substring(0, ((String)curAttributeValue).indexOf(":"));
                                    this.dynamicNamespace = ((String)curAttributeValue).substring(((String)curAttributeValue).indexOf(":"));
                                    continue;
                                }
                                this.dynamicName = curAttributeValue;
                            }
                            boolean justOpen = JdbcToXmlActionCodeI.this.openEltToOpen(JdbcToXmlActionCodeI.this.xwa.getXMLStreamWriter());
                            JdbcToXmlActionCodeI.this.xwa.getXMLStreamWriter().writeAttribute(JdbcToXmlActionCodeI.this.xsiPrefix, JdbcToXmlActionCodeI.XSI_URI, "nil", "true");
                            if (justOpen && this.staticEndItem != null && !this.staticEndItem.isEmpty()) {
                                for (StaticItem staticItem : this.staticEndItem) {
                                    staticItem.write(JdbcToXmlActionCodeI.this.xwa.getXMLStreamWriter());
                                }
                            }
                            this.closeElement();
                            break;
                        }
                    }
                    if (this.isKey || this.type != null) {
                        if (this.isTagged && this.valueTag == null) {
                            this.valueTag = val;
                        }
                        if (this.isKey) {
                            this.resultSet.addFilter(this.getAlias(), val);
                        }
                        if (this.type != null || this.isKey && JdbcToXmlActionCodeI.this.writeKeyValue) {
                            data = val;
                        }
                    }
                    JdbcToXmlActionCodeI.this.eltsToOpen.add(this);
                    if (this.staticAttributes != null && this.staticAttributes.size() > 0) {
                        JdbcToXmlActionCodeI.this.eltsToOpen.add(this.staticAttributes);
                    }
                    boolean justOpen = false;
                    for (IndyAttribute attribute : this.internalProperty) {
                        if (attribute.name.equals("internalProperty:nodeLocalName")) {
                            this.dynamicName = attribute.getValue();
                            continue;
                        }
                        if (attribute.name.equals("internalProperty:nodePrefix")) {
                            this.dynamicPrefix = attribute.getValue();
                            continue;
                        }
                        if (attribute.name.equals("internalProperty:nodeURI")) {
                            this.dynamicNamespace = attribute.getValue();
                            continue;
                        }
                        if (!attribute.name.equals("internalProperty:nodeName")) continue;
                        curAttributeValue = attribute.getValue();
                        if (curAttributeValue != null && ((String)curAttributeValue).contains(":")) {
                            this.dynamicName = ((String)curAttributeValue).substring(0, ((String)curAttributeValue).indexOf(":"));
                            this.dynamicNamespace = ((String)curAttributeValue).substring(((String)curAttributeValue).indexOf(":"));
                            continue;
                        }
                        this.dynamicName = curAttributeValue;
                    }
                    for (IndyAttribute attribute : this.attributes) {
                        if (!attribute.write()) continue;
                        justOpen = true;
                    }
                    if (data != null) {
                        if (this.isTagged && this.valueTag == null) {
                            this.valueTag = data;
                        }
                        if (JdbcToXmlActionCodeI.this.openEltToOpen(JdbcToXmlActionCodeI.this.xwa.getXMLStreamWriter())) {
                            justOpen = true;
                        }
                        JdbcToXmlActionCodeI.this.xwa.writeText(this, data, this.resultSet.currentValue, this.resultSet.currentType);
                    }
                    if (JdbcToXmlActionCodeI.this.forceWritemode && JdbcToXmlActionCodeI.this.openEltToOpen(JdbcToXmlActionCodeI.this.xwa.getXMLStreamWriter())) {
                        justOpen = true;
                    }
                    if (justOpen && this.staticEndItem != null && !this.staticEndItem.isEmpty()) {
                        for (StaticItem _item : this.staticEndItem) {
                            _item.write(JdbcToXmlActionCodeI.this.xwa.getXMLStreamWriter());
                        }
                    }
                    for (IndyElement elt : this.elements) {
                        elt.write();
                    }
                    this.closeElement();
                    if (this.isKey) {
                        this.resultSet.removeFilter(this.getAlias());
                    } else {
                        stop = true;
                    }
                    if (this.doNext) {
                        this.resultSet.next();
                    }
                    if (!this.isRoot || JdbcToXmlActionCodeI.this.superRoot != null) continue;
                    if (!JdbcToXmlActionCodeI.this.isJsonLinesFormat || JdbcToXmlActionCodeI.this.isJsonLinesFormat && this.resultSet.isEndeded()) {
                        JdbcToXmlActionCodeI.this.endCurrentDocument(this.defineNewFile());
                        continue;
                    }
                    if (!JdbcToXmlActionCodeI.this.isJsonLinesFormat || this.resultSet.isEndeded()) continue;
                    JdbcToXmlActionCodeI.this.xwa.writeNewLineCharacter();
                }
                if (this.isRoot && JdbcToXmlActionCodeI.this.superRoot == null && JdbcToXmlActionCodeI.this.isJsonLinesFormat && !isFirstCreatedDocument) {
                    JdbcToXmlActionCodeI.this.startNewDocument();
                    JdbcToXmlActionCodeI.this.endCurrentDocument(this.defineNewFile());
                }
            } else {
                JdbcToXmlActionCodeI.this.eltsToOpen.add(this);
                if (this.staticAttributes != null && !this.staticAttributes.isEmpty()) {
                    JdbcToXmlActionCodeI.this.eltsToOpen.add(this.staticAttributes);
                }
                for (IndyAttribute attribute : this.attributes) {
                    attribute.write();
                }
                if (isChangeJsonNodeBehaviour || JdbcToXmlActionCodeI.this.forceWritemode) {
                    JdbcToXmlActionCodeI.this.openEltToOpen(JdbcToXmlActionCodeI.this.xwa.getXMLStreamWriter());
                }
                if (!isChangeJsonNodeBehaviour || this.isChildrenHavingData(this.elements, this.getFullPath())) {
                    for (IndyElement elt : this.elements) {
                        elt.write();
                    }
                } else if (JdbcToXmlActionCodeI.this.isWriteNullJsonNode) {
                    JdbcToXmlActionCodeI.this.xwa.getXMLStreamWriter().writeAttribute(JdbcToXmlActionCodeI.this.xsiPrefix, JdbcToXmlActionCodeI.XSI_URI, "nil", "true");
                }
                this.closeElement();
            }
            if (this.isFirstElement && this.resultSet.hasFollowingToRead) {
                this.resultSet.hasFollowingToRead = false;
            }
            if (JdbcToXmlActionCodeI.this.elementToKeep.contains(this.defType)) {
                JdbcToXmlActionCodeI.this.forceWritemode = false;
            }
            if (this.isRoot && (this.resultSet == null || JdbcToXmlActionCodeI.this.superRoot != null)) {
                if (JdbcToXmlActionCodeI.this.superRoot != null) {
                    JdbcToXmlActionCodeI.this.xwa.writeEndElement();
                }
                JdbcToXmlActionCodeI.this.endCurrentDocument(this.defineNewFile());
            }
        }

        private boolean isChildrenHavingData(List<IndyElement> elements, String fullPath) {
            if (elements == null || elements.isEmpty()) {
                return false;
            }
            for (IndyElement indyElement : elements) {
                block6: {
                    IndyResultSet indyResultSet = indyElement.resultSet;
                    if (indyResultSet != null && indyResultSet.getValue(indyElement.getAlias()) == null) {
                        indyResultSet.next();
                    }
                    if (indyResultSet == null || indyResultSet.getValue(indyElement.getAlias()) == null) break block6;
                    return true;
                }
                try {
                    return this.isChildrenHavingData(indyElement.elements, fullPath);
                }
                catch (EngineExceptionI e) {
                    JdbcToXmlActionCodeI.this.logger.error("unexpected", (Throwable)e);
                }
            }
            return false;
        }

        public void closeElement() throws XMLStreamException {
            if (JdbcToXmlActionCodeI.this.eltsToClose.contains(this)) {
                if (this == JdbcToXmlActionCodeI.this.jsonRootElement) {
                    JdbcToXmlActionCodeI.this.jsonRootElement = null;
                }
                JdbcToXmlActionCodeI.this.xwa.writeEndElement();
                JdbcToXmlActionCodeI.this.eltsToClose.remove(this);
            } else {
                int min = JdbcToXmlActionCodeI.this.eltsToOpen.indexOf(this);
                int max = JdbcToXmlActionCodeI.this.eltsToOpen.size() - 1;
                while (max >= min) {
                    JdbcToXmlActionCodeI.this.eltsToOpen.remove(max);
                    --max;
                }
            }
        }

        public void setParent(IndyElement parent) {
            if (parent != null) {
                this.parent = parent;
                parent.elements.add(this);
            }
        }

        public void addAttribute(IndyAttribute attr) {
            if (attr.internalProperties) {
                this.internalProperty.add(attr);
            } else {
                this.attributes.add(attr);
            }
            attr.parent = this;
        }

        public void closeAllResultSet() throws EngineExceptionI {
            if (this.resultSet != null) {
                this.resultSet.close();
                this.resultSet = null;
            }
            for (IndyElement element : this.elements) {
                element.closeAllResultSet();
            }
        }

        public void addStaticAttribute(String qName, String value) {
            if (qName != null && value != null) {
                if (this.staticAttributes == null) {
                    this.staticAttributes = new HashMap<String, String>();
                }
                this.staticAttributes.put(qName, value);
            }
        }

        public void interrupAllResultSet() throws EngineExceptionI {
            if (this.resultSet != null) {
                this.resultSet.cancel();
                try {
                    JdbcToXmlActionCodeI.this.jdbcConnection.isClosed();
                }
                catch (Exception e) {
                    JdbcToXmlActionCodeI.this.logger.error("Failed to close connection", (Throwable)e);
                }
            }
            for (IndyElement element : this.elements) {
                element.interrupAllResultSet();
            }
        }

        public boolean isUseCDATA() {
            return this.useCDATA;
        }
    }

    class IndyItem {
        String dynamicNamespace;
        String namespace;
        String dynamicPrefix;
        String prefix;
        boolean disablePrefix;
        String dynamicName;
        String name;
        String id;
        String alias;
        String type;
        boolean isRawData = false;
        boolean writeXsiType = false;
        int iType;
        String location;
        int jdbcType = -1;
        int jdbcIndex = -1;
        IndyItem parent;
        IndyResultSet resultSet;
        boolean isTagged = false;
        String valueTag;
        String defType;
        boolean forcePrefix;
        boolean internalProperties;
        String raw;

        IndyItem() {
        }

        public String getNSUri() {
            if (this.dynamicNamespace != null) {
                return this.dynamicNamespace;
            }
            return this.namespace;
        }

        public String getPrefix() {
            if (this.dynamicPrefix != null) {
                return this.dynamicPrefix;
            }
            return this.prefix;
        }

        public String getLocalName() {
            if (this.dynamicName != null) {
                if (JdbcToXmlActionCodeI.this.jsonRootElement != null && !JdbcToXmlActionCodeI.this.useJsonWriter && !JsonUtils.checkIfNameIsValid((String)this.dynamicName)) {
                    try {
                        return "_." + JsonUtils.encodeHexString((String)this.dynamicName) + "._";
                    }
                    catch (UnsupportedEncodingException e) {
                        JdbcToXmlActionCodeI.this.logger.warn("unsupported encoding", (Throwable)e);
                    }
                } else {
                    return this.dynamicName;
                }
            }
            return this.name;
        }

        String getFullPath() {
            String p = this.parent != null ? this.parent.getFullPath() + "/" : "/";
            return p + this.name;
        }

        public String getAlias() {
            return this.alias;
        }
    }

    class IndyQuerySet {
        String name;
        Map<String, String> currentFilters = new HashMap<String, String>();

        public IndyQuerySet(String name) {
            this.name = name;
        }

        public void addFilter(String keyName, String keyVal) {
            if (keyName != null && keyVal != null) {
                this.currentFilters.put(keyName, keyVal);
            }
        }

        public void removeFilter(String keyName) {
            this.currentFilters.remove(keyName);
        }
    }

    class IndyResultSet {
        boolean hasFollowingToRead = false;
        private boolean hasLast = false;
        private HashMap<String, String> followingFields = new HashMap();
        private HashMap<String, Object> followingObjectFields = new HashMap();
        private HashMap<String, Integer> followingTypeFields = new HashMap();
        private ResultSet rs;
        ResultSetMetaData rsMd;
        boolean ended = false;
        boolean started = false;
        boolean neverExecuted = true;
        String query;
        private HashMap<String, String> filtersMap;
        private Connection connection;
        private IndyQuerySet sourceSet;
        private String name;
        Map<String, FieldInfo> fieldInfos;
        long totalGetTime;
        private Statement statement;
        boolean hasData = false;
        long nbRow = 0L;
        long lastNbRow = -1L;
        int followingValueIsPrepared = 0;
        boolean lastFiltersOk = false;
        Object currentValue;
        int currentType;

        public String goToNext(String alias) throws EngineExceptionI {
            boolean hasMoreElt = true;
            boolean filtersOk = true;
            String value = null;
            while (value == null && hasMoreElt && filtersOk) {
                hasMoreElt = this.next();
                if (!hasMoreElt) continue;
                filtersOk = this.evalFiltersOk();
                if (alias == null || !filtersOk) continue;
                value = this.getValue(alias);
            }
            return value;
        }

        public void setFollowingValues() throws EngineExceptionI {
            if (this.nbRow == this.lastNbRow) {
                return;
            }
            this.lastNbRow = this.nbRow;
            if (this.followingFields.size() <= 0 || !this.started || this.ended) {
                return;
            }
            for (String alias : this.followingFields.keySet()) {
                FieldInfo fieldInfo = this.fieldInfos.get(alias.toUpperCase());
                if (fieldInfo != null) {
                    String tmp;
                    Object localCurrentValue = null;
                    try {
                        tmp = JdbcToXmlActionCodeI.this.dataTypeProvider.getUnparser().jdbcToString(fieldInfo.type, this.rs, fieldInfo.index);
                        if (tmp != null && JdbcToXmlActionCodeI.this.emptyValueKeyWord != null && tmp.equals(JdbcToXmlActionCodeI.this.emptyValueKeyWord)) {
                            tmp = "";
                            localCurrentValue = "";
                        } else {
                            localCurrentValue = JdbcToXmlActionCodeI.this.dataTypeProvider.getUnparser().getCurrentValue();
                        }
                    }
                    catch (SQLException e) {
                        throw new EngineExceptionI((Throwable)e);
                    }
                    this.followingFields.put(alias, tmp);
                    this.followingObjectFields.put(alias, localCurrentValue);
                    this.followingTypeFields.put(alias, fieldInfo.type);
                    continue;
                }
                this.followingFields.put(alias, null);
                this.followingObjectFields.put(alias, null);
                this.followingTypeFields.put(alias, null);
            }
            this.hasFollowingToRead = true;
        }

        public void initFieldInfo() throws SQLException {
            this.fieldInfos = new TreeMap<String, FieldInfo>();
            int i = 1;
            while (i <= this.rs.getMetaData().getColumnCount()) {
                FieldInfo fi = new FieldInfo();
                String fieldName = this.rs.getMetaData().getColumnLabel(i);
                fi.type = this.rs.getMetaData().getColumnType(i);
                fi.index = i++;
                this.fieldInfos.put(fieldName.toUpperCase(), fi);
            }
        }

        public IndyResultSet(String name, IndyQuerySet sourceSet) {
            this.name = name;
            this.sourceSet = sourceSet;
        }

        void initResultSet() throws SQLException {
            this.statement = JdbcToXmlActionCodeI.createResultSetStatement((Connection)this.connection);
            if (JdbcToXmlActionCodeI.this.fetchSize != null) {
                this.statement.setFetchSize(JdbcToXmlActionCodeI.this.fetchSize);
            }
            long start = System.currentTimeMillis();
            JdbcToXmlActionCodeI.this.debugLog("initResultSet", "name: " + this.name + " Query:\n " + this.query, JdbcToXmlActionCodeI.this.runtimeContext.LOG_LEVEL3, JdbcToXmlActionCodeI.this.runtimeContext.LOG_DEBUG);
            try {
                this.rs = this.statement.executeQuery(this.query);
            }
            catch (SQLException e) {
                throw new SQLException(e.getMessage() + "\n" + this.query, e);
            }
            this.rsMd = this.rs.getMetaData();
            this.initFieldInfo();
            long end = System.currentTimeMillis();
            JdbcToXmlActionCodeI.this.debugLog("initResultSet", Messages.getString("JdbcToXmlActionCodeI.18") + this.name + Messages.getString("JdbcToXmlActionCodeI.19") + (end - start) + "s", JdbcToXmlActionCodeI.this.runtimeContext.LOG_LEVEL3, JdbcToXmlActionCodeI.this.runtimeContext.LOG_DEBUG);
            JdbcToXmlActionCodeI.this.totalQueryTime += end - start;
            ++JdbcToXmlActionCodeI.this.nbexecutedQuerys;
            JdbcToXmlActionCodeI.this.handleQueryStatistics(false);
            this.neverExecuted = false;
        }

        boolean next() throws EngineExceptionI {
            try {
                if (this.neverExecuted) {
                    this.initResultSet();
                }
                this.hasData = this.rs.next();
                if (this.hasData) {
                    ++this.nbRow;
                    ++JdbcToXmlActionCodeI.this.totalLines;
                    if ((JdbcToXmlActionCodeI.this.totalAttributes + JdbcToXmlActionCodeI.this.totalElements + JdbcToXmlActionCodeI.this.totalLines) % JdbcToXmlActionCodeI.this.statisticFrequency == 0) {
                        JdbcToXmlActionCodeI.this.handleDataStatistics(false);
                    }
                    this.started = true;
                } else {
                    this.ended = true;
                }
                return this.hasData;
            }
            catch (SQLException e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }

        boolean evalFiltersOk() throws EngineExceptionI {
            if (this.neverExecuted) {
                this.next();
            }
            if (this.started && !this.ended) {
                if (this.sourceSet.currentFilters != null) {
                    for (Map.Entry<String, String> entry : this.sourceSet.currentFilters.entrySet()) {
                        String str = null;
                        str = this.getValue(entry.getKey());
                        boolean compare = JdbcToXmlActionCodeI.equals(str, entry.getValue());
                        if (compare) continue;
                        this.lastFiltersOk = false;
                        return this.lastFiltersOk;
                    }
                }
                this.lastFiltersOk = true;
                this.setFollowingValues();
                return this.lastFiltersOk;
            }
            this.lastFiltersOk = false;
            return this.lastFiltersOk;
        }

        public boolean hasCurrent() {
            return this.started && !this.ended;
        }

        public String getValue(String name) throws EngineExceptionI {
            this.currentValue = null;
            this.currentType = 1111;
            long start = System.currentTimeMillis();
            if (this.followingFields.containsKey(name)) {
                this.currentValue = this.followingObjectFields.get(name);
                this.currentType = this.followingTypeFields.get(name);
                return this.followingFields.get(name);
            }
            if (this.started && !this.ended) {
                String tmp;
                FieldInfo fieldInfo = this.fieldInfos.get(name.toUpperCase());
                if (fieldInfo == null) {
                    return null;
                }
                try {
                    tmp = JdbcToXmlActionCodeI.this.dataTypeProvider.getUnparser().jdbcToString(fieldInfo.type, this.rs, fieldInfo.index);
                    if (tmp != null && JdbcToXmlActionCodeI.this.emptyValueKeyWord != null && tmp.equals(JdbcToXmlActionCodeI.this.emptyValueKeyWord)) {
                        tmp = "";
                        this.currentValue = "";
                    } else {
                        this.currentValue = JdbcToXmlActionCodeI.this.dataTypeProvider.getUnparser().getCurrentValue();
                    }
                    this.currentType = fieldInfo.type;
                }
                catch (SQLException e) {
                    throw new EngineExceptionI((Throwable)e);
                }
                long end = System.currentTimeMillis();
                this.totalGetTime += start - end;
                return tmp;
            }
            return null;
        }

        public void close() throws EngineExceptionI {
            if (this.rs != null) {
                try {
                    if (this.statement != null) {
                        this.statement.close();
                        this.statement = null;
                    }
                    this.rs.close();
                    this.rs = null;
                }
                catch (SQLException e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
        }

        public void cancel() throws EngineExceptionI {
            if (this.rs != null) {
                try {
                    if (this.statement != null) {
                        this.statement.cancel();
                    }
                }
                catch (SQLException e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
        }

        public boolean isEndeded() {
            return this.ended;
        }

        public boolean isStarted() {
            return this.started;
        }

        void addFilter(String alias, String val) {
            this.sourceSet.addFilter(alias, val);
        }

        void removeFilter(String alias) {
            this.sourceSet.removeFilter(alias);
        }

        class FieldInfo {
            int index;
            int type;

            FieldInfo() {
            }
        }
    }

    public static final class OutputStreamTransformerInitalizer {
        OutputStreamTransformer streamHookOne;
        ClassLoader streamHookOneCL;

        void init(String streamHookOneClassName, ActionCodeTypeI action, ISessionContext engineContext, boolean useJsonWriter, OutputStreamTransformer.OutputStreamTransformerStatisticHandler ostsh, Map namespaces) throws EngineExceptionI {
            try {
                Properties prop = new Properties();
                prop.load(new ByteArrayInputStream(streamHookOneClassName.getBytes()));
                String className = prop.getProperty("class");
                if (className != null) {
                    if (className.equals("com.indy.engine.common.tools.impl.JavaGenericOutputStreamTransformer")) {
                        className = JavaGenericOutputStreamTransformer.class.getName();
                    }
                    Class<?> clazz = null;
                    String classModules = prop.getProperty("class.module");
                    ClassLoader classLoader = ClassLoaderServiceProvider.instance().getClassLoader(classModules, className);
                    clazz = classLoader.loadClass(className);
                    Object o = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (o instanceof JavaRealObjectHandler) {
                        o = JavaRealObjectHandler.getJavaObjectHandler((JavaRealObjectHandler)((JavaRealObjectHandler)o));
                    }
                    if (o instanceof JavaObjectHandler) {
                        this.streamHookOne = new JavaGenericOutputStreamTransformer();
                        ((JavaGenericOutputStreamTransformer)this.streamHookOne).setJavaObjectHandler((JavaObjectHandler)o);
                        if (!useJsonWriter) {
                            ((JavaGenericOutputStreamTransformer)this.streamHookOne).xmlSerDes(true);
                        }
                    } else {
                        this.streamHookOne = (OutputStreamTransformer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    this.streamHookOne.setActionContext(action.getActionContext());
                    this.streamHookOne.setStatisticHandler(ostsh);
                    String scriptEngineName = null;
                    String scriptEngineTransaction = null;
                    String handlerObjectName = null;
                    for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                        if (entry.getKey().equals("script.handler.language.name")) {
                            scriptEngineName = (String)entry.getValue();
                            continue;
                        }
                        if (entry.getKey().equals("script.handler.connection.name")) {
                            scriptEngineTransaction = (String)entry.getValue();
                            continue;
                        }
                        if (entry.getKey().equals("script.handler.object.name")) {
                            handlerObjectName = (String)entry.getValue();
                            continue;
                        }
                        if (entry.getKey().equals("script.handler.module")) {
                            String moduleName = (String)entry.getValue();
                            if (moduleName == null || moduleName.isEmpty()) {
                                moduleName = "default";
                            }
                            this.streamHookOneCL = ClassLoaderServiceProvider.instance().getClassLoader(moduleName);
                            continue;
                        }
                        if (entry.getKey().equals("class")) continue;
                        this.streamHookOne.setProperty((String)entry.getKey(), (String)entry.getValue());
                    }
                    if (namespaces != null) {
                        this.streamHookOne.setInternalProperty("namespaces", (Object)namespaces);
                    }
                    if (scriptEngineName != null) {
                        Object se = null;
                        se = scriptEngineName.equals("beanshell") ? engineContext.getScriptingProvider().createScriptingEngine(IScriptingEngineProvider.EngineRuntime.BEANSHELL, scriptEngineName, scriptEngineTransaction, action, null).getScriptingEngine() : engineContext.getScriptingProvider().createScriptingEngine(IScriptingEngineProvider.EngineRuntime.JS, scriptEngineName, scriptEngineTransaction, action, null).getScriptingEngine();
                        if (this.streamHookOne instanceof JavaGenericOutputStreamTransformer) {
                            ((JavaGenericOutputStreamTransformer)this.streamHookOne).setJavaObjectHandler(JavaGenericOperation.getJavaObjectHandler((Object)se, (String)scriptEngineName, (String)handlerObjectName));
                        }
                    }
                }
            }
            catch (EngineExceptionI e) {
                throw e;
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
    }

    public class SimpleContentHandler
    extends IndyContentHandler {
        IndyElement root;
        List<IndyItem> pile = new ArrayList<IndyItem>();
        private SortedMap<String, IndyResultSet> resultSets;
        private Map<String, IndyQuerySet> querySets;
        boolean tag;
        boolean staticOpen = false;
        String currentTag;

        public SimpleContentHandler(SortedMap<String, IndyResultSet> resultSets, Map<String, IndyQuerySet> querySets) {
            this.resultSets = resultSets;
            this.querySets = querySets;
        }

        public void startElement(String nameSpaceURI, String localName, String rawName, Attributes attributs) throws SAXException {
            this.tag = false;
            if (rawName != null && rawName.equals("md:static") || this.staticOpen) {
                this.staticOpen = true;
                IndyElement currentElement = (IndyElement)this.getCurrent();
                if (rawName == null || !rawName.equals("md:static")) {
                    currentElement.staticEndItem.add(new StaticStartElement(nameSpaceURI, localName, rawName));
                    int index = 0;
                    while (index < attributs.getLength()) {
                        currentElement.staticEndItem.add(new StaticAttribute(attributs.getURI(index), attributs.getLocalName(index), attributs.getQName(index), attributs.getValue(index)));
                        ++index;
                    }
                } else {
                    int index = 0;
                    while (index < attributs.getLength()) {
                        currentElement.staticStartItem.add(new StaticAttribute(attributs.getURI(index), attributs.getLocalName(index), attributs.getQName(index), attributs.getValue(index)));
                        ++index;
                    }
                }
            } else if (localName.equals("tag")) {
                this.tag = true;
            } else if (localName.equals("element")) {
                this.parseElement(attributs);
            } else if (localName.equals("attribute") && !this.pile.isEmpty()) {
                this.parseAttribute(attributs);
            } else if (localName.equals("namespace") && this.pile.isEmpty()) {
                this.parseNamespace(attributs);
            } else if (localName.equals("data") && this.pile.isEmpty()) {
                JdbcToXmlActionCodeI.this.targetNamespace = attributs.getValue("targetNamespace");
                String tmp = attributs.getValue("prefixForElement");
                JdbcToXmlActionCodeI.this.prefixForElement = tmp != null && tmp.equals("qualified");
                tmp = attributs.getValue("prefixForAttribute");
                JdbcToXmlActionCodeI.this.prefixForAttribute = tmp != null && tmp.equals("qualified");
            }
        }

        private void parseNamespace(Attributes attributs) {
            String uri = attributs.getValue("name");
            String prefix = attributs.getValue("prefix");
            JdbcToXmlActionCodeI.this.namespaces.put((Object)prefix, (Object)uri);
        }

        private boolean parseItem(IndyItem item, Attributes attributs, int index) {
            if (attributs.getQName(index).equals("sqlToXml:id")) {
                item.id = attributs.getValue(index);
                return true;
            }
            if (attributs.getQName(index).equals("sqlToXml:alias")) {
                item.alias = attributs.getValue(index);
                return true;
            }
            if (attributs.getQName(index).equals("name")) {
                item.name = attributs.getValue(index);
                if (item.name.startsWith("internalProperty:")) {
                    item.internalProperties = true;
                }
                return true;
            }
            if (attributs.getQName(index).equals("type")) {
                item.type = attributs.getValue(index);
                if (item.type.isEmpty()) {
                    item.type = null;
                } else if (item.type.equals("json:array")) {
                    item.type = null;
                } else if (item.type.equals("json:object")) {
                    item.type = null;
                } else if (item.type.equals("rawData")) {
                    item.isRawData = true;
                    JdbcToXmlActionCodeI.this.hasRawData = true;
                }
                if (JdbcToXmlActionCodeI.this.dataTypeProvider != null && item.type != null) {
                    item.iType = JdbcToXmlActionCodeI.this.dataTypeProvider.getDataType(item.type);
                }
                return true;
            }
            if (attributs.getQName(index).equals("sqlToXml:location")) {
                item.location = attributs.getValue(index);
                return true;
            }
            if (attributs.getQName(index).equals("namespace")) {
                item.namespace = attributs.getValue(index);
                return true;
            }
            if (attributs.getQName(index).equals("md:defType")) {
                item.defType = attributs.getValue(index);
                if (item.defType.startsWith("com.stambia.json")) {
                    boolean b;
                    JdbcToXmlActionCodeI.this.writeJsonAttributes = true;
                    if (!JdbcToXmlActionCodeI.this.hasXsiAttribute) {
                        JdbcToXmlActionCodeI.this.hasXsiAttribute = true;
                    }
                    boolean bl = b = JdbcToXmlActionCodeI.this.nillableIsForce ? JdbcToXmlActionCodeI.this.defaultNillable : true;
                    if (item.defType.toLowerCase().endsWith("value")) {
                        item.writeXsiType = true;
                        ((IndyElement)item).isNillable = b;
                    } else if (item.defType.toLowerCase().endsWith("array")) {
                        ((IndyElement)item).isJsonArray = true;
                        ((IndyElement)item).isNillable = b;
                    } else if (item.defType.toLowerCase().endsWith("object")) {
                        ((IndyElement)item).isJsonObject = true;
                        ((IndyElement)item).isNillable = b;
                    }
                }
                return true;
            }
            if (attributs.getQName(index).equals("defType")) {
                item.defType = attributs.getValue(index);
                return true;
            }
            if (attributs.getQName(index).equals("prefixQualification")) {
                String tmp = attributs.getValue(index);
                item.disablePrefix = tmp != null && tmp.equals("disable");
                item.forcePrefix = tmp != null && tmp.equals("force");
                return true;
            }
            return false;
        }

        private void parseAttribute(Attributes attributs) {
            IndyElement elt = (IndyElement)this.pile.get(this.pile.size() - 1);
            IndyAttribute attr = new IndyAttribute();
            this.pile.add(attr);
            int index = 0;
            while (index < attributs.getLength()) {
                String sourceSetName;
                if (!this.parseItem(attr, attributs, index) && attributs.getQName(index).equals("sqlToXml:sourceSet") && (sourceSetName = attributs.getValue(index)) != null && !sourceSetName.isEmpty()) {
                    attr.resultSet = (IndyResultSet)this.resultSets.get(sourceSetName);
                }
                ++index;
            }
            elt.addAttribute(attr);
            if (attr.resultSet != null && attr.resultSet.hasLast) {
                attr.resultSet.followingFields.put(attr.getAlias(), null);
            }
        }

        private void parseElement(Attributes attributs) {
            IndyElement element = new IndyElement();
            element.useCDATA = JdbcToXmlActionCodeI.this.forceUsedCData;
            if (this.root == null) {
                this.root = element;
                this.root.isRoot = true;
            }
            if (!this.pile.isEmpty()) {
                element.setParent((IndyElement)this.pile.get(this.pile.size() - 1));
            }
            this.pile.add(element);
            String sourceSetName = null;
            String querySetName = null;
            if (element != null) {
                element.setNillable(JdbcToXmlActionCodeI.this.defaultNillable);
                String forceNillable = null;
                int index = 0;
                while (index < attributs.getLength()) {
                    if (!this.parseItem(element, attributs, index)) {
                        if (attributs.getQName(index).equals("sqlToXml:isKey")) {
                            element.isKey = attributs.getValue(index) != null && attributs.getValue(index).equals("true");
                        } else if (attributs.getQName(index).equals("sqlToXml:sourceSet")) {
                            sourceSetName = attributs.getValue(index);
                        } else if (attributs.getQName(index).equals("sqlToXml:querySet")) {
                            querySetName = attributs.getValue(index);
                        } else if (attributs.getQName(index).equals("cdata")) {
                            tmp = attributs.getValue(index);
                            if (Boolean.FALSE.equals(JdbcToXmlActionCodeI.this.forceUsedCData)) {
                                element.useCDATA = tmp != null && tmp.equals("true");
                            }
                        } else if (attributs.getQName(index).equals("sqlToXml:isLast")) {
                            tmp = attributs.getValue(index);
                            element.isLast = tmp != null && tmp.equals("true");
                        } else if (!attributs.getQName(index).equals("sqlToXml:distinct")) {
                            if (attributs.getQName(index).equals("isNillable") && !JdbcToXmlActionCodeI.this.nillableIsForce && attributs.getValue(index) != null) {
                                if (attributs.getValue(index).equals("true")) {
                                    element.setNillable(true);
                                } else if (attributs.getValue(index).equals("false")) {
                                    element.setNillable(false);
                                }
                            } else if (attributs.getQName(index).equals("sqlToXml:forceIsNillable") && !JdbcToXmlActionCodeI.this.nillableIsForce) {
                                forceNillable = attributs.getValue(index);
                            }
                        }
                    }
                    if (!attributs.getQName(index).startsWith("sqlToXml:") && JdbcToXmlActionCodeI.this.writeMetaDataAttribut) {
                        element.addStaticAttribute(attributs.getQName(index), attributs.getValue(index));
                    }
                    ++index;
                }
                if (forceNillable != null) {
                    if (forceNillable.equals("true")) {
                        element.setNillable(true);
                    } else if (forceNillable.equals("false")) {
                        element.setNillable(false);
                    }
                }
            }
            IndyQuerySet qs = null;
            if (querySetName != null && !querySetName.isEmpty() && (qs = this.querySets.get(querySetName)) == null) {
                qs = new IndyQuerySet(querySetName);
                this.querySets.put(querySetName, qs);
            }
            IndyResultSet irs = null;
            if (!(sourceSetName == null || sourceSetName.isEmpty() || "__monoSS__".equals(querySetName) && !JdbcToXmlActionCodeI.this.isRdbmsLinked || (irs = (IndyResultSet)this.resultSets.get(sourceSetName)) != null || qs == null)) {
                irs = new IndyResultSet(sourceSetName, qs);
                this.resultSets.put(sourceSetName, irs);
                element.isFirstElement = true;
            }
            if (irs != null) {
                if (element.isLast && !irs.hasLast) {
                    irs.hasLast = true;
                    element.doNext = true;
                } else if (irs.hasLast) {
                    irs.followingFields.put(element.getAlias(), null);
                    element.isLast = false;
                }
                element.resultSet = irs;
            }
        }

        public void endElement(String nameSpaceURI, String localName, String rawName) throws SAXException {
            if (this.staticOpen) {
                if (rawName != null && rawName.equals("md:static")) {
                    this.staticOpen = false;
                } else {
                    IndyElement currentElement = (IndyElement)this.getCurrent();
                    currentElement.staticEndItem.add(new StaticEndElement());
                }
                return;
            }
            if (!this.pile.isEmpty()) {
                if (localName.equals("tag") && this.currentTag != null) {
                    JdbcToXmlActionCodeI.this.tags.put(this.currentTag, this.getCurrent());
                    IndyItem current = this.getCurrent();
                    current.isTagged = true;
                    this.tag = false;
                    this.currentTag = null;
                }
                if (localName.equals("element") || localName.equals("attribute")) {
                    this.pile.remove(this.pile.size() - 1);
                }
            }
        }

        public IndyItem getCurrent() {
            if (!this.pile.isEmpty()) {
                return this.pile.get(this.pile.size() - 1);
            }
            return null;
        }

        public void characters(char[] ch, int start, int end) throws SAXException {
            if (this.staticOpen) {
                IndyElement currentElement = (IndyElement)this.getCurrent();
                currentElement.staticEndItem.add(new StaticCharacter(new String(ch, start, end)));
                return;
            }
            if (!this.pile.isEmpty()) {
                if (this.tag) {
                    this.currentTag = this.currentTag == null ? new String(ch, start, end) : String.valueOf(this.currentTag) + new String(ch, start, end);
                } else {
                    String query = new String(ch, start, end);
                    IndyElement element = (IndyElement)this.getCurrent();
                    IndyResultSet irs = element.resultSet;
                    try {
                        irs.query = irs.query == null ? query : String.valueOf(irs.query) + query;
                    }
                    catch (NullPointerException e) {
                        JdbcToXmlActionCodeI.this.logger.warn("NPE", (Throwable)e);
                    }
                }
            }
        }
    }

    final class StaticAttribute
    implements StaticItem {
        private String nameSpaceURI;
        private String localName;
        private String prefix;
        private String value;

        public StaticAttribute(String nameSpaceURI, String localName, String rawName, String value) {
            this.nameSpaceURI = nameSpaceURI != null && !nameSpaceURI.isEmpty() ? nameSpaceURI : null;
            this.localName = localName;
            this.value = value;
            if (rawName != null && rawName.endsWith(":" + localName)) {
                String[] split = rawName.split(":");
                this.prefix = split[0];
            }
        }

        @Override
        public void write(XMLStreamWriter writer) throws XMLStreamException {
            if (this.prefix != null && this.nameSpaceURI != null) {
                writer.writeAttribute(this.prefix, this.nameSpaceURI, this.localName, this.value);
            } else if (this.nameSpaceURI != null) {
                writer.writeAttribute(this.nameSpaceURI, this.localName, this.value);
            } else {
                try {
                    writer.writeAttribute(this.localName, this.value);
                }
                catch (Exception e) {
                    JdbcToXmlActionCodeI.this.logger.warn("unexpected", (Throwable)e);
                }
            }
        }
    }

    final class StaticCharacter
    implements StaticItem {
        String str;

        private StaticCharacter(String str) {
            this.str = str;
        }

        @Override
        public void write(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeCharacters(this.str);
        }
    }

    final class StaticEndElement
    implements StaticItem {
        private StaticEndElement() {
        }

        @Override
        public void write(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeEndElement();
        }
    }

    static interface StaticItem {
        public void write(XMLStreamWriter var1) throws XMLStreamException;
    }

    final class StaticStartElement
    implements StaticItem {
        String nameSpaceURI;
        String localName;
        String prefix;

        private StaticStartElement(String nameSpaceURI, String localName, String rawName) {
            this.nameSpaceURI = nameSpaceURI != null && !nameSpaceURI.isEmpty() ? nameSpaceURI : null;
            this.localName = localName;
            if (rawName != null && rawName.endsWith(":" + localName)) {
                String[] split = rawName.split(":");
                this.prefix = split[0];
            }
        }

        @Override
        public void write(XMLStreamWriter writer) throws XMLStreamException {
            if (this.prefix != null && this.nameSpaceURI != null) {
                writer.writeStartElement(this.prefix, this.localName, this.nameSpaceURI);
            } else if (this.nameSpaceURI != null) {
                writer.writeStartElement(this.localName, this.nameSpaceURI);
            } else {
                writer.writeStartElement(this.localName);
            }
        }
    }
}

