/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.amqp;

import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.amqp.AMQPConnection;
import com.indy.engine.actionCodes.amqp.AMQPMessageSender;
import com.indy.engine.actionCodes.amqp.AMQPUtils;
import com.indy.engine.core.objects.data.baseobjects.StringOperations;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AMQPFileSender
extends AMQPMessageSender {
    private final Logger logger = LogManager.getLogger(this.getClass());
    String sendDirectory;
    String fileMask;
    List<File> sendFiles = new ArrayList<File>();

    public void setSendDirectory(String sendDirectory) {
        this.sendDirectory = sendDirectory;
    }

    public void setFileMask(String fileMask) {
        this.fileMask = fileMask;
    }

    public synchronized void deleteSendFiles() {
        for (File file : this.sendFiles) {
            if (file.delete()) continue;
            this.logger.debug("Could not delete file {}", (Object)file.getAbsolutePath());
        }
        this.sendFiles.clear();
    }

    public synchronized void send(AMQPConnection connection) throws IOException, InterruptedException, TimeoutException {
        AMQPUtils._assert(this.sendDirectory != null, Messages.getString("AMQP.ERROR_021"));
        AMQPUtils._assert(this.fileMask != null, Messages.getString("AMQP.ERROR_022"));
        File directory = new File(this.sendDirectory);
        if (!directory.exists()) {
            throw new IOException(String.format(Messages.getString("AMQP.ERROR_019"), this.sendDirectory));
        }
        if (directory.isFile()) {
            throw new IOException(String.format(Messages.getString("AMQP.ERROR_020"), this.sendDirectory));
        }
        File[] fileArray = directory.listFiles(new MyFileFilter(this.fileMask));
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File _file = fileArray[n2];
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (_file.isFile()) {
                try (FileInputStream in = null;){
                    in = new FileInputStream(_file);
                    this.send(connection, AMQPUtils.fileToByteArray(_file));
                    this.sendFiles.add(_file);
                }
            }
            ++n2;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public synchronized void copySentFiles(String dir, boolean move) throws IOException {
        File localDir = new File(dir);
        if (!localDir.exists()) {
            localDir.mkdirs();
        }
        for (File file : this.sendFiles) {
            File dest = new File(localDir, file.getName());
            if (move) {
                dest.delete();
                if (file.renameTo(dest)) continue;
                this.logger.debug("Could not move file {}", (Object)file.getAbsolutePath());
                continue;
            }
            Throwable throwable = null;
            Object var8_9 = null;
            try {
                FileInputStream is = new FileInputStream(file);
                try {
                    try (FileOutputStream os = new FileOutputStream(dest);){
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                    }
                    if (is == null) continue;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                    throw throwable;
                }
                ((InputStream)is).close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        this.sendFiles.clear();
    }

    class MyFileFilter
    implements FilenameFilter {
        final String localMask;

        public MyFileFilter(String pFileMask) {
            this.localMask = StringOperations.replaceWildChars((String)pFileMask);
        }

        @Override
        public boolean accept(File pDir, String pFileName) {
            return pFileName.matches(this.localMask);
        }
    }
}

