/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.jdbc;

import com.indy.engine.actionCodes.file.FileProperties;
import com.indy.engine.core.objects.data.baseobjects.StringOperations;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FieldInfo {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final Method TINYINT_VARIABLE_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            Byte _byte = FieldInfo.this.resultSet.getByte(FieldInfo.this.index);
            if (_byte != null && !FieldInfo.this.resultSet.wasNull()) {
                return _byte.toString();
            }
            return "";
        }
    };
    private final Method TIMESTAMP_VARIABLE_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            Timestamp ts = FieldInfo.this.resultSet.getTimestamp(FieldInfo.this.index);
            if (ts != null && !FieldInfo.this.resultSet.wasNull()) {
                return FieldInfo.this.properties.dateFormat.format(new Date(ts.getTime()));
            }
            return "";
        }
    };
    private final Method TIME_VARIABLE_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            Time time = FieldInfo.this.resultSet.getTime(FieldInfo.this.index);
            if (time != null && !FieldInfo.this.resultSet.wasNull()) {
                return time.toString();
            }
            return "";
        }
    };
    private final Method SMALLINT_VARIABLE_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            Short shrt = FieldInfo.this.resultSet.getShort(FieldInfo.this.index);
            if (shrt != null && !FieldInfo.this.resultSet.wasNull()) {
                return shrt.toString();
            }
            return "";
        }
    };
    private final Method INTEGER_VARIABLE_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            int _int = FieldInfo.this.resultSet.getInt(FieldInfo.this.index);
            if (!FieldInfo.this.resultSet.wasNull()) {
                return Integer.toString(_int);
            }
            return "";
        }
    };
    private final Method FLOAT_VARIABLE_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            Float flt = Float.valueOf(FieldInfo.this.resultSet.getFloat(FieldInfo.this.index));
            if (flt != null && !FieldInfo.this.resultSet.wasNull()) {
                return FieldInfo.this.properties.decimalFormat.format(flt);
            }
            return "";
        }
    };
    private final Method DOUBLE_VARIABLE_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            Double dbl = FieldInfo.this.resultSet.getDouble(FieldInfo.this.index);
            if (dbl != null && !FieldInfo.this.resultSet.wasNull()) {
                return FieldInfo.this.properties.decimalFormat.format(dbl);
            }
            return "";
        }
    };
    private final Method DECIMAL_VARIABLE_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            BigDecimal dec = FieldInfo.this.resultSet.getBigDecimal(FieldInfo.this.index);
            if (dec != null) {
                return FieldInfo.this.properties.decimalFormat.format(dec);
            }
            return "";
        }
    };
    private final Method DATE_VARIABLE_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            Date date = FieldInfo.this.resultSet.getDate(FieldInfo.this.index);
            if (date != null && !FieldInfo.this.resultSet.wasNull()) {
                return FieldInfo.this.properties.dateFormat.format(date);
            }
            return "";
        }
    };
    private final Method VARCHAR_VARIABLE_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            String str = FieldInfo.this.resultSet.getString(FieldInfo.this.index);
            if (str != null) {
                return FieldInfo.this.properties.stringDelimiter + str + FieldInfo.this.properties.stringDelimiter;
            }
            return FieldInfo.this.properties.stringDelimiter + FieldInfo.this.properties.stringDelimiter;
        }
    };
    private final Method BOOLEAN_VARIABLE_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            Boolean bool = FieldInfo.this.resultSet.getBoolean(FieldInfo.this.index);
            if (bool != null && !FieldInfo.this.resultSet.wasNull()) {
                if (FieldInfo.this.properties.booleanAsNumeric) {
                    return bool != false ? "1" : "0";
                }
                return bool.toString();
            }
            return "";
        }
    };
    private final Method BIG_INT_VARIABLE_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            Long _long = FieldInfo.this.resultSet.getLong(FieldInfo.this.index);
            if (_long != null && !FieldInfo.this.resultSet.wasNull()) {
                return _long.toString();
            }
            return "";
        }
    };
    private final Method TINYINT_POSITIONAL_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            Byte _byte = FieldInfo.this.resultSet.getByte(FieldInfo.this.index);
            String tmp = _byte != null && !FieldInfo.this.resultSet.wasNull() ? _byte.toString() : "";
            return StringOperations.leftPad((String)tmp, (String)FieldInfo.this.properties.numericPadChar, (int)FieldInfo.this.precision);
        }
    };
    private final Method TIMESTAMP_POSITIONAL_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            Timestamp ts = FieldInfo.this.resultSet.getTimestamp(FieldInfo.this.index);
            String tmp = ts != null && !FieldInfo.this.resultSet.wasNull() ? FieldInfo.this.properties.dateFormat.format(new Date(ts.getTime())) : "";
            return StringOperations.rightPad((String)tmp, (String)FieldInfo.this.properties.stringPadChar, (int)FieldInfo.this.properties.strDateFormat.length());
        }
    };
    private final Method TIME_POSITIONAL_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            Time time = FieldInfo.this.resultSet.getTime(FieldInfo.this.index);
            String tmp = time != null && !FieldInfo.this.resultSet.wasNull() ? time.toString() : "";
            return StringOperations.rightPad((String)tmp, (String)FieldInfo.this.properties.stringPadChar, (int)FieldInfo.this.precision);
        }
    };
    private final Method SMALLINT_POSITIONAL_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            Short shrt = FieldInfo.this.resultSet.getShort(FieldInfo.this.index);
            String tmp = shrt != null && !FieldInfo.this.resultSet.wasNull() ? shrt.toString() : "";
            return StringOperations.leftPad((String)tmp, (String)FieldInfo.this.properties.numericPadChar, (int)FieldInfo.this.precision);
        }
    };
    private final Method INTEGER_POSITIONAL_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            int _int = FieldInfo.this.resultSet.getInt(FieldInfo.this.index);
            String tmp = !FieldInfo.this.resultSet.wasNull() ? Integer.toString(_int) : "";
            return StringOperations.leftPad((String)tmp, (String)FieldInfo.this.properties.numericPadChar, (int)FieldInfo.this.precision);
        }
    };
    private final Method FLOAT_POSITIONAL_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            Float flt = Float.valueOf(FieldInfo.this.resultSet.getFloat(FieldInfo.this.index));
            String tmp = flt != null && !FieldInfo.this.resultSet.wasNull() ? FieldInfo.this.properties.decimalFormat.format(flt) : "";
            return StringOperations.leftPad((String)tmp, (String)FieldInfo.this.properties.numericPadChar, (int)FieldInfo.this.precision);
        }
    };
    private final Method DOUBLE_POSITIONAL_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            Double dbl = FieldInfo.this.resultSet.getDouble(FieldInfo.this.index);
            String tmp = dbl != null && !FieldInfo.this.resultSet.wasNull() ? FieldInfo.this.properties.decimalFormat.format(dbl) : "";
            return StringOperations.leftPad((String)tmp, (String)FieldInfo.this.properties.numericPadChar, (int)FieldInfo.this.precision);
        }
    };
    private final Method DECIMAL_POSITIONAL_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            BigDecimal dec = FieldInfo.this.resultSet.getBigDecimal(FieldInfo.this.index);
            String tmp = dec != null && !FieldInfo.this.resultSet.wasNull() ? FieldInfo.this.properties.decimalFormat.format(dec) : "";
            return StringOperations.leftPad((String)tmp, (String)FieldInfo.this.properties.numericPadChar, (int)FieldInfo.this.precision);
        }
    };
    private final Method DATE_POSITIONAL_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            Date date = FieldInfo.this.resultSet.getDate(FieldInfo.this.index);
            String tmp = date != null && !FieldInfo.this.resultSet.wasNull() ? FieldInfo.this.properties.dateFormat.format(date) : "";
            return StringOperations.rightPad((String)tmp, (String)FieldInfo.this.properties.stringPadChar, (int)FieldInfo.this.properties.strDateFormat.length());
        }
    };
    private final Method VARCHAR_POSITIONAL_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            String str = FieldInfo.this.resultSet.getString(FieldInfo.this.index);
            if (str == null || FieldInfo.this.resultSet.wasNull()) {
                str = "";
            }
            return StringOperations.rightPad((String)str, (String)FieldInfo.this.properties.stringPadChar, (int)FieldInfo.this.precision);
        }
    };
    private final Method BOOLEAN_POSITIONAL_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            Boolean bool = FieldInfo.this.resultSet.getBoolean(FieldInfo.this.index);
            if (bool != null && !FieldInfo.this.resultSet.wasNull()) {
                if (FieldInfo.this.properties.booleanAsNumeric) {
                    return bool != false ? "1" : "0";
                }
                return StringOperations.rightPad((String)bool.toString(), (String)FieldInfo.this.properties.stringPadChar, (int)5);
            }
            return "";
        }
    };
    private final Method BIG_INT_POSITIONAL_METHOD = new Method(){

        @Override
        public String transform() throws SQLException {
            Long _long = FieldInfo.this.resultSet.getLong(FieldInfo.this.index);
            String tmp = _long != null && !FieldInfo.this.resultSet.wasNull() ? _long.toString() : "";
            return StringOperations.leftPad((String)tmp, (String)FieldInfo.this.properties.numericPadChar, (int)FieldInfo.this.precision);
        }
    };
    public int index;
    public int colType;
    public String name;
    public Method method;
    public int precision;
    public ResultSet resultSet;
    public FileProperties properties;

    public FieldInfo(int index, ResultSet resultSet, FileProperties properties) throws SQLException {
        this.resultSet = resultSet;
        this.properties = properties;
        ResultSetMetaData rsmd = resultSet.getMetaData();
        this.index = index;
        try {
            this.name = rsmd.getColumnName(index);
            this.colType = rsmd.getColumnType(index);
            this.precision = rsmd.getPrecision(index);
        }
        catch (SQLException e) {
            this.logger.warn("Error getting column info", (Throwable)e);
        }
        if (properties.fileFormat == 0) {
            switch (this.colType) {
                case -5: {
                    this.method = this.BIG_INT_VARIABLE_METHOD;
                    break;
                }
                case -7: 
                case 16: {
                    this.method = this.BOOLEAN_VARIABLE_METHOD;
                    break;
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    this.method = this.VARCHAR_VARIABLE_METHOD;
                    break;
                }
                case 91: {
                    this.method = this.DATE_VARIABLE_METHOD;
                    break;
                }
                case 2: 
                case 3: {
                    this.method = this.DECIMAL_VARIABLE_METHOD;
                    break;
                }
                case 8: {
                    this.method = this.DOUBLE_VARIABLE_METHOD;
                    break;
                }
                case 6: 
                case 7: {
                    this.method = this.FLOAT_VARIABLE_METHOD;
                    break;
                }
                case 4: {
                    this.method = this.INTEGER_VARIABLE_METHOD;
                    break;
                }
                case 5: {
                    this.method = this.SMALLINT_VARIABLE_METHOD;
                    break;
                }
                case 92: {
                    this.method = this.TIME_VARIABLE_METHOD;
                    break;
                }
                case 93: {
                    this.method = this.TIMESTAMP_VARIABLE_METHOD;
                    break;
                }
                case -6: {
                    this.method = this.TINYINT_VARIABLE_METHOD;
                }
            }
        } else {
            switch (this.colType) {
                case -5: {
                    this.method = this.BIG_INT_POSITIONAL_METHOD;
                    break;
                }
                case -7: 
                case 16: {
                    this.method = this.BOOLEAN_POSITIONAL_METHOD;
                    break;
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    this.method = this.VARCHAR_POSITIONAL_METHOD;
                    break;
                }
                case 91: {
                    this.method = this.DATE_POSITIONAL_METHOD;
                    break;
                }
                case 2: 
                case 3: {
                    this.method = this.DECIMAL_POSITIONAL_METHOD;
                    break;
                }
                case 8: {
                    this.method = this.DOUBLE_POSITIONAL_METHOD;
                    break;
                }
                case 6: 
                case 7: {
                    this.method = this.FLOAT_POSITIONAL_METHOD;
                    break;
                }
                case 4: {
                    this.method = this.INTEGER_POSITIONAL_METHOD;
                    break;
                }
                case 5: {
                    this.method = this.SMALLINT_POSITIONAL_METHOD;
                    break;
                }
                case 92: {
                    this.method = this.TIME_POSITIONAL_METHOD;
                    break;
                }
                case 93: {
                    this.method = this.TIMESTAMP_POSITIONAL_METHOD;
                    break;
                }
                case -6: {
                    this.method = this.TINYINT_POSITIONAL_METHOD;
                }
            }
        }
    }

    public static interface Method {
        public String transform() throws SQLException;
    }
}

